//For Brazilian proposal attribution of responsibility to regions
//created Louvain-la-neuve, July 2002

package jcm.pan;
import jcm.*;
import jcm.mod.*;
import jcm.gui.*; 
import java.awt.Color;

public class attributeplot extends regionplot {
	
	public attributeplot()  {
		toplist=new String[]{
			"co2fos&emit", "co2luc&emit", "ch4&emit", "n2o&emit",
				"co2&conc", "ch4&conc", "n2o&conc",
				"co2&rf", "ch4&rf", "n2o&rf", "tot&rf",
				"temp", "slte", ""}; 
		unitlist=new String[] {
			"mega&ton&carbon&per&yr", "mega&ton&carbon&per&yr", "mega&ton&ch4&per&yr", "mega&ton&nitrogen&per&yr",
				"ppm", "ppb", "ppb",
				"w&per&m2", "w&per&m2", "w&per&m2", "w&per&m2",
				"degC", "metres",""}; 
		perlist=new String[]{	"popn", "gnp", ""}; 
		punitlist=new String[]{	"mega&person", "giga&dollar&per&yr", ""}; 
		setlists(); 
	}; 
	
	public void setlists() {
		datalist=new float[][][] {
			responsibility.emitfos, responsibility.emitluc, responsibility.emitch4, responsibility.emitn2o,
				responsibility.atco2,  responsibility.atch4, responsibility.atn2o,
				responsibility.rfco2, responsibility.rfch4, responsibility.rfn2o,  responsibility.rftot,
				responsibility.surftemp, responsibility.sealevte,
				null}; 
		perdatalist=new float[][][] {	responsibility.pop, responsibility.gnp, null}; 
	}
	
	public param incunatt=new param("incunatt", true); 
	
	public option
		differentialopt=new option(responsibility.differential, this),
		simplecarbonopt=new option(responsibility.simplecarbon, this, "expert"),
		incunattopt=new option(incunatt, this)
		; 
	public control
		startyear=new control(responsibility.startyear, this, "x", "downarrow", dkblue, 5, 0),
		endyear=new control(responsibility.endyear, this, "x", "downarrow", dkred, 5, 0)
		; 
	
	public menu regionmenu=new menu(responsibility.regions, this); 
	
	public void precalc(iob i) {
		if (i==incunatt) {	if (!incunatt.istrue()) ncurves=responsibility.nreg; else ncurves=yd.length; bufi.changed=true; legend.newcurves(); }
		if (i==regionmenu && responsibility.emitfos!=datalist[0]) 	{	setnamecol(); legend.newcurves(); setlists(); makecurves(); makecurvearrays(); } 
		super.precalc(i); 
	}
	
	public void setinteractions() {
		super.setinteractions(); 
		incunatt.setaffectedby(varq); incunatt.setaffectedby(perq); incunatt.setaffectedby(rate); incunatt.setaffectedby(frac); incunatt.setaffectedby(stacked); legend.setaffectedby(incunatt); 
		incunatt.setaffectedby(responsibility.regions);
	}
	
	
	//********************************
	//constructors
	
	public void makelists(String top, String per) {
		stacked.flag=true; stacked.defflag=true; 
		xd=time.glx; 
		xscale.setup("yr", time.gsy,time.gey,50, 1.0); 
		setnamecol(); 
		setvarper(top, per); 
	}
	
	
	public void initsetup() {	legw=64; super.initsetup(); }
	
	public void setnamecol() {
		String[] rn=responsibility.regset.getnames(); 
		String[] exn=new String[] {	"unattr", "attribothghg", "aerosol", "solvar&and&volcano" }; 
		Color[] rc=responsibility.regset.getcols(); 
		Color[] exc=new Color[]{	black, grey, cyan, orange}; 
		curvename = new String[rn.length+4]; 
		curvecolor=new Color[rc.length+4]; 
		for (int i=0; i<rn.length; i++) {	curvename[i]=rn[i]; curvecolor[i]=rc[i]; }
		for (int i=0; i<4; i++) {	curvename[i+rn.length]=exn[i]; curvecolor[i+rn.length]=exc[i]; }
	}
	
	
	//***************************************************
	
} //end attributeplot
	
	
	