//this starter module enables JCM to be run standalone rather than as an applet
//so it's possible to use the latest version of Java,
//and to save files to hard disk - no security restrictions

package jcm;
import jcm.mod.modlist;
import java.awt.*;
import java.awt.event.*;
import java.net.*;

//import bsh.*;

public class startjcm {
	
	public static void main(String[] args) {
		
		/*
		Note: can make swing work with vjview if swingall.jar is in classpath
		import javax.swing.*;
		JFrame j=new JFrame("Java Climate Model"); j.pack(); j.show(); //test for swingall.jar
		*/
		
		/*
		try {
			Interpreter bsh= new bsh.Interpreter(); 
			System.out.println(bsh); 
			bsh.eval("print(\"hello from beanshell\");"); 
		} catch (Throwable e) {	e.printStackTrace(); }
		*/
		
		String classpath, codebase; 
		if (args.length<1) {
			//classpath=System.getProperty("java.class.path"); codebase=classpath.substring(2,classpath.length()-4);
			codebase=System.getProperty("user.dir").substring(1)+System.getProperty("file.separator")+"jcm"; 
		} else codebase=args[0]; 
		System.out.println("jcm codebase="+codebase); 
		try {	iob.codebase=  new URL("file://"+codebase); } catch (MalformedURLException e) {	System.out.println(e); }
		
		System.out.println("Loading Labels"); (new jcm.tls.labinf()).initsetup(); 
		System.out.println("Setup Model :..."); for (int m=0; m<modlist.nmods; m++) {	modlist.mod[m].initsetup(); System.out.println(modlist.mod[m].name); }; 
		System.out.println("Run Model :..."); modlist.regcli.output=true; loop.go(); 
		//note: setting up mainapp with a separate constructor caused problem in netscape running as applet! so do it here instead
		mainapp jcmapp=new mainapp(); 
		jcmapp.notapplet=true; 
		jcmapp.init(); 
		
		//loaddoc(); no need for this until standalone has a doc window!
		
		System.out.println("Opening main JCM window..."); 
		
		Frame mf=new Frame("Java Climate Model"); 
		
		mf.setResizable(true); 
		mf.addWindowListener(new WindowAdapter() {	public void windowClosing (WindowEvent e) {	System.exit(0); }}); 
		mf.reshape(0,0,800,600); 
		mf.show(); 
		
		mf.add(jcmapp, BorderLayout.CENTER); 
		mf.validate(); 
		
	}
	
}//end class


