//LABINF
//loads and interprets the labdoc files
//note this shouldn't depend on any other GUI, so could be used for text-only if required

package jcm.tls;
import jcm.*;

import java.io.*;
import java.net.*;

public class labinf extends iob {
	
	public static String[] langcode={	"en", "fr", "de", "es", "pt", "nl", "ru", "dk", "no", "zh", "sc"}; //,  "se",  "ar"};
	static boolean[][] loaded; 
	static boolean sorted=false; 
	public	static label[] label; //labdoc
	static String[] category; 
	static String[] smlc={	"", "`", "~", ""}; 
	
	public static param language=new param("languagemenu", langcode, ""); 
	
	
	//********************************
	//STANDALONE method to organise labdoc
	public static void main (String[] args)  {
		try {	iob.codebase=  new URL("file://c:/java/jcm/"); } catch (MalformedURLException e) {	System.out.println(e); }
		//loadsep();
		loadtab(); 
		savedoc(); 
	}
	
	//************************************
	//LOAD from big TABLE
	
	public static void loadtab() {
		String ls=fileio.loadstring("labdoc/jcmlabdoctab.txt", "UTF8"); 
		String[] items=txt.split(ls, "\n"); 
		int nk=items.length; 
		category=new String[0]; 
		String curcat=""; 
		String[] subit; 
		label=new label[nk]; 
		int l, m; 
		for (int k=0; k<nk; k++) {
			label[k]=new label(); 
			subit=txt.split(items[k], "\t"); 
			try {
				for (int i=0; i<subit.length; i++) if (subit[i].length()>0) {
					switch (i) {
						case 0:	category=(String[]) ref.add(category, subit[0]); curcat=subit[0]; break; 
						case 1:		label[k].key=subit[1]; break; 
						case 2:		label[k].info=subit[2]; break; 
						default:	l=i/3-1; m= i%3; 
						if (m==0)  label[k].sho[l]=subit[i]; 
						if (m==1)  label[k].med[l]=subit[i]; 
						if (m==2) label[k].doc[l]= txt.swap(subit[i], "\\", "\n"); 
					}
				}
			} catch (Exception e) {	debug (e+" "+k+"  "+items[k]); }
			label[k].cat=curcat; 
			label[k].fo=new Integer(k); 
		}
		sortkey(); 
	}
	
	//********************************
	//LOAD labdoc from SEPARATE files
	//this is used by the applet
	
	public static void load(int lang, int cati) {
		
		boolean newset=(label==null); 
		if (!newset) {	if (loaded[lang][cati+1]) return; else loaded[lang][cati+1]=true; }
		
		String filename=(cati==-1 ? "lab" : "doc_"+category[cati]); 
		String ls= fileio.loadstring("labdoc/"+filename +"_"+langcode[lang]+".txt", "UTF8"); 
		
		if (ls.length()<1) return; 
		String[] items=txt.split(ls, "#"); 
		String curcat="", key, dat; 
		boolean newlab; 
		int fk, nk=items.length, nl=langcode.length-1; 
		int[] split=new int[5]; 
		
		if (newset) {	label=new label[nk]; category=new String[0]; }
		
		for (int k=0; k<nk; k++) {
			if (items[k].indexOf("===>")>=0) {
				curcat=items[k].substring(items[k].indexOf("===>")+4, items[k].indexOf("<===")).trim(); 
				if (newset) category=(String[]) ref.add(category, curcat); 
				key=""; 
			}
			else key=txt.tonextspace(items[k],0); 
			
			if (newset) {	fk=k; newlab=true; }
			else {	fk= findkey(key); if (fk==-1) {	fk=extendarrays(1); newlab=true; debug("!added "+key); } else newlab=false; } //extendarrays inefficient -don't do often!
			
			if (newlab) {
				label[fk]=new label(); 
				label[fk].fo=new Integer(fk); 
				label[fk].cat=curcat; 
				label[fk].key=key; 
			}
			
			for (int j=0; j<4; j++) split[j]=items[k].indexOf(smlc[j]); split[4]=items[k].length(); 
			for (int j=3; j>=0; j--) {
				if (split[j]==-1 || split[j]>=split[j+1]) 	split[j]=split[j+1]; 
				else {
					dat=items[k].substring(split[j]+1, split[j+1]).trim(); 
					if (j==0 && newlab)  label[fk].info=dat; 
					if (j==1) label[fk].sho[lang]=dat; 
					if (j==2) label[fk].med[lang]=dat; 
					if (j==3) {
						dat=txt.swap(dat, "\r", ""); 
						dat=txt.swap(dat, "\n\n\n\n", "<p>"); 
						dat=txt.swap(dat, "\n\n", "<p>"); 
						dat=txt.swap(dat, "\n", "<br>"); 
						label[fk].doc[lang]=dat; 
					}
				}
			}
		}
		if (newset) {
			//can only make loaded array after identified all categories
			loaded=new boolean[nl][category.length+1]; for (int l=0; l<nl; l++) for (int c=0; c<category.length+1; c++) loaded[l][c]=false; 
			loaded[lang][0]=true; 
			sortkey(); 
		}
	}
	
	static int extendarrays(int e) {
		int k=label.length; 
		label[] newlab=new label[k+e]; System.arraycopy(label, 0, newlab, 0, k); label=newlab; 
		return k; 
	}
	
	
	//load ALL labels & doc from separate files - not tested!
	public static void loadsep() {
		for (int l=0; l<langcode.length-1; l++) {
			load(l, -1); 
			for (int c=0; c<category.length; c++) load(l, c); 
		}
	}
	
	
	//********************************
	//SAVE DOC
	
	public static void savedoc() {
		sort.sort(label, "fo"); 
		int oc=-999; boolean gotany, html=false; 
		String
			meta="<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'/>",
			style="<style> cat { color: orange font: bold 120% } dt { color: red} lab { color: brown } pop { color: green  } link { color: blue } note { font: italic 70% } icon, info { color: magenta; font: italic  } </style>",
			extlink="This is part of the labels / documentation for <a href='http://jcm.chooseclimate.org'>Java Climate Model</a><hr/>",
			head=(html ? "<html><head>"+meta+style+"</head><body>"+extlink+"<dl  compact>" : extlink),
			foot=(html ? "</dl></html>" : ""),
			iks; 
		StringBuffer[][] doc=new StringBuffer[category.length][langcode.length-1]; for  (int c=0; c<category.length; c++) for (int j=0; j<langcode.length-1; j++)  doc[c][j]=new StringBuffer(); 
		StringBuffer[] lab=new StringBuffer[langcode.length-1]; for (int j=0; j<langcode.length-1; j++)  lab[j]=new StringBuffer(); 
		StringBuffer csv=new StringBuffer(); 
		for (int i=0; i<label.length; i++) {
			int c=0; while (c<category.length-1 && !(label[i].cat!=null && label[i].cat.startsWith(category[c]))) c++; 
			csv.append("\n"+(oc!=c ? category[c] : "")+"\t"+ntb(label[i].key)+"\t"+ntb(label[i].info)); 
			if (oc!=c) {	oc=c; for (int j=0; j<langcode.length-1; j++)  lab[j].append( (html ? "</dl><hr/><dl compact><cat>" : "\n\n#! ===>")+category[c]+(html ? "</cat>" : "<===") ); }
			iks=(html ? "<dt>" : "#") +ntb(label[i].key)+  (html ? "</dt><dd> " : "" ) + (label[i].info!=null ?  (html ? "<info>" : "\t")+label[i].info + (html ? "</info> " : "")   :  "") ; 
			for (int j=0; j<langcode.length-1; j++) {
				if (label[i].sho[j]!=null || label[i].med[j]!=null || label[i].doc[j]!=null) lab[j].append(	"\n"+iks
					+(label[i].sho[j]!=null ? (html ? " <lab>" : "\t\t`")+label[i].sho[j]+ (html ? "</lab>" : "") : "" )
					+(label[i].med[j]!=null ? (html ? " <pop>" : "\t\t~")+label[i].med[j]+ (html ? "</pop>" : "") : "" )
					+(html ? "</dd>" : "")
					); 
				if (label[i].doc[j]!=null) 	doc[c][j].append("\n\n"+iks + (html ? "<doc>" +label[i].doc[j] +"</doc></dd>" : "\t\t"+ txt.swap(txt.swap(label[i].doc[j], "<p>" , "\n\n"), "<br>", "\n") ) ); 
				csv.append("\t"+ntb(label[i].sho[j])+"\t"+ntb(label[i].med[j])+"\t"+ntb(label[i].doc[j])); 
				//  (label[i].doc[j]==null ? "" : txt.swap(txt.swap(label[i].doc[j], "\n\r" , " <p> "), "\n", " <br>"))); shouldn't be necessary if we convert all line-ends on input
			}
		}
		fileio.savetextfile("c:/java/jcm/labdoc/out/jcmlabdoctab.txt", csv.toString(), "UTF8"); 
		for (int j=0; j<langcode.length-1; j++)  fileio.savetextfile("c:/java/jcm/labdoc/out/lab_"+langcode[j]+(html ? ".html" : ".txt"), head+lab[j].toString()+foot, "UTF8"); 
		for (int c=0; c<category.length; c++) for (int j=0; j<langcode.length-1; j++)  if (doc[c][j].length()>0)	fileio.savetextfile("c:/java/jcm/labdoc/out/doc_"+category[c]+"_"+langcode[j]+(html ? ".html" : ".txt"), head+doc[c][j].toString()+foot, "UTF8"); 
		sortkey(); 
	}
	
	//********************************
	//FETCH LABELS
	
	public static String getshort(String requestkey) {	return getlabel(requestkey,1); }
	public static String getshortfordoc(String requestkey) {	return getlabel(requestkey,1)+autodoc.typefordoc(requestkey); }
	public static String getlabel(String requestkey) {	return getlabel(requestkey,2); }
	
	public static String getextralabel(String requestkey) {
		String popup=getlabel(requestkey); 
		if (!popup.equals(getshort(requestkey)) && !popup.equals(getdoc(requestkey))) return getlabel(requestkey); 
		else return ""; 
	}
	
	public static String getdoc(String requestkey) {
		if (requestkey.equals("doclist")) return doclist(); 
		if (requestkey.equals("docsearch")) return docsearch(); 
		return getlabel(requestkey,3); 
	}
	
	public static String getlabel(String requestkey, String c) {	int i=0; while (i<smlc.length && !(c.equals(smlc[i]))) {	i++; } return getlabel (requestkey, i); }
	
	public static String getlabel(String requestkey, int sml) {
		try {
			if (language.chosen.equals("sc") && sml<3) return requestkey; 
			if (requestkey=="") return ""; 
			
			int lang=language.getchosenindex(); 
			if (label==null) load(0,-1); 
			load(lang, -1); 
			
			int nk=findkey(requestkey); 
			if (nk<0) {	//if key not found...
				int split=requestkey.indexOf("&"); 
				if (split<0) return ((sml<3) ? requestkey : ""); //return requestkey for short/medium, nothing for doc
				else {	//interpret multi-component labels separated by "&"
					if (split>=requestkey.length()-1)  return getlabel(requestkey.substring(0,split), sml); //ignore trailing &
					String label1=getlabel(requestkey.substring(0,split), sml), label2=getlabel(requestkey.substring(split+1), sml); 
					return label1+(label1.length()>1 ? " " : "") +label2; 
				}
			}
			
			int cat=0; while (cat<category.length && !category[cat].equals(label[nk].cat)) cat++; 
			if (cat==category.length) {	debug(label[nk].key+ " has no category"); return ""; }
			
			if (sml==3) {	load(0, cat); load(lang, cat); }
			return label[nk].getsml(lang, sml); 
			
		} catch (RuntimeException e ) {	iob.debug (" getlabel "+smlc[sml]+requestkey+" : "+e); return  ((sml<3) ? "!" : "can't find ") +requestkey; }
	}
	
	
	public static int findkey(String k){
		if (sorted) return sort.find(k, label, "key"); //faster method if sorted by keys
		else for (int i=0; i<label.length; i++) if (label[i].key!=null && k.equals(label[i].key)) return i; return -1; 
	}
	
	public static void sortkey() {	sort.sort(label, "key"); sorted=true; }
	
	public static  String ntb (String s) {	return s==null ? "" : s; }
	
	
	//******************************************************
	//DOCLIST
	
	public static String doclist() {
		int l=language.getchosenindex(); load(l, -1); for (int c=0; c<category.length; c++) load(l, c); 
		String[][] list=new String[label.length][2]; String u; 
		for (int i=0; i<label.length; i++) {
			try {
				if (!label[i].key.startsWith("!") && !label[i].key.equals("doclist") && label[i].key.length()>1){
					u=" "+(getextralabel(label[i].key) !=getshortfordoc(label[i].key) ? getextralabel(label[i].key)+" " : "" ); 
					list[i][1]= (label[i].doc[0]!=null)  ? autodoc.link(label[i].key)+u : ""+ getshortfordoc(label[i].key)+u+"" ; 
				}
			} catch (Exception e) {	list[i][1]="key "+i+": "+e; }
			list[i][0]=getshortfordoc(label[i].key); //it will sort by this
		}
		sort.sort(list); 
		StringBuffer s=new StringBuffer(""); 
		for (int i=0; i<label.length ; i++) if (list[i][1]!=null ) s.append("<li>"+list[i][1]); 
		return  "doclistinfo "+ s.toString(); 
	}
	
	
	//********************************
	//SEARCH
	
	public static void search(String s, boolean a, boolean t) {
		searchstring=s; anywords=a; titlesonly=t; 
		showwebpage.showinfo(autodoc.makedoc("docsearch")); 
	}
	
	public static String docsearch() {
		return searchbox()+searchresults(); 
	}
	
	public static String searchbox() {
		return "<form><input id=searchbox type=text size=30 style='font:75%' value='"+searchstring+"'  > <br>"
			//			+" `anywords <input id=andor type=checkbox "+(anywords ? "checked" : "")+" > "
		//			+" `onlytitles <input id=incdoc disabled type=checkbox "+(titlesonly ? "checked" : "")+" > "
		+" <input type=button style='font:75%' value='`searchgo' onclick=\"jcm.search(searchbox.value, false, false); \" >"
			//andor.checked, incdoc.checked
		+" <br> searchresults "; 
	}
	
	
	public static String searchstring=""; 
	public static boolean anywords=false, titlesonly=false; 
	
	public static String searchresults() {
		if (searchstring.equals("")) return ""; 
		else {
			boolean include, found, f; 
			float score, score2; int rmax=50, overflow=200, nr=0; 
			String[] ss=txt.split(searchstring.trim()," ", true),  rs=new String[rmax+overflow], rs2; 
			StringBuffer out=new StringBuffer(""); String p, q; 
			for (int i=0; i<label.length; i++) {
				include=!anywords; score=1; 
				try{
					for (int j=0; j<ss.length; j++)	{
						q=ss[j].toLowerCase(); 
						found=false; score2=0; 
						for (int k=1; k<(titlesonly ? 3 : 4); k++) 	{
							p=(k<3 ? getlabel(label[i].key, k) : autodoc.parse(getlabel(label[i].key, k), iob.findiob(label[i].key), false)).toLowerCase(); 
							if (p.length()>0) for (int r=-1; (r=p.indexOf(q, r+1))>0; ) {	found=true; score2+=10f/Math.pow(1000+p.length(),0.33); }
						}
						if (anywords)  include |=found; else include &=found; 
						score*=score2; 
					}
					if (include) {
						rs[nr]="<li>("+(score<100 ? " " : "")+(score<10 ? " " : "")+(int)score+") @"+label[i].key+" "+getextralabel(label[i].key); 
						nr++; if (nr>(rmax+overflow)) {	sort.sort(rs); nr=rmax; }
					}
				} catch (RuntimeException e) {	debug (label[i].key+": "+e); }
			}
			if (nr>rmax) nr=rmax; rs2=new String[nr]; System.arraycopy(rs, 0, rs2, 0, nr); 
			sort.sort(rs2); 
			for (int n=nr-1; n>-1; n--) out.append(rs2[n]); 
			return out.insert(0, "  `searchresults ").toString(); 
		}
	}
	
	
	
} //end class
		
		
		
