//quicksort of array of objects according to a specified field, 
//also finds an item quickly from a sorted array

package jcm.tls;
import jcm.*;
import java.lang.reflect.*;

public class sort {
	
	public static Field stf (Object[] k, String s) {
		try {	return k[0].getClass().getField(s); }
		catch (NoSuchFieldException e) {	System.out.println("sort: "+e); return null; }
	}
	
	public static Object get(Object o, Field f) {
		try {
			if (f!=null) return f.get(o); 
			if (o.getClass().isArray()) return Array.get(o,0); 
			else return o; 
		} catch (Exception e) {	System.out.println("sort: "+o+e); return null; }
	}
	
	public static void sort(Object[] k, String s) {	sort(k,  stf(k,s) , 0, k.length-1); }
	public static void sort(Object[] k, Field f) {	sort(k,  f, 0, k.length-1); }
	public static void sort(Object[] k) {	sort(k,  null, 0, k.length-1); }
	
	static void sort(Object[] k, Field f,  int lo0, int hi0)  {
		int lo = lo0, hi = hi0; Object mid; 
		if ( hi0 > lo0)	{
			mid = k[( lo0 + hi0 ) / 2]; 
			while( lo <= hi )     {
				while( ( lo < hi0 ) && ( compare( get(k[lo],f), get(mid,f))  < 0 ))  ++lo; 
				while( ( hi > lo0 ) && ( compare( get(k[hi],f), get(mid,f))  >0 ))  --hi; 
				if( lo <= hi )  {	swap(k, lo, hi); ++lo; --hi; }
			}
			if( lo0 < hi ) sort(k, f, lo0, hi); 
			if( hi0 > lo ) sort(k, f, lo, hi0); 
		}
	}
	
	static int compare(Object a, Object b) {
		if (a==b) return 0; if (a==null) return 1; if (b==null) return -1; 
		if (a instanceof String) return ((String)a).toLowerCase().compareTo(((String)b).toLowerCase()); 
		if (a instanceof Integer) {
			int aa=((Integer)a).intValue(), bb=((Integer)b).intValue(); 
			return ( aa  >bb  ? 1 : aa < bb ? -1 : 0 ); 
		}
		return 0; 
	}
	
	static void swap(Object[] k, int a, int b)  {	Object ka=k[a]; k[a]=k[b]; k[b]=ka; }
	
	public static int find(Object a, Object[] k) {	return	find(a, k,  null, 0, k.length); }
	public static int find(Object a, Object[] k, String s) {	return	find(a, k,  stf(k,s)); }
	public static  int find(Object a, Object[] k, Field f){	return find(a, k, f, 0, k.length); }
	
	static  int find(Object a, Object[] k, Field f, int lo, int hi){
		int c=compare(a, get(k[(lo+hi)/2],f)); 
		if (c==0) return (lo+hi)/2; 
		if (hi==lo+1) {	if (hi<k.length && a.equals(get(k[hi],f))) return hi; return -1; }
		if (c>0) return find(a, k, f, (lo+hi)/2, hi); else return find(a, k, f, lo, (lo+hi)/2); 
	}
	
	
} //end sort
