
public interface sresdata {

//***************************************************************
// FUTURE EMISSIONS DATA
//below are tables taken from SRES appendix of IPCC TAR WG1 report
//for the 7 scenarios and years 2000-2100

//CO2, in GtC, note emissions arrays stored in MtC!
double fosemit[][]={
{6.90,6.90,6.90,6.90,6.90,6.90,7.1},
{9.68,8.33,8.65,8.46,8.50,7.99,8.68},
{12.12,10.00,11.19,11.01,10.00,9.02,10.26},
{14.01,12.26,14.61,13.53,11.20,10.15,11.62},
{14.95,12.60,18.66,15.01,12.20,10.93,12.66},
{16.01,12.29,23.10,16.49,11.70,11.23,13.7},
{15.70,11.41,25.14,18.49,10.20,11.74,14.68},
{15.43,9.91,27.12,20.49,8.60,11.87,15.66},
{14.83,8.05,29.04,22.97,7.30,12.46,17.0},
{13.94,6.27,29.64,25.94,6.10,13.20,18.7},
{13.10,4.31,30.32,28.91,5.20,13.82,20.4}
};

//landuse change CO2 GtC
double lucemit[][]={ 
{1.07,1.07,1.07,1.07,1.07,1.07,1.3},
{1.20,1.04,1.08,1.12,0.78,0.80,1.22},
{0.52,0.26,1.55,1.25,0.63,0.03,1.14},
{0.47,0.12,1.57,1.19,-0.09,-0.25,1.04},
{0.40,0.05,1.31,1.06,-0.48,-0.24,0.92},
{0.37,-0.02,0.80,0.93,-0.41,-0.23,0.8},
{0.30,-0.03,0.55,0.67,-0.46,-0.24,0.54},
{0.30,-0.03,0.16,0.40,-0.42,-0.25,0.28},
{0.35,-0.03,-0.36,0.25,-0.60,-0.31,0.12},
{0.36,-0.01,-1.22,0.21,-0.78,-0.41,0.06},
{0.39,0.00,-2.08,0.18,-0.97,-0.50,-0.1}
};

//SOx Tg S/yr
double soxemit[][]={
{69.0, 69.0, 69.0, 69.0, 69.0, 69.0, 79.0},
{87.1, 64.7, 80.8, 74.7, 73.9, 65.9, 95.0},
{100.2, 59.9, 86.9, 99.5, 74.6, 61.3, 111.0},
{91.0, 59.6, 96.1, 112.5, 78.2, 60.3, 125.8},
{68.9, 45.9, 94.0, 109.0, 78.5, 59.0, 139.4},
{64.1, 40.2, 80.5, 105.4, 68.9, 55.7, 153.0},
{46.9, 34.4, 56.3, 89.6, 55.8, 53.8, 151.8},
{35.7, 30.1, 42.6, 73.7, 44.3, 50.9, 150.6},
{30.7, 25.2, 39.4, 64.7, 36.1, 50.0, 149.4},
{29.1, 23.3, 39.8, 62.5, 29.8, 49.0, 148.2},
{27.6, 20.2, 40.1, 60.3, 24.9, 47.9, 147.0}
};

//methane Tg CH4/yr
double[][] ch4emit={ 
{323, 323, 323, 323, 323, 323, 390},
{373, 362, 359, 370, 349, 349, 433},
{421, 415, 416, 424, 377, 384, 477},
{466, 483, 489, 486, 385, 426, 529},
{458, 495, 567, 542, 381, 466, 580},
{452, 500, 630, 598, 359, 504, 630},
{410, 459, 655, 654, 342, 522, 654},
{373, 404, 677, 711, 324, 544, 678},
{341, 359, 695, 770, 293, 566, 704},
{314, 317, 715, 829, 266, 579, 733},
{289, 274, 735, 889, 236, 597, 762}
};

//N2O Tg N/yr
double[][] n2oemit={
{7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 5.5},
{7.0, 6.1, 8.0, 8.1, 7.5, 6.2, 6.2},
{7.2, 6.1, 9.3, 9.6, 8.1, 6.1, 7.1},
{7.3, 6.2, 10.9, 10.7, 8.2, 6.1, 7.7},
{7.4, 6.2, 12.8, 11.3, 8.3, 6.2, 8.0},
{7.4, 6.1, 14.5, 12.0, 8.3, 6.3, 8.3},
{7.3, 6.0, 15.0, 12.9, 7.7, 6.4, 8.3},
{7.2, 5.7, 15.4, 13.9, 7.4, 6.6, 8.4},
{7.1, 5.6, 15.7, 14.8, 7.0, 6.7, 8.5},
{7.1, 5.5, 16.1, 15.7, 6.4, 6.8, 8.6},
{7.0, 5.4, 16.6, 16.5, 5.7, 6.9, 8.7}
};

//NOx Tg N/yr (=NO+NO2)
double[][] noxemit={
{32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 37.0},
{39.3, 38.8, 39.7, 39.2, 36.1, 36.7, 43.4},
{46.1, 46.4, 50.4, 50.3, 39.9, 42.7, 49.8},
{50.2, 55.9, 62.8, 60.7, 42.0, 48.9, 55.2},
{48.9, 59.7, 77.1, 65.9, 42.6, 53.4, 59.6},
{47.9, 61.0, 94.9, 71.1, 38.8, 54.5, 64.0},
{46.0, 59.6, 102.1, 75.5, 34.3, 56.1, 67.8},
{44.2, 51.7, 108.5, 79.8, 29.6, 56.3, 71.6},
{42.7, 42.8, 115.4, 87.5, 25.7, 59.2, 75.4},
{41.4, 34.8, 111.5, 98.3, 22.2, 60.9, 79.2},
{40.2, 28.1, 109.6, 109.2, 18.7, 61.2, 83.0}
};

//CO Tg CO/yr
double[][] coemit={
{877, 877, 877, 877, 877, 877, 1048},
{1002, 1003, 1020, 977, 789, 935, 1096},
{1032, 1147, 1204, 1075, 751, 1022, 1145},
{1109, 1362, 1436, 1259, 603, 1111, 1207},
{1160, 1555, 1726, 1344, 531, 1220, 1282},
{1214, 1770, 2159, 1428, 471, 1319, 1358},
{1245, 1944, 2270, 1545, 459, 1423, 1431},
{1276, 2078, 2483, 1662, 456, 1570, 1504},
{1357, 2164, 2776, 1842, 426, 1742, 1576},
{1499, 2156, 2685, 2084, 399, 1886, 1649},
{1663, 2077, 2570, 2326, 363, 2002, 1722}
};

//Black carbon and Organic Carbon are just scaled to CO offset to 1036 (i.e.add 1036-CO2000)
//BC 2000=12.4, OC=81.4 Tg/yr 
//see OGHGA module

//VOC Tg/yr check =Tg C or total?
double[][] vocemit={ 
{141, 141, 141, 141, 141, 141, 126},
{178, 164, 166, 155, 141, 159, 142},
{222, 190, 192, 179, 140, 180, 158},
{266, 212, 214, 202, 131, 199, 173},
{272, 229, 256, 214, 123, 214, 188},
{279, 241, 322, 225, 116, 217, 202},
{284, 242, 361, 238, 111, 214, 218},
{289, 229, 405, 251, 103, 202, 234},
{269, 199, 449, 275, 99, 192, 251},
{228, 167, 435, 309, 96, 178, 267},
{193, 128, 420, 342, 87, 170, 283}
};

//******************************
// HFCs, PFcs and SF6
//Note all A1 are the same, also removed the p scenarios
//A1, A2, B1, B2, 

//C4F10 emissions (kt/yr) - no longer used, in p *only* (all same) note also 1.0 in 1990!
//double[][] c4f10emit={7.5, 9.3, 12.0, 14.8, 18.0, 21.7, 25.7, 28.5, 30.4, 32.1, 33.6); 

//SF6, emissions, (kt/yr)
double[][] sf6={
{6.2, 6.2, 6.2, 6.2},
{6.7, 7.6, 5.6, 7.4},
{7.3, 9.7, 5.7, 8.4},
{10.2, 11.6, 7.2, 9.2},
{15.2, 13.7, 8.9, 11.7},
{18.3, 16.0, 10.4, 12.1},
{19.5, 18.8, 10.9, 12.2},
{17.3, 19.8, 9.5, 11.4},
{13.5, 20.7, 7.1, 9.6},
{13.0, 23.4, 6.5, 10.0},
{14.5, 25.2, 6.5, 10.6}
};


//CF4, emissions, (kt/yr)
double[][] cf4={
{12.6, 12.6, 12.6, 12.6},
{15.3, 20.3, 14.5, 21.0},
{21.1, 25.2, 15.7, 27.1},
{30.1, 31.4, 16.6, 34.6},
{38.2, 37.9, 18.5, 43.6},
{43.8, 45.6, 20.9, 52.7},
{48.1, 56.0, 23.1, 59.2},
{52.1, 63.6, 22.5, 63.1},
{56.1, 73.2, 21.3, 64.2},
{58.9, 82.8, 22.5, 62.9},
{57.0, 88.2, 22.2, 59.9}
};

//C2F6, emissions, (kt/yr)
double[][] c2f6={
{1.3, 1.3, 1.3, 1.3},
{1.5, 2.0, 1.5, 2.1},
{2.1, 2.5, 1.6, 2.7},
{3.0, 3.1, 1.7, 3.5},
{3.8, 3.8, 1.8, 4.4},
{4.4, 4.6, 2.1, 5.3},
{4.8, 5.6, 2.3, 5.9},
{5.2, 6.4, 2.2, 6.3},
{5.6, 7.3, 2.1, 6.4},
{5.9, 8.3, 2.2, 6.3},
{5.7, 8.8, 2.2, 6.0}
};

//HFC-23, emissions, (kt/yr) 
double[][] hfc23={
{13, 13, 13, 13},
{15, 15, 15, 15},
{5, 5, 5, 5},
{2, 2, 2, 2},
{2, 2, 2, 2},
{1, 1, 1, 1},
{1, 1, 1, 1},
{1, 1, 1, 1},
{1, 1, 1, 1},
{1, 1, 1, 1},
{1, 1, 1, 1}
};

//HFC-134a, emissions, (kt/yr) note includes IS92a at end
double[][] hfc134a={
{80, 80, 80, 80, 148},
{176, 166, 163, 166, 290},
{326, 252, 249, 262, 396},
{515, 330, 326, 352, 557},
{725, 405, 414, 443, 738},
{931, 506, 547, 561, 918},
{1076, 633, 550, 679, 969},
{1078, 758, 544, 799, 1020},
{1061, 915, 533, 910, 1047},
{1029, 1107, 513, 1002, 1051},
{980, 1260, 486, 1079, 1055}
};

//HFC-152a, emissions, (kt/yr) IS92a ONLY
double[][] hfc152a={
{0,0,0,0,0}, 
{0,0,0,0,0}, 
{0,0,0,0,18}, 
{0,0,0,0,114}, 
{0,0,0,0,281}, 
{0,0,0,0,448}, 
{0,0,0,0,495}, 
{0,0,0,0,542}, 
{0,0,0,0,567}, 
{0,0,0,0,568}, 
{0,0,0,0,570}
}; 

//HFC-125, emissions, (kt/yr) note includes IS92a at end
double[][] hfc125={  
{0, 0, 0, 0, 0},
{12, 11, 11, 11, 1},
{27, 21, 21, 22, 9},
{45, 29, 29, 30, 46},
{62, 35, 36, 38, 111},
{80, 46, 48, 49, 175},
{94, 56, 48, 58, 185},
{98, 66, 48, 67, 194},
{100, 79, 48, 76, 199},
{101, 94, 46, 83, 199},
{101, 106, 44, 89, 199}
};

//HFC-32, emissions, (kt/yr)
double[][] hfc32={
{0, 0, 0, 0},
{4, 4, 3, 3},
{8, 6, 6, 6},
{14, 9, 8, 9},
{19, 11, 10, 11},
{24, 14, 14, 14},
{28, 17, 14, 17},
{29, 20, 14, 20},
{30, 24, 14, 22},
{30, 29, 14, 24},
{30, 33, 13, 26}
};

//HFC-143a, emissions, (kt/yr)
double[][] hfc143a={
{0, 0, 0, 0},
{9, 9, 8, 8},
{21, 16, 15, 16},
{34, 22, 21, 22},
{47, 27, 26, 27},
{61, 35, 35, 35},
{70, 43, 35, 42},
{74, 51, 35, 49},
{75, 61, 35, 55},
{76, 73, 34, 60},
{76, 82, 32, 65},
};

//HFC-227ea, emissions, (kt/yr)
double[][] hfc227ea={
{0, 0, 0, 0},
{13, 12, 13, 14},
{22, 17, 18, 20},
{34, 21, 24, 26},
{48, 26, 30, 33},
{62, 32, 39, 41},
{72, 40, 40, 50},
{71, 48, 39, 59},
{68, 58, 38, 67},
{65, 70, 36, 74},
{61, 80, 34, 80}
};


//HFC-245ca, emissions, (kt/yr)
double[][] hfc245ca={
{0, 0, 0, 0},
{62, 59, 60, 61},
{100, 79, 80, 85},
{158, 98, 102, 112},
{222, 121, 131, 144},
{292, 149, 173, 178},
{350, 190, 173, 216},
{343, 228, 170, 255},
{330, 276, 166, 290},
{312, 334, 159, 323},
{288, 388, 150, 353}
};

//HFC43-10mee, emissions, (kt/yr)
double[][] hfc4310mee={
{0, 0, 0, 0},
{7, 7, 6, 6},
{9, 8, 7, 7},
{12, 8, 8, 8},
{15, 9, 9, 10},
{18, 11, 11, 11},
{22, 12, 11, 12},
{24, 14, 11, 14},
{27, 16, 11, 15},
{29, 19, 11, 17},
{30, 22, 10, 18}
};

double[][][] hfcemit={sf6, cf4, c2f6, hfc23, hfc134a, hfc152a, hfc125, hfc32, hfc143a, hfc227ea, hfc245ca, hfc4310mee};

//**********************************************
// REGIONAL DATA
//Below are emissions data for 12 regions,
//taken from RIVM IMAGE  CD-ROM
//using nearest equivalent region or sum of regions
//data are fractions of total, *1000
//JCM regions are USA, CAN, JAP, WEU, EEU, RUB, MEC, CHI, SCA, OAS, AFR, IND 
//note IMAGE puts the "-stan"s in with RUB not MEC, and IND corresponds to South-Asia inc Pakistan/Bangladesh

int regfosemit[][][]= {
//A1B
{
{252, 38, 54, 152, 32, 84, 54, 150, 59, 32, 37, 54},
{213, 35, 44, 136, 35, 75, 62, 168, 78, 38, 44, 73},
{175, 28, 35, 116, 37, 74, 70, 174, 96, 45, 54, 98},
{138, 23, 28, 95, 34, 70, 75, 176, 104, 52, 70, 135},
{114, 20, 23, 77, 29, 69, 82, 165, 103, 59, 86, 172},
{102, 17, 18, 69, 25, 69, 89, 149, 92, 63, 107, 201},
{98, 16, 16, 67, 22, 70, 90, 145, 80, 63, 127, 207},
{102, 16, 16, 69, 20, 68, 85, 146, 78, 62, 144, 195},
{111, 16, 16, 71, 18, 65, 80, 143, 80, 61, 157, 183},
{120, 16, 17, 71, 16, 59, 79, 135, 80, 60, 164, 182},
{129, 16, 18, 71, 14, 54, 79, 127, 80, 60, 166, 185}
},
//A1T
{
{252, 38, 54, 152, 32, 83, 55, 150, 59, 32, 37, 54},
{213, 35, 45, 137, 35, 74, 62, 167, 77, 38, 44, 72},
{177, 28, 36, 118, 38, 73, 69, 172, 95, 44, 53, 96},
{141, 24, 29, 97, 35, 71, 75, 173, 103, 50, 70, 130},
{117, 21, 24, 79, 30, 70, 83, 162, 101, 58, 87, 168},
{103, 18, 19, 70, 25, 69, 91, 147, 90, 61, 108, 199},
{97, 16, 16, 68, 21, 69, 91, 143, 80, 62, 129, 208},
{100, 15, 16, 69, 19, 66, 87, 145, 78, 62, 147, 196},
{107, 16, 16, 71, 17, 63, 84, 143, 80, 60, 165, 178},
{114, 16, 17, 71, 15, 59, 83, 131, 80, 60, 176, 177},
{120, 17, 18, 72, 15, 56, 83, 123, 80, 58, 185, 173}
},
//A1F
{
{252, 38, 54, 153, 32, 84, 54, 150, 59, 32, 37, 54},
{213, 35, 44, 136, 35, 75, 62, 168, 77, 38, 44, 72},
{177, 28, 34, 117, 37, 74, 68, 176, 95, 44, 54, 97},
{141, 23, 28, 97, 35, 70, 72, 178, 104, 51, 68, 133},
{117, 20, 24, 80, 30, 67, 76, 168, 106, 59, 83, 169},
{104, 17, 20, 70, 25, 64, 80, 155, 96, 63, 104, 203},
{98, 16, 17, 65, 21, 62, 82, 149, 83, 64, 123, 219},
{100, 15, 16, 64, 19, 59, 81, 148, 78, 64, 139, 217},
{105, 16, 16, 65, 18, 57, 76, 144, 79, 64, 150, 210},
{110, 16, 17, 65, 16, 53, 75, 136, 79, 64, 158, 210},
{114, 16, 18, 65, 14, 49, 75, 128, 79, 64, 169, 209}
},
//A2
{
{253, 38, 54, 152, 33, 84, 54, 151, 59, 33, 37, 53},
{233, 36, 45, 141, 30, 74, 65, 155, 79, 34, 45, 61},
{209, 32, 37, 128, 30, 69, 78, 151, 101, 36, 55, 74},
{183, 29, 32, 111, 31, 68, 90, 155, 110, 37, 67, 88},
{160, 26, 29, 92, 30, 69, 100, 157, 111, 39, 82, 103},
{145, 23, 24, 78, 29, 71, 109, 159, 107, 42, 96, 116},
{137, 22, 20, 70, 27, 74, 115, 163, 102, 44, 104, 122},
{132, 22, 17, 67, 26, 79, 117, 170, 100, 46, 106, 121},
{132, 22, 15, 66, 24, 83, 110, 178, 104, 50, 104, 112},
{137, 22, 14, 65, 22, 86, 98, 186, 111, 55, 98, 105},
{141, 22, 14, 64, 20, 88, 86, 191, 117, 59, 93, 105}
},
//B1
{
{252, 38, 54, 152, 33, 84, 55, 150, 59, 32, 38, 54},
{219, 36, 44, 140, 31, 74, 65, 158, 81, 36, 49, 66},
{187, 29, 34, 121, 32, 65, 78, 158, 107, 40, 63, 85},
{154, 24, 27, 103, 31, 60, 87, 155, 120, 45, 82, 111},
{129, 21, 23, 88, 28, 60, 93, 147, 120, 49, 102, 141},
{112, 18, 19, 78, 24, 59, 98, 137, 110, 54, 121, 170},
{102, 15, 16, 73, 21, 57, 101, 129, 100, 57, 138, 191},
{103, 14, 15, 72, 19, 54, 100, 123, 91, 59, 148, 203},
{111, 13, 14, 75, 17, 51, 97, 123, 86, 60, 157, 196},
{124, 14, 15, 79, 16, 48, 95, 121, 83, 58, 160, 187},
{141, 15, 16, 85, 15, 45, 90, 118, 81, 56, 162, 176}
},
//B2
{
{253, 38, 54, 152, 33, 83, 54, 150, 59, 33, 38, 54},
{219, 35, 43, 134, 30, 71, 62, 172, 74, 41, 45, 73},
{184, 29, 33, 112, 31, 67, 68, 188, 87, 49, 51, 100},
{151, 24, 27, 93, 33, 65, 72, 199, 88, 56, 60, 133},
{127, 22, 22, 76, 33, 68, 78, 195, 86, 64, 75, 154},
{113, 20, 18, 66, 32, 74, 87, 182, 86, 66, 92, 164},
{100, 18, 14, 62, 29, 74, 96, 179, 89, 64, 108, 167},
{95, 16, 12, 61, 27, 72, 98, 181, 90, 63, 119, 167},
{92, 15, 9, 61, 25, 70, 97, 183, 90, 65, 130, 163},
{90, 14, 7, 62, 23, 65, 94, 183, 93, 67, 140, 161},
{89, 13, 5, 61, 21, 58, 90, 185, 95, 68, 147, 168}
}
}; //end regemit[][][]

//in case need it, below is equivalent IMAGE data for 1970-2000
//{289, 37, 55, 221, 48, 152, 36, 73, 40, 7, 25, 17},
//{252, 34, 52, 173, 55, 186, 36, 99, 54, 12, 30, 19},
//{238, 36, 51, 161, 44, 156, 39, 137, 49, 21, 34, 33},
//{252, 38, 54, 152, 32, 84, 54, 150, 59, 32, 37, 54}

//likewise population data in millions (data not shares!)
//last column is world total

int pop[][][]={
//A1B, A1T, A1F, B1
{
{280, 60, 128, 393, 122, 296, 245, 1377, 518, 510, 826, 1362, 6118},
{303, 65, 133, 406, 124, 303, 303, 1452, 590, 566, 1056, 1590, 6891},
{327, 69, 135, 416, 124, 309, 365, 1508, 655, 617, 1299, 1799, 7623},
{350, 72, 136, 425, 123, 312, 422, 1520, 706, 656, 1510, 1957, 8190},
{370, 75, 136, 429, 120, 313, 468, 1491, 739, 678, 1667, 2056, 8541},
{385, 76, 134, 427, 116, 307, 510, 1420, 755, 681, 1801, 2106, 8716},
{398, 77, 131, 420, 110, 298, 540, 1316, 752, 664, 1882, 2093, 8681},
{413, 78, 128, 412, 104, 288, 558, 1201, 733, 633, 1908, 2021, 8478},
{430, 78, 124, 407, 98, 276, 564, 1085, 703, 592, 1880, 1901, 8141},
{447, 79, 122, 403, 93, 265, 557, 969, 663, 543, 1797, 1736, 7673},
{461, 79, 118, 394, 87, 252, 532, 854, 611, 486, 1663, 1534, 7070}
},
//A2
{
{281, 61, 129, 395, 123, 298, 247, 1399, 523, 517, 830, 1368, 6171},
{309, 66, 135, 413, 127, 313, 314, 1562, 624, 599, 1081, 1628, 7171},
{337, 71, 137, 425, 127, 328, 393, 1725, 729, 681, 1356, 1887, 8196},
{365, 76, 138, 437, 127, 345, 486, 1900, 842, 763, 1639, 2136, 9254},
{391, 80, 139, 446, 126, 369, 591, 2084, 960, 845, 1912, 2366, 10310},
{417, 85, 139, 451, 125, 394, 704, 2256, 1079, 920, 2172, 2567, 11309},
{447, 89, 140, 457, 123, 426, 821, 2444, 1199, 993, 2399, 2730, 12268},
{483, 95, 142, 469, 122, 463, 936, 2646, 1323, 1061, 2574, 2844, 13158},
{526, 101, 146, 485, 123, 501, 1040, 2848, 1447, 1119, 2682, 2905, 13922},
{574, 108, 151, 505, 124, 540, 1129, 3042, 1571, 1166, 2723, 2911, 14543},
{628, 115, 156, 529, 127, 580, 1211, 3224, 1698, 1204, 2731, 2883, 15086}
},
//B2
{
{282, 61, 127, 391, 121, 294, 244, 1343, 510, 526, 827, 1367, 6093},
{303, 65, 130, 399, 121, 296, 298, 1448, 584, 589, 1065, 1599, 6896},
{326, 68, 129, 402, 120, 298, 350, 1549, 653, 643, 1339, 1803, 7680},
{341, 70, 126, 401, 118, 297, 398, 1617, 714, 692, 1619, 1989, 8384},
{347, 71, 123, 394, 116, 295, 441, 1649, 766, 730, 1870, 2143, 8946},
{351, 71, 119, 384, 114, 292, 477, 1660, 804, 756, 2092, 2265, 9386},
{355, 70, 109, 381, 111, 285, 512, 1660, 832, 759, 2297, 2356, 9726},
{358, 69, 98, 377, 109, 280, 540, 1665, 851, 759, 2462, 2418, 9985},
{361, 67, 85, 379, 109, 275, 564, 1672, 865, 752, 2592, 2464, 10185},
{364, 65, 71, 383, 109, 272, 585, 1682, 876, 740, 2685, 2502, 10335},
{366, 63, 57, 390, 111, 268, 604, 1691, 884, 725, 2746, 2539, 10444}
}
}; //end regpop[][][]

//and pop data from 1970-2000
//{210, 41, 104, 351, 108, 243, 102, 897, 284, 287, 364, 726, 3716},
//{230, 47, 117, 367, 117, 265, 137, 1079, 359, 360, 476, 909, 4464},
//{254, 54, 124, 377, 122, 290, 192, 1247, 438, 442, 629, 1132, 5302},
//{282, 61, 127, 391, 121, 294, 244, 1343, 510, 526, 827, 1367, 6093},

//***********************************************

//IMAGE GDP per capita for JCM regions *US$(1995)/cap/yr
int[][][] gdppc={
//A1
{
{31210, 19214, 42385, 23769, 3290, 1600, 3516, 1778, 3945, 1502, 621, 422, 5354},
{38812, 23236, 47815, 29563, 5469, 2658, 4727, 3495, 5505, 2387, 850, 778, 6726},
{45756, 27100, 53955, 36531, 9936, 4992, 7074, 6721, 8402, 4103, 1360, 1595, 8854},
{52704, 32857, 62476, 44332, 17703, 9455, 11128, 12211, 13272, 7165, 2340, 3272, 12277},
{61366, 39951, 71722, 52204, 28544, 17071, 17921, 20037, 20959, 11844, 4216, 6205, 17345},
{72531, 47727, 80871, 62065, 40162, 28318, 27849, 30163, 31738, 18414, 7150, 10775, 24239},
{83957, 58107, 92775, 74026, 54491, 41514, 38879, 42173, 43354, 26815, 11470, 16781, 32611},
{96421, 70952, 107453, 88521, 68854, 56036, 49998, 55562, 54776, 37236, 17212, 24614, 42443},
{110590, 85763, 123713, 105613, 83950, 73297, 60932, 70405, 66904, 49636, 24236, 34201, 53929},
{126845, 104511, 142755, 125677, 101384, 94028, 72855, 86941, 81309, 64970, 33319, 46716, 68057},
{146807, 127073, 164349, 150745, 122354, 120302, 86688, 106131, 98966, 84488, 45446, 63892, 86177}
},
//A2
{
{31057, 19104, 42215, 23660, 3272, 1588, 3496, 1751, 3900, 1483, 618, 419, 5308},
{36328, 21276, 44910, 27197, 4193, 2003, 4343, 2430, 4986, 1788, 770, 527, 5871},
{39780, 22580, 47604, 30552, 5424, 2657, 5458, 3057, 6445, 2235, 1006, 683, 6390},
{41852, 24422, 51233, 33304, 7209, 3578, 6867, 3643, 8204, 2803, 1373, 913, 6959},
{44533, 26361, 54704, 35426, 9386, 4790, 8499, 4235, 10137, 3527, 1899, 1228, 7664},
{47766, 27793, 57160, 37752, 11786, 6442, 10424, 4891, 12371, 4433, 2580, 1631, 8564},
{51078, 30063, 60731, 40289, 14527, 8516, 12621, 5629, 14924, 5579, 3398, 2119, 9730},
{54688, 32823, 64678, 43171, 17384, 11141, 15068, 6438, 17616, 7000, 4385, 2717, 11184},
{58733, 35768, 68411, 46433, 20351, 14498, 17754, 7436, 20681, 8819, 5570, 3421, 13006},
{62975, 39414, 72994, 49784, 23631, 18654, 20706, 8588, 24212, 11122, 6990, 4273, 15233},
{67536, 42989, 77129, 53379, 27369, 23920, 23974, 9951, 28365, 14024, 8722, 5333, 17921}
},
//B1
{
{31210, 19215, 42386, 23769, 3289, 1600, 3515, 1778, 3945, 1502, 621, 421, 5354},
{38890, 23414, 47379, 29598, 4761, 2354, 4691, 2975, 5483, 2065, 867, 672, 6537},
{44901, 27028, 52167, 36133, 7387, 3951, 7012, 5007, 8382, 3238, 1391, 1237, 8186},
{49393, 31604, 57466, 42322, 11777, 6820, 10947, 8084, 13186, 5171, 2420, 2350, 10600},
{54187, 36549, 61792, 47513, 17545, 11455, 16828, 12227, 19828, 8004, 4214, 4294, 13964},
{59880, 41137, 64559, 53465, 23511, 18183, 24594, 17372, 28106, 11858, 6815, 7289, 18361},
{65882, 47085, 69525, 59540, 31318, 26035, 32318, 23419, 36375, 16299, 10851, 11053, 23632},
{71485, 53667, 75020, 65768, 39985, 35325, 38746, 30156, 43318, 21409, 16333, 15648, 29569},
{77447, 60590, 80439, 72371, 48723, 45899, 43990, 38432, 49889, 27711, 23155, 21518, 36543},
{84009, 68990, 86415, 79421, 58364, 58050, 47666, 47317, 55611, 34830, 31317, 28735, 44391},
{92086, 78464, 92637, 87856, 69121, 72401, 50668, 57659, 61183, 43554, 41601, 38381, 53920}
},
//B2
{
{31021, 19095, 42831, 23920, 3322, 1611, 3529, 1813, 4001, 1464, 621, 420, 5375},
{37613, 22067, 46502, 28308, 4441, 2156, 4553, 3309, 5180, 2319, 780, 708, 6354},
{42366, 24132, 50433, 32960, 6493, 3306, 5994, 5766, 6923, 3835, 1031, 1316, 7652},
{46977, 27404, 56276, 37547, 10074, 5318, 7907, 9235, 9118, 6262, 1430, 2320, 9393},
{52366, 30945, 61760, 41622, 15284, 8631, 10332, 12978, 11716, 9403, 2031, 3632, 11409},
{58274, 33927, 66373, 46126, 21041, 13318, 13261, 16546, 14778, 13121, 2832, 5166, 13637},
{64245, 38454, 75857, 50245, 27227, 19375, 16741, 19692, 18637, 17282, 3806, 6692, 16019},
{69991, 43054, 84804, 55009, 32750, 26519, 20885, 22449, 23081, 21709, 5002, 8321, 18553},
{75766, 47699, 95318, 59524, 37007, 34475, 25489, 25185, 28416, 26758, 6428, 9949, 21312},
{81444, 53067, 108878, 64000, 40097, 42843, 30602, 27639, 34802, 32481, 8121, 11611, 24305},
{87616, 58350, 125164, 68705, 41963, 51292, 36218, 30396, 42312, 39412, 10139, 13548, 27728}
}
};
//end gdppc

//Energy GJ per cap per year?
//note 1 kWHr = 3.6 megaJoule
int[][][] enpc={
//A1B
{
{217, 178, 98, 107, 62, 91, 49, 29, 37, 25, 21, 18, 47},
{235, 199, 105, 124, 92, 113, 62, 40, 51, 30, 22, 21, 55},
{242, 209, 112, 140, 131, 141, 75, 52, 70, 38, 26, 28, 64},
{246, 221, 120, 154, 167, 171, 94, 70, 94, 53, 33, 41, 78},
{252, 231, 130, 167, 191, 201, 115, 87, 121, 72, 46, 59, 94},
{259, 237, 138, 179, 202, 223, 135, 102, 142, 93, 62, 81, 112},
{268, 248, 150, 194, 212, 244, 155, 121, 158, 116, 84, 105, 131},
{275, 259, 162, 206, 216, 256, 170, 137, 166, 135, 107, 127, 149},
{282, 268, 173, 216, 217, 262, 180, 152, 172, 151, 128, 146, 164},
{287, 275, 183, 222, 215, 263, 189, 164, 177, 162, 146, 161, 177},
{291, 281, 192, 228, 213, 262, 197, 174, 180, 170, 161, 175, 189}
},
//A1T
{
{217, 178, 98, 107, 62, 91, 49, 29, 37, 25, 21, 18, 47},
{235, 199, 105, 124, 91, 112, 61, 40, 51, 30, 22, 21, 54},
{238, 206, 110, 138, 129, 136, 71, 51, 67, 37, 25, 27, 62},
{238, 213, 116, 149, 161, 162, 86, 65, 88, 49, 31, 38, 73},
{237, 216, 122, 157, 177, 183, 102, 78, 109, 64, 42, 52, 86},
{235, 215, 126, 163, 180, 195, 117, 90, 124, 81, 55, 70, 98},
{236, 219, 133, 172, 183, 207, 131, 104, 135, 99, 73, 89, 113},
{238, 224, 140, 179, 182, 213, 140, 117, 141, 114, 93, 107, 127},
{239, 227, 147, 184, 180, 214, 146, 128, 144, 125, 109, 121, 138},
{239, 229, 152, 187, 176, 212, 151, 135, 145, 132, 122, 131, 146},
{238, 229, 157, 188, 171, 207, 154, 141, 145, 136, 132, 140, 152}
},
//A1F
{
{217, 178, 98, 107, 62, 91, 49, 29, 37, 25, 21, 18, 47},
{235, 199, 105, 124, 92, 113, 62, 40, 51, 30, 22, 21, 55},
{243, 210, 112, 140, 132, 141, 74, 53, 70, 38, 26, 28, 64},
{249, 223, 122, 156, 171, 173, 93, 70, 94, 53, 33, 41, 78},
{255, 233, 131, 168, 193, 201, 114, 87, 120, 71, 46, 59, 94},
{260, 238, 139, 179, 201, 221, 134, 102, 140, 92, 62, 80, 111},
{267, 248, 150, 193, 210, 240, 153, 122, 155, 115, 84, 105, 131},
{275, 259, 162, 205, 214, 251, 167, 140, 165, 135, 108, 128, 149},
{281, 267, 172, 214, 214, 257, 177, 155, 171, 150, 129, 146, 165},
{286, 274, 182, 221, 212, 258, 186, 167, 175, 161, 147, 162, 178},
{291, 280, 191, 226, 209, 256, 194, 179, 180, 171, 164, 177, 190}
},
//A2
{
{216, 177, 98, 106, 61, 90, 48, 29, 37, 25, 21, 17, 47},
{229, 189, 100, 117, 74, 101, 58, 34, 47, 26, 22, 18, 50},
{240, 197, 105, 129, 89, 110, 69, 36, 58, 29, 24, 20, 53},
{240, 202, 108, 134, 107, 120, 78, 39, 68, 32, 26, 23, 56},
{242, 207, 111, 139, 125, 129, 85, 42, 78, 35, 30, 26, 60},
{245, 210, 113, 144, 139, 141, 93, 45, 88, 40, 35, 30, 64},
{248, 217, 116, 150, 153, 153, 98, 48, 97, 45, 40, 33, 69},
{250, 224, 120, 156, 162, 164, 101, 50, 104, 51, 45, 37, 74},
{252, 230, 122, 162, 168, 174, 103, 53, 110, 58, 51, 42, 79},
{254, 237, 125, 167, 172, 183, 105, 56, 115, 67, 56, 46, 84},
{254, 241, 128, 171, 174, 189, 106, 60, 118, 75, 62, 52, 90}
},
//B1
{
{216, 177, 98, 106, 62, 91, 49, 29, 37, 25, 21, 17, 47},
{219, 186, 97, 115, 76, 101, 58, 35, 48, 27, 22, 19, 50},
{204, 176, 93, 118, 91, 102, 67, 39, 62, 30, 24, 22, 52},
{187, 167, 89, 117, 105, 108, 75, 44, 75, 35, 28, 26, 56},
{175, 160, 86, 115, 111, 113, 82, 49, 85, 41, 35, 32, 60},
{165, 151, 82, 113, 110, 116, 87, 52, 89, 47, 41, 40, 64},
{155, 144, 80, 110, 107, 115, 88, 55, 89, 53, 49, 46, 68},
{146, 137, 77, 107, 103, 110, 85, 58, 85, 56, 56, 50, 70},
{138, 131, 75, 103, 96, 104, 81, 60, 80, 59, 61, 52, 71},
{130, 125, 73, 99, 90, 98, 76, 61, 76, 60, 63, 54, 71},
{124, 120, 71, 96, 84, 92, 72, 62, 71, 61, 64, 55, 71}
},
//B2
{
{215, 176, 98, 106, 62, 91, 49, 29, 38, 24, 21, 17, 47},
{227, 189, 101, 118, 76, 102, 58, 38, 47, 29, 22, 20, 51},
{224, 188, 101, 125, 96, 113, 65, 47, 57, 35, 22, 25, 55},
{221, 190, 103, 130, 121, 126, 71, 56, 64, 44, 24, 31, 60},
{219, 190, 104, 133, 142, 140, 75, 61, 71, 53, 26, 36, 63},
{216, 187, 104, 136, 152, 151, 78, 64, 77, 60, 29, 42, 66},
{214, 190, 109, 139, 157, 162, 85, 67, 86, 69, 33, 48, 71},
{211, 191, 112, 142, 157, 167, 91, 70, 93, 76, 38, 53, 74},
{207, 191, 114, 143, 153, 167, 95, 72, 99, 82, 43, 56, 77},
{202, 190, 117, 142, 147, 164, 98, 73, 102, 87, 47, 59, 79},
{198, 189, 119, 141, 140, 158, 100, 74, 104, 90, 52, 62, 81}
}
};


//end enpc

//************************


//**********************************************
//Radiative Forcing data from IPCC TAR WG1  tables 6+IS92a
// CALCULATED DATA 
//now used ONLY for comparison with model (superimposed circles)

//atmospheric CO2 bern-mid
double[][] bernmid={
{367,367,367,367,367,367,367},
{388,386,386,386,386,385,387},
{418,410,415,414,410,406,413},
{447,435,449,444,432,425,439},
{483,466,495,481,457,448,468},
{522,496,555,522,482,473,499},
{563,523,625,568,503,499,533},
{601,545,702,620,518,524,568},
{639,563,786,682,530,552,607},
{674,572,872,754,538,581,653},
{703,575,958,836,540,611,703}
};

//bern-reference co2 rf 
double[][] co2bernrf={
{1.49,	1.49,	1.49,	1.49,	1.49,	1.49,	1.49},
{1.78,	1.76,	1.76,	1.76,	1.76,	1.74,	1.77},
{2.18,	2.08,	2.14,	2.13,	2.08,	2.03,	2.12},
{2.54,	2.40,	2.56,	2.50,	2.36,	2.27,	2.44},
{2.96,	2.76,	3.09,	2.93,	2.66,	2.55,	2.79},
{3.37, 	3.10,	3.70,	3.37,	2.94,	2.84,	3.13},
{3.78, 	3.38,	4.33,	3.82,	3.17,	3.13,	3.48},
{4.12,	3.60,	4.96,	4.29,	3.33,	3.39,	3.82},
{4.45,	3.78,	5.56,	4.80,	3.45,	3.67,	4.18},
{4.74,	3.86,	6.12,	5.34,	3.53,	3.94,	4.57},
{4.96,	3.89,	6.62,	5.89,	3.55,	4.21,	4.96}
};

//isam (WR) reference co2 rf
double[][] co2isamrf={
{1.51, 1.51, 1.51, 1.51, 1.51, 1.51, 1.51}, 
{1.82, 1.80, 1.80, 1.81, 1.78, 1.78, 1.81}, 
{2.21, 2.10, 2.17, 2.17, 2.10, 2.05, 2.14}, 
{2.62, 2.46, 2.64, 2.59, 2.42, 2.32, 2.50},
{3.04, 2.82, 3.18, 3.03, 2.73, 2.61, 2.87},
{3.47, 3.15, 3.81, 3.47, 3.01, 2.90, 3.23},
{3.86, 3.43, 4.44, 3.93, 3.24, 3.18, 3.58},
{4.21, 3.65, 5.06, 4.42, 3.40, 3.46, 3.95},
{4.54, 3.81, 5.65, 4.93, 3.52, 3.74, 4.32},
{4.82, 3.91, 6.20, 5.46, 3.60, 4.02, 4.71},
{5.07, 3.95, 6.69, 6.02, 3.64, 4.30, 5.11}
};

double[][] ch4rf={
{0.49, 0.49, 0.49, 0.49, 0.49, 0.49, 0.51},
{0.53, 0.52, 0.52, 0.53, 0.51, 0.52, 0.56},
{0.59, 0.58, 0.57, 0.58, 0.54, 0.55, 0.63},
{0.65, 0.64, 0.64, 0.63, 0.55, 0.60, 0.69},
{0.69, 0.70, 0.71, 0.70, 0.55, 0.64, 0.76},
{0.71, 0.74, 0.79, 0.76, 0.53, 0.70, 0.83},
{0.71, 0.76, 0.85, 0.83, 0.52, 0.74, 0.89},
{0.68, 0.74, 0.90, 0.89, 0.50, 0.78, 0.94},
{0.64, 0.72, 0.94, 0.96, 0.48, 0.82, 0.98},
{0.60, 0.68, 0.97, 1.02, 0.45, 0.85, 1.02},
{0.57, 0.63, 1.00, 1.09, 0.42, 0.88, 1.06}
};

double[][] n2orf={
{0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15},
{0.18, 0.17, 0.18, 0.18, 0.18, 0.17, 0.18},
{0.20, 0.19, 0.21, 0.21, 0.21, 0.19, 0.21},
{0.22, 0.21, 0.25, 0.25, 0.23, 0.21, 0.24},
{0.24, 0.22, 0.29, 0.29, 0.25, 0.22, 0.27},
{0.26, 0.23, 0.34, 0.33, 0.28, 0.23, 0.30},
{0.28, 0.24, 0.39, 0.37, 0.30, 0.25, 0.32},
{0.29, 0.25, 0.44, 0.41, 0.31, 0.26, 0.35},
{0.30, 0.26, 0.48, 0.45, 0.32, 0.27, 0.37},
{0.31, 0.26, 0.53, 0.49, 0.33, 0.28, 0.39},
{0.32, 0.27, 0.57, 0.53, 0.33, 0.29, 0.41}
};

double[][] tropo3rf={
{0.38, 0.38, 0.38, 0.38, 0.38, 0.38, 0.38},
{0.45, 0.45, 0.45, 0.45, 0.41, 0.43, 0.44},
{0.54, 0.53, 0.56, 0.55, 0.45, 0.49, 0.51},
{0.60, 0.64, 0.69, 0.66, 0.46, 0.56, 0.58},
{0.62, 0.71, 0.84, 0.74, 0.45, 0.62, 0.63},
{0.62, 0.75, 1.03, 0.81, 0.42, 0.66, 0.70},
{0.61, 0.76, 1.13, 0.87, 0.38, 0.69, 0.75},
{0.59, 0.71, 1.21, 0.93, 0.34, 0.72, 0.80},
{0.57, 0.64, 1.30, 1.02, 0.30, 0.76, 0.84},
{0.55, 0.56, 1.29, 1.13, 0.26, 0.79, 0.89},
{0.52, 0.48, 1.27, 1.25, 0.21, 0.81, 0.93}
};

double[][] hfcrf={
{0.011, 0.011, 0.011, 0.011, 0.011, 0.011, 0.002},
{0.025, 0.025, 0.025, 0.024, 0.024, 0.024, 0.014},
{0.047, 0.047, 0.046, 0.044, 0.041, 0.042, 0.027},
{0.078, 0.078, 0.078, 0.065, 0.059, 0.065, 0.046},
{0.118, 0.118, 0.117, 0.085, 0.078, 0.089, 0.072},
{0.164, 0.163, 0.160, 0.108, 0.101, 0.116, 0.106},
{0.215, 0.215, 0.206, 0.136, 0.118, 0.145, 0.137},
{0.250, 0.255, 0.245, 0.168, 0.130, 0.178, 0.159},
{0.276, 0.285, 0.273, 0.205, 0.138, 0.210, 0.176},
{0.290, 0.305, 0.291, 0.248, 0.143, 0.244, 0.189},
{0.299, 0.317, 0.304, 0.298, 0.144, 0.277, 0.198}
};

//same for all scenarios 
double[] cfcrf={0.3206, 0.3348, 0.3015, 0.2529, 0.2166, 0.1848, 0.1585, 0.1393, 0.1230, 0.1098, 0.0977};

double[][] sulfrf={
{-0.40, -0.40, -0.40, -0.40, -0.40, -0.40, -0.40},
{-0.51, -0.38, -0.47, -0.43, -0.43, -0.38, -0.49},
{-0.58, -0.35, -0.50, -0.58, -0.43, -0.35, -0.58},
{-0.53, -0.35, -0.55, -0.65, -0.45, -0.35, -0.67},
{-0.40, -0.27, -0.55, -0.63, -0.45, -0.34, -0.75},
{-0.37, -0.23, -0.47, -0.61, -0.40, -0.32, -0.83},
{-0.27, -0.20, -0.32, -0.52, -0.32, -0.32, -0.82},
{-0.21, -0.18, -0.25, -0.43, -0.25, -0.29, -0.82},
{-0.18, -0.15, -0.23, -0.38, -0.21, -0.29, -0.81},
{-0.17, -0.14, -0.23, -0.36, -0.17, -0.28, -0.80},
{-0.16, -0.12, -0.23, -0.35, -0.15, -0.28, -0.79}
};

//total BC and OC from ISAM (WR) method (not same as joos!)
//note 1990=0.0997
double[][] bcocrf={
{-0.1361, -0.1361, -0.1361, -0.1361, -0.1361, -0.1361, -0.1586}, 
{-0.1308, -0.1468, -0.1280, -0.1392, -0.1081, -0.1203, -0.1357},
{-0.0524, -0.0799, -0.1714, -0.1248, -0.0926, -0.0516, -0.1103}, 
{-0.0562, -0.0598, -0.1745, -0.1088, -0.0154, -0.0148, -0.0872}, 
{-0.0780, -0.0644, -0.1614, -0.1064, 0.0349, -0.0075, -0.0610}, 
{-0.0804, -0.0603, -0.1351, -0.1029, 0.0280, -0.0049, -0.0339}, 
{-0.0948, -0.0615, -0.1417, -0.1002, 0.0241, 0.0015, -0.0190}, 
{-0.1071, -0.0613, -0.1193, -0.0939, 0.0147, 0.0064, -0.0026}, 
{-0.1161, -0.0629, -0.0644, -0.0871, 0.0300, 0.0180, 0.0166}, 
{-0.1178, -0.0619, 0.0365, -0.0816, 0.0421, 0.0341, 0.0390}, 
{-0.1208, -0.0629, 0.0565, -0.0762, 0.0351, 0.0510, 0.0635} 
};

//total radiative forcing (note 1990=1.03)
//this is the input to ipcc chap9 calculations
//including WR BC/OC rf and ISAM CO2 RF

double[][] totrf={ 
{1.33, 1.33, 1.33, 1.33, 1.33, 1.33, 1.31},	
{1.65, 1.85, 1.69, 1.74, 1.73, 1.82, 1.63},	
{2.16, 2.48, 2.17, 2.04, 2.15, 2.36, 2.00},
{2.84, 3.07, 2.78, 2.56, 2.56, 2.81, 2.40},	
{3.61, 3.76, 3.67, 3.22, 2.93, 3.26, 2.82},	
{4.16, 4.31, 4.83, 3.89, 3.30, 3.70, 3.25},	
{4.79, 4.73, 5.99, 4.71, 3.65, 4.11, 3.76},	
{5.28, 4.97, 7.02, 5.56, 3.92, 4.52, 4.24},	
{5.62, 5.11, 7.89, 6.40, 4.09, 4.92, 4.74},	
{5.86, 5.12, 8.59, 7.22, 4.18, 5.32, 5.26},	
{6.05, 5.07, 9.14, 8.07, 4.19, 5.71, 5.79}	
};

//double[][][] allrf={co2bernrf, co2isamrf, ch4rf, n2orf, tropo3rf, hfcrf, cfcrf, sulfrf, bcocrf, totrf};


double[][] tempchange={
//note 1990=0, 1765-1990 0.33 (0.34 for is92a) 
{0.16, 0.16, 0.16, 0.16, 0.16, 0.16, 0.15},
{0.30, 0.40, 0.32, 0.35, 0.34, 0.39, 0.27},
{0.52, 0.71, 0.55, 0.50, 0.55, 0.66, 0.43},
{0.85, 1.03, 0.85, 0.73, 0.77, 0.93, 0.61},
{1.26, 1.41, 1.27, 1.06, 0.98, 1.18, 0.80},
{1.59, 1.75, 1.86, 1.42, 1.21, 1.44, 1.00},
{1.97, 2.04, 2.50, 1.85, 1.44, 1.69, 1.26},
{2.30, 2.25, 3.10, 2.33, 1.63, 1.95, 1.52},
{2.56, 2.41, 3.64, 2.81, 1.79, 2.20, 1.79},
{2.77, 2.49, 4.09, 3.30, 1.91, 2.44, 2.08},
{2.95, 2.54, 4.49, 3.79, 1.98, 2.69, 2.38}
};

//all sealevel data in mm, 1990=0

double[][] sealevelavg={
{17, 17, 17, 17, 17, 17},
{37, 39, 37, 38, 38, 38},
{61, 66, 61, 61, 62, 64},
{91, 97, 90, 88, 89, 94},
{127, 134, 126, 120, 118, 126},
{167, 175, 172, 157, 150, 160},
{210, 217, 228, 201, 183, 197},
{256, 258, 290, 250, 216, 235},
{301, 298, 356, 304, 249, 275},
{345, 334, 424, 362, 281, 316},
{387, 367, 491, 424, 310, 358}
};

double[][] sealevelmin={
{8, 8, 8, 8, 8, 8},
{17, 18, 18, 18, 18, 18},
{30, 32, 30, 29, 30, 31},
{45, 48, 44, 43, 43, 46},
{64, 67, 63, 59, 57, 61},
{84, 86, 88, 78, 72, 77},
{105, 106, 117, 100, 87, 95},
{127, 124, 149, 125, 102, 112},
{147, 141, 182, 152, 116, 130},
{166, 155, 215, 181, 128, 148},
{184, 167, 247, 211, 138, 166}
};

double[][] sealevelmax={
{27, 27, 27, 27, 27, 27}, 
{57, 60, 58, 59, 58, 59}, 
{94, 101, 95, 95, 96, 99}, 
{140, 150, 140, 136, 138, 146}, 
{196, 208, 196, 186, 185, 197},
{259, 273, 266, 245, 236, 252},
{328, 342, 353, 313, 290, 312}, 
{403, 411, 452, 392, 346, 376}, 
{479, 480, 559, 479, 402, 443}, 
{555, 545, 671, 575, 458, 512}, 
{630, 606, 785, 678, 512, 584}
}; 

double[][] thermalexp={
{10, 10, 10, 10, 10, 10}, 
{23, 24, 23, 23, 23, 24}, 
{39, 43, 39, 39, 39, 42},
{60, 66, 60, 57, 58, 62}, 
{87, 93, 86, 81, 79, 85}, 
{117, 123, 122, 109, 101, 110}, 
{150, 155, 166, 142, 125, 137}, 
{185, 186, 217, 180, 149, 165}, 
{220, 216, 272, 224, 173, 196}, 
{255, 243, 329, 272, 195, 227}, 
{288, 267, 388, 325, 216, 260} 
};


double[][] glaciers={
{4, 4, 4, 4, 4, 4},
{9, 10, 9, 10, 10, 10},
{16, 17, 16, 16, 16, 16, 28},
{23, 25, 23, 23, 23, 24},
{32, 35, 32, 31, 31, 34, 30},
{43, 46, 44, 41, 41, 44},
{55, 58, 57, 52, 50, 54},
{67, 71, 72, 65, 61, 66},
{80, 83, 89, 79, 71, 77},
{93, 95, 105, 93, 82, 89},
{106, 106, 120, 108, 92, 101}
};

double[][] greenland={
{0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1},
{2, 2, 2, 2, 2, 2},
{4, 4, 4, 4, 4, 4},
{5, 6, 5, 5, 5, 6},
{8, 8, 8, 7, 7, 8},
{10, 11, 11, 10, 9, 10},
{13, 14, 15, 13, 12, 13},
{17, 17, 19, 16, 14, 16},
{20, 21, 24, 20, 17, 19},
{24, 24, 29, 25, 20, 22}
};

double[][] antarctica={
{-2, -2, -2, -2, -2, -2},
{-5, -5, -5, -5, -5, -5},
{-8, -9, -8, -8, -8, -9},
{-12, -14, -13, -12, -13, -13},
{-18, -20, -18, -17, -17, -19},
{-25, -27, -25, -23, -23, -25},
{-33, -35, -35, -31, -30, -32},
{-42, -45, -46, -40, -37, -41 },
{-52, -54, -59, -50, -44, -49},
{-63, -64, -74, -62, -53, -59},
{-74, -75, -90, -76, -61, -70}
};

}//end data
