
public interface sresreg {

/* Regional SRES data: direct from IPCC sresall.xls
Marker scenarios: A1B: AIM, A2: ASF, B1: IMAGE, B2: MESSAGE, A1T: MESSAGE, A1FI: A1G MINICAM
1990-2100
*/

double[][][] pop={
{ //WORLD
{5262, 6117, 6805, 7493, 8182, 8439, 8704, 8538, 8375, 8030, 7528, 7056},
{5262, 6117, 6888, 7617, 8182, 8531, 8704, 8667, 8463, 8125, 7658, 7056},
{5293, 6100, 6874, 7618, 8122, 8484, 8703, 8623, 8430, 8126, 7621, 7137},
{5282, 6170, 7188, 8206, 9170, 10715, 11296, 12139, 12587, 13828, 14743, 15068},
{5280, 6122, 6892, 7618, 8196, 8547, 8708, 8671, 8484, 8142, 7663, 7047},
{5262, 6091, 6891, 7672, 8372, 8930, 9367, 9704, 9960, 10158, 10306, 10414}
},
{//OECD
{859, 919, 960, 1002, 1043, 1062, 1081, 1086, 1091, 1097, 1103, 1110},
{859, 919, 965, 1007, 1043, 1069, 1081, 1084, 1089, 1098, 1108, 1110},
{838, 908, 965, 1007, 1024, 1066, 1081, 1084, 1090, 1098, 1105, 1112},
{851, 923, 975, 1027, 1072, 1131, 1151, 1202, 1228, 1323, 1451, 1496},
{799, 849, 890, 932, 965, 990, 1001, 1005, 1009, 1020, 1029, 1032},
{859, 916, 953, 982, 994, 988, 976, 965, 951, 941, 934, 928}
},
{//REF
{413, 419, 424, 430, 435, 429, 423, 406, 391, 374, 356, 339},
{413, 419, 427, 433, 435, 433, 423, 409, 392, 374, 357, 339},
{428, 425, 426, 433, 434, 431, 423, 408, 392, 374, 357, 340},
{418, 421, 438, 454, 473, 507, 519, 551, 568, 622, 684, 706},
{412, 429, 437, 443, 445, 443, 432, 419, 401, 384, 365, 347},
{413, 415, 417, 418, 416, 411, 406, 396, 389, 384, 381, 379}
},
{//ASIA
{2798, 3261, 3556, 3851, 4147, 4183, 4220, 4016, 3822, 3541, 3194, 2882},
{2798, 3261, 3620, 3937, 4147, 4238, 4220, 4085, 3867, 3589, 3258, 2882},
{2790, 3226, 3608, 3937, 4115, 4210, 4219, 4062, 3852, 3589, 3245, 2919},
{2791, 3295, 3801, 4308, 4779, 5500, 5764, 6137, 6333, 6858, 7214, 7340},
{2781, 3246, 3609, 3929, 4142, 4235, 4220, 4088, 3871, 3594, 3262, 2886},
{2798, 3248, 3649, 4008, 4312, 4538, 4696, 4790, 4856, 4902, 4938, 4968}
},
{//ALM
{1192, 1519, 1865, 2211, 2557, 2761, 2980, 3024, 3067, 3013, 2866, 2727},
{1192, 1519, 1875, 2241, 2557, 2791, 2980, 3089, 3115, 3064, 2934, 2727},
{1236, 1541, 1876, 2241, 2531, 2778, 2980, 3068, 3096, 3064, 2913, 2766},
{1222, 1530, 1974, 2417, 2846, 3578, 3862, 4250, 4458, 5025, 5394, 5526},
{1287, 1597, 1954, 2315, 2643, 2879, 3055, 3159, 3202, 3145, 3006, 2783},
{1192, 1511, 1872, 2263, 2649, 2992, 3289, 3554, 3764, 3931, 4053, 4139}
}
};

double[][][] gnp={
{ //WORLD
{20.87, 26.72, 37.90, 56.48, 89.06, 127.08, 181.32, 235.06, 304.73, 377.43, 446.64, 528.53},
{20.90, 26.80, 36.80, 57.00, 91.30, 135.40, 187.10, 254.10, 322.90, 393.20, 469.60, 550},
{20.70, 27.42, 38.11, 52.77, 80.04, 117.12, 164.00, 226.10, 293.34, 365.73, 441.58, 524.97},
{20.08, 25.23, 31.93, 40.50, 51.17, 72.31, 81.57, 101.88, 114.07, 159.31, 218.37, 242.78},
{20.96, 26.77, 37.33, 52.56, 73.08, 100.71, 135.57, 171.70, 208.51, 249.71, 290.10, 328.37},
{20.90, 28.30, 38.60, 50.70, 66.00, 85.50, 109.50, 134.80, 161.50, 186.30, 210.30, 234.90}
},
{//OECD
{16.36, 20.52, 25.26, 31.03, 38.02, 45.37, 54.15, 64.12, 75.92, 89.19, 103.95, 121.15},
{16.40, 20.60, 25.60, 31.60, 38.70, 46.80, 55.70, 65.70, 77.20, 90.80, 106.60, 124.30},
{16.35, 20.50, 25.56, 31.53, 34.42, 44.64, 53.53, 63.21, 74.17, 86.41, 101.42, 117.66},
{15.31, 18.70, 22.31, 25.96, 30.01, 37.14, 39.89, 46.35, 49.97, 63.06, 80.66, 87.57},
{16.49, 20.24, 25.94, 32.37, 38.24, 43.91, 49.87, 55.39, 59.82, 66.29, 73.84, 82.29},
{16.40, 21.10, 26.50, 30.30, 33.10, 35.80, 38.30, 40.90, 44.40, 47.90, 52.00, 56.60}
},
{//REF
{1.08, 0.83, 1.54, 2.86, 5.30, 8.10, 12.39, 15.57, 19.57, 23.98, 28.63, 34.19},
{1.10, 0.80, 1.00, 2.10, 5.40, 9.40, 12.60, 16.20, 20, 24.40, 29.20, 34.40},
{1.07, 1.05, 1.39, 2.10, 3.46, 5.07, 6.93, 10, 13.58, 17.66, 21.63, 26.02},
{0.94, 0.82, 1.04, 1.43, 2.06, 3.20, 3.71, 4.91, 5.65, 8.52, 12.53, 14.25},
{0.96, 0.72, 1.02, 1.72, 2.79, 4.30, 6.19, 8.17, 10.29, 12.78, 15.37, 18.12},
{1.10, 1.00, 1.20, 1.80, 2.80, 4.50, 6.60, 8.60, 10.50, 11.90, 13.20, 14.50}
},
{//ASIA
{1.51, 2.71, 5.79, 12.31, 26.19, 40.54, 62.75, 85.41, 116.25, 147.63, 174.92, 207.26},
{1.50, 2.70, 5.80, 13.50, 27.20, 44.90, 65.30, 95.80, 126.90, 155.50, 186.50, 218.20},
{1.40, 3.07, 6.51, 11.74, 23.85, 40.28, 61.03, 85.97, 111.72, 138.29, 164.29, 192.59},
{1.44, 2.28, 3.53, 5.31, 7.62, 12.63, 14.96, 19.97, 23.08, 34.87, 50.48, 57.14},
{1.40, 2.72, 4.82, 8.67, 15.12, 24.93, 37.91, 51.42, 64.78, 78.67, 91.74, 103.10},
{1.50, 3.50, 7.20, 13.20, 21.30, 30.70, 41.80, 52.70, 64.10, 75.00, 85.80, 97.10}
},
{//ALM
{1.92, 2.66, 5.31, 10.28, 19.55, 31.89, 52.04, 69.38, 92.48, 116.62, 139.11, 165.93},
{1.90, 2.70, 4.40, 9.80, 20, 34.30, 53.50, 76.50, 98.70, 122.50, 147.20, 173.10},
{1.87, 2.80, 4.65, 7.41, 15.43, 27.13, 42.51, 66.92, 93.88, 123.37, 154.25, 188.70},
{2.39, 3.43, 5.05, 7.80, 11.48, 19.33, 23.02, 30.65, 35.37, 52.86, 74.69, 83.83},
{2.13, 3.09, 5.55, 9.83, 16.94, 27.57, 41.62, 56.72, 73.63, 91.97, 109.14, 124.87},
{1.90, 2.70, 3.70, 5.50, 8.80, 14.60, 22.80, 32.60, 42.60, 51.40, 59.30, 66.80}
}
};

double[][][] ppp={
{ //WORLD
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{25.74, 33.40, 45.72, 67.24, 98.72, 139.00, 186.45, 246.78, 313.24, 382.04, 456.59, 535.03},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{25.74, 34.80, 46.90, 60.18, 75.52, 93.16, 113.94, 136.82, 160.74, 183.84, 207.42, 231.85}
},
{//OECD
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{14.07, 17.75, 22.14, 27.42, 33.66, 40.76, 48.59, 57.37, 67.58, 79.65, 93.64, 109.35},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{14.07, 18.26, 22.97, 26.34, 28.81, 31.26, 33.54, 35.93, 39.17, 42.43, 46.14, 50.36}
},
{//REF
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{2.55, 2.25, 2.54, 3.66, 6.02, 9.40, 12.55, 16.15, 20.03, 24.43, 29.21, 34.41},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{2.55, 2.37, 2.65, 3.28, 4.32, 5.64, 7.17, 9.54, 11.61, 13.32, 14.80, 16.20}
},
{//ASIA
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{5.31, 8.27, 13.50, 22.83, 36.20, 52.18, 70.05, 96.79, 126.91, 155.49, 186.53, 218.16},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{5.31, 9.26, 15.13, 22.36, 30.73, 39.29, 49.31, 58.97, 68.72, 78.53, 89.24, 100.41}
},
{//ALM
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{3.82, 5.13, 7.54, 13.33, 22.84, 36.66, 55.26, 76.47, 98.72, 122.47, 147.21, 173.10},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{3.82, 4.92, 6.15, 8.19, 11.66, 16.96, 23.92, 32.38, 41.24, 49.57, 57.25, 64.88}
}
};
double[][][] fosco2={
{ //world
{5.99, 6.90, 9.68, 12.12, 14.01, 14.95, 16.01, 15.70, 15.43, 14.83, 13.94, 13.10},
{5.99, 6.90, 8.33, 10, 12.26, 12.60, 12.29, 11.41, 9.91, 8.05, 6.27, 4.31},
{5.99, 6.90, 8.65, 11.19, 14.61, 18.66, 23.10, 25.14, 27.12, 29.04, 29.64, 30.32},
{5.99, 6.90, 8.46, 11.01, 13.53, 15.01, 16.49, 18.49, 20.49, 22.97, 25.94, 28.91},
{5.99, 6.90, 8.50, 10, 11.20, 12.20, 11.70, 10.20, 8.60, 7.30, 6.10, 5.20},
{5.99, 6.90, 7.99, 9.02, 10.15, 10.93, 11.23, 11.74, 11.87, 12.46, 13.20, 13.82}
},
{//OECD
{2.83, 3.20, 3.41, 3.51, 3.48, 3.42, 3.36, 3.06, 2.78, 2.56, 2.40, 2.24},
{2.83, 3.20, 3.31, 3.18, 2.96, 2.38, 2.00, 1.71, 1.38, 1.17, 0.95, 0.66},
{2.83, 3.20, 3.58, 3.95, 4.03, 4.46, 5.02, 5.34, 5.76, 6.30, 7.14, 8.02},
{2.83, 3.20, 3.51, 3.96, 4.42, 4.58, 4.74, 4.93, 5.11, 5.55, 6.23, 6.91},
{2.83, 3.20, 3.30, 3.20, 2.80, 2.40, 2.00, 1.60, 1.40, 1.30, 1.20, 1.10},
{2.83, 3.20, 3.50, 3.71, 3.70, 3.51, 3.26, 3.25, 3.08, 3.10, 3.14, 3.10}
},
{//REF
{1.30, 0.91, 1.05, 1.11, 1.13, 1.16, 1.18, 1.08, 0.99, 0.91, 0.84, 0.78},
{1.30, 0.91, 0.88, 1.00, 1.22, 1.24, 1.16, 1.20, 1.20, 1.11, 0.91, 0.66},
{1.30, 0.91, 0.94, 1.24, 1.76, 2.17, 2.47, 2.53, 2.54, 2.53, 2.66, 2.79},
{1.30, 0.91, 1.03, 1.22, 1.40, 1.46, 1.52, 1.63, 1.75, 1.93, 2.17, 2.41},
{1.30, 0.91, 0.81, 0.91, 0.91, 0.91, 0.91, 0.81, 0.61, 0.51, 0.41, 0.41},
{1.30, 0.91, 0.80, 0.81, 0.94, 1.11, 1.24, 1.18, 1.22, 1.24, 1.21, 1.18}
},
{//ASIA
{1.15, 1.78, 2.92, 4.11, 5.21, 5.46, 5.73, 5.86, 5.99, 5.89, 5.57, 5.27},
{1.15, 1.78, 2.73, 3.90, 5.26, 5.36, 5.19, 4.65, 4.06, 3.29, 2.47, 1.52},
{1.15, 1.78, 2.82, 4.27, 6.17, 8.12, 10.13, 10.42, 10.68, 10.93, 10.42, 9.92},
{1.15, 1.78, 2.47, 3.52, 4.64, 5.45, 6.27, 7.08, 7.90, 8.79, 9.75, 10.71},
{1.15, 1.78, 2.58, 3.18, 3.78, 4.08, 3.68, 3.08, 2.48, 1.98, 1.58, 1.28},
{1.15, 1.78, 2.42, 3.02, 3.62, 4.07, 4.12, 4.26, 4.30, 4.57, 5.07, 5.69}
},
{//ALM
{0.72, 1.01, 2.30, 3.40, 4.20, 4.91, 5.73, 5.70, 5.67, 5.47, 5.13, 4.81},
{0.72, 1.01, 1.41, 1.92, 2.82, 3.62, 3.94, 3.84, 3.26, 2.48, 1.94, 1.48},
{0.72, 1.01, 1.30, 1.73, 2.66, 3.91, 5.48, 6.86, 8.13, 9.27, 9.43, 9.58},
{0.72, 1.01, 1.45, 2.31, 3.08, 3.52, 3.96, 4.84, 5.72, 6.70, 7.79, 8.87},
{0.72, 1.01, 1.81, 2.71, 3.71, 4.81, 5.11, 4.71, 4.11, 3.51, 2.91, 2.41},
{0.72, 1.01, 1.26, 1.48, 1.88, 2.24, 2.60, 3.04, 3.27, 3.55, 3.79, 3.84}
},
};
double[][][] lucco2={
{//world
{1.11, 1.07, 1.20, 0.52, 0.47, 0.40, 0.37, 0.30, 0.30, 0.35, 0.36, 0.39},
{1.11, 1.07, 1.04, 0.26, 0.12, 0.05, -0.02, -0.03, -0.03, -0.03, -0.01, 0},
{1.11, 1.07, 1.08, 1.55, 1.57, 1.31, 0.80, 0.55, 0.16, -0.36, -1.22, -2.08},
{1.11, 1.07, 1.12, 1.25, 1.19, 1.06, 0.93, 0.67, 0.40, 0.25, 0.21, 0.18},
{1.11, 1.07, 0.78, 0.63, -0.09, -0.48, -0.41, -0.46, -0.42, -0.60, -0.78, -0.97},
{1.11, 1.07, 0.80, 0.03, -0.25, -0.24, -0.23, -0.24, -0.25, -0.31, -0.41, -0.50}
},
{//OECD
{0, 0, 0.05, 0.03, 0.02, 0, -0.01, 0.01, 0.06, 0.11, 0.09, 0.07},
{0, 0, 0.04, 0.02, 0, -0.02, -0.04, 0, 0.05, 0.06, 0.04, 0.01},
{0, 0, 0.13, 0.25, 0.24, 0.16, 0.05, 0.02, -0.07, -0.24, -0.35, -0.47},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0, 0, 0.10, 0.06, -0.02, -0.07, -0.09, -0.08, -0.06, -0.14, -0.12, -0.11},
{0, 0, -0.02, -0.06, -0.08, -0.06, -0.05, -0.06, -0.08, -0.11, -0.15, -0.19}
},
{//REF
{0, 0, 0.20, 0.03, 0.01, -0.06, -0.13, -0.11, -0.09, -0.07, -0.05, -0.03},
{0, 0, 0.18, 0.01, 0, -0.08, -0.15, -0.12, -0.09, -0.07, -0.06, -0.05},
{0, 0, 0.03, 0.08, 0.12, 0.12, 0.07, 0.10, 0.09, 0.03, -0.14, -0.32},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0, 0, -0.01, -0.10, -0.31, -0.35, -0.36, -0.38, -0.41, -0.36, -0.34, -0.29},
{0, 0, -0.01, -0.18, -0.14, -0.09, -0.04, -0.04, -0.03, -0.03, -0.04, -0.04}
},
{//ASIA
{0.37, 0.26, 0.33, 0.05, 0.12, 0.17, 0.25, 0.16, 0.11, 0.10, 0.14, 0.19},
{0.37, 0.26, 0.22, -0.13, -0.12, -0.04, 0.03, -0.03, -0.09, -0.10, -0.04, 0.01},
{0.37, 0.26, 0.20, 0.27, 0.29, 0.26, 0.17, 0.10, 0.03, -0.05, -0.19, -0.33},
{0.37, 0.26, 0.34, 0.39, 0.35, 0.28, 0.22, 0.15, 0.08, 0.04, 0.03, 0.02},
{0.37, 0.26, 0.24, 0.22, 0.21, 0.19, 0.18, 0.16, 0.15, 0.11, -0.09, -0.35},
{0.37, 0.26, 0.20, -0.15, -0.16, -0.09, -0.03, -0.03, -0.04, -0.05, -0.05, -0.06}
},
{//ALM
{0.73, 0.82, 0.63, 0.40, 0.32, 0.29, 0.26, 0.25, 0.23, 0.21, 0.19, 0.16},
{0.73, 0.82, 0.60, 0.36, 0.25, 0.19, 0.14, 0.12, 0.10, 0.08, 0.06, 0.03},
{0.73, 0.82, 0.72, 0.95, 0.92, 0.77, 0.50, 0.32, 0.12, -0.09, -0.53, -0.96},
{0.73, 0.82, 0.77, 0.85, 0.84, 0.78, 0.71, 0.52, 0.32, 0.21, 0.18, 0.16},
{0.73, 0.82, 0.45, 0.45, 0.04, -0.25, -0.13, -0.15, -0.10, -0.21, -0.22, -0.22},
{0.73, 0.82, 0.63, 0.42, 0.12, 0.01, -0.11, -0.11, -0.10, -0.12, -0.16, -0.20}
}
};
double[][][] ch4={
{//world
{309.7, 322.9, 373.0, 420.8, 466.3, 458.2, 452.3, 410.2, 373.1, 341.5, 314.1, 289.2},
{309.7, 322.9, 362.4, 415.1, 482.7, 495.3, 499.7, 458.9, 404.5, 359.4, 316.5, 273.9},
{309.7, 322.9, 359.3, 416.2, 488.5, 566.8, 629.8, 655.0, 676.6, 694.7, 714.8, 735.0},
{309.7, 322.9, 370.2, 424.4, 485.6, 541.6, 597.5, 654.5, 711.4, 769.7, 829.3, 888.8},
{309.7, 322.9, 348.9, 376.9, 384.9, 380.9, 358.9, 341.9, 323.9, 292.9, 265.9, 235.9},
{309.7, 322.9, 348.9, 383.9, 426.0, 466.4, 504.5, 522.3, 544.3, 565.5, 578.7, 596.6}
},
{//OECD
{73.0, 73.5, 71.2, 68.9, 65.8, 58.3, 51.5, 49.5, 47.4, 45.6, 44.0, 42.4},
{73.0, 73.5, 70.6, 67.8, 65.7, 60.4, 55.7, 51.5, 48.2, 46.8, 45.1, 43.3},
{73.0, 73.5, 85.6, 100.7, 107.8, 131.1, 149.4, 171.9, 196.3, 222.6, 246.2, 269.8},
{73.0, 73.5, 77.7, 83.8, 91.3, 98.4, 105.4, 113.3, 121.1, 133.2, 149.5, 165.7},
{73.0, 73.5, 74.5, 71.5, 67.5, 62.5, 55.5, 51.5, 49.5, 45.5, 41.5, 39.5},
{73.0, 73.5, 71.8, 71.3, 68.3, 67.3, 68.8, 69.5, 70.1, 72.0, 75.0, 77.8}
},
{//REF
{47.1, 38.9, 57.9, 61.3, 59.9, 50.5, 42.4, 40.9, 39.4, 37.7, 35.9, 34.2},
{47.1, 38.9, 42.4, 48.6, 58.0, 58.5, 54.2, 51.9, 48.3, 43.0, 36.2, 30.4},
{47.1, 38.9, 49.0, 67.8, 90.9, 108.9, 121.9, 122.6, 121.9, 119.7, 120.1, 120.5},
{47.1, 38.9, 41.1, 45.8, 56.7, 67.3, 78.0, 92.1, 106.3, 119.3, 131.3, 143.2},
{47.1, 38.9, 37.9, 41.9, 43.9, 39.9, 33.9, 32.9, 29.9, 26.9, 23.9, 20.9},
{47.1, 38.9, 36.2, 39.8, 44.8, 50.2, 52.9, 50.4, 47.5, 46.7, 45.8, 47.0}
},
{//ASIA
{112.9, 125.4, 144.8, 170.7, 206.6, 210.3, 214.2, 182.9, 156.2, 138.4, 127.4, 117.3},
{112.9, 125.4, 151.7, 184.5, 225.5, 226.4, 227.3, 200.1, 167.0, 147.0, 130.4, 109.8},
{112.9, 125.4, 134.7, 147.6, 166.0, 186.2, 208.3, 198.4, 188.7, 179.2, 180.7, 182.1},
{112.9, 125.4, 144.4, 162.9, 184.2, 205.4, 226.5, 241.0, 255.4, 271.6, 289.6, 307.5},
{112.9, 125.4, 136.4, 148.4, 154.4, 161.4, 157.4, 149.4, 141.4, 128.4, 118.4, 105.4},
{112.9, 125.4, 146.4, 171.1, 201.1, 219.4, 234.0, 240.8, 251.4, 260.1, 265.1, 271.9}
},
{//ALM
{76.7, 85.2, 99.2, 119.8, 134.0, 139.0, 144.2, 137.0, 130.1, 119.7, 106.7, 95.3},
{76.7, 85.2, 97.7, 114.3, 133.5, 150.0, 162.4, 155.3, 141.0, 122.6, 104.8, 90.4},
{76.7, 85.2, 89.9, 100.1, 123.9, 140.6, 150.1, 162.0, 169.7, 173.2, 167.9, 162.5},
{76.7, 85.2, 107.0, 131.9, 153.4, 170.5, 187.6, 208.1, 228.6, 245.6, 259.0, 272.4},
{76.7, 85.2, 100.2, 115.2, 119.2, 117.2, 112.2, 108.2, 103.2, 92.2, 82.2, 70.2},
{76.7, 85.2, 94.5, 101.7, 111.8, 129.5, 148.7, 161.6, 175.3, 186.7, 192.7, 199.9}
}
};
double[][][] n2o={
{//world
{6.68, 7.02, 7.04, 7.17, 7.35, 7.38, 7.43, 7.31, 7.19, 7.12, 7.08, 7.04},
{6.68, 7.02, 6.10, 6.06, 6.19, 6.18, 6.15, 5.97, 5.74, 5.58, 5.50, 5.42},
{6.68, 7.02, 8.05, 9.32, 10.88, 12.79, 14.54, 15.03, 15.40, 15.66, 16.13, 16.60},
{6.68, 7.02, 8.05, 9.56, 10.66, 11.32, 11.98, 12.94, 13.90, 14.81, 15.67, 16.52},
{6.68, 7.02, 7.52, 8.12, 8.22, 8.32, 8.32, 7.72, 7.42, 7.02, 6.42, 5.72},
{6.68, 7.02, 6.21, 6.06, 6.14, 6.23, 6.29, 6.43, 6.56, 6.70, 6.83, 6.94}
},
{//OECD
{2.57, 2.56, 2.52, 2.60, 2.55, 2.50, 2.44, 2.38, 2.31, 2.26, 2.21, 2.17},
{2.57, 2.56, 2.39, 2.37, 2.36, 2.33, 2.29, 2.26, 2.22, 2.19, 2.16, 2.14},
{2.57, 2.56, 2.78, 3.03, 3.20, 3.70, 4.02, 4.08, 4.15, 4.23, 4.31, 4.39},
{2.57, 2.56, 2.67, 3.00, 3.14, 3.09, 3.04, 3.18, 3.32, 3.50, 3.71, 3.92},
{2.57, 2.56, 2.56, 2.56, 2.46, 2.36, 2.36, 2.26, 2.26, 2.16, 2.16, 1.96},
{2.57, 2.56, 2.50, 2.42, 2.46, 2.49, 2.51, 2.53, 2.54, 2.57, 2.58, 2.60}
},
{//REF
{0.63, 0.59, 0.60, 0.62, 0.63, 0.62, 0.60, 0.58, 0.56, 0.55, 0.54, 0.54},
{0.63, 0.59, 0.59, 0.61, 0.63, 0.62, 0.61, 0.60, 0.58, 0.57, 0.56, 0.56},
{0.63, 0.59, 0.73, 0.91, 1.16, 1.40, 1.62, 1.63, 1.60, 1.54, 1.58, 1.62},
{0.63, 0.59, 0.64, 0.69, 0.74, 0.78, 0.82, 0.84, 0.87, 0.90, 0.94, 0.98},
{0.63, 0.59, 0.59, 0.59, 0.59, 0.59, 0.49, 0.39, 0.39, 0.39, 0.29, 0.29},
{0.63, 0.59, 0.60, 0.61, 0.62, 0.63, 0.64, 0.65, 0.66, 0.67, 0.67, 0.68}
},
{//ASIA
{2.29, 2.56, 2.64, 2.67, 2.85, 2.90, 2.96, 2.93, 2.90, 2.89, 2.89, 2.90},
{2.29, 2.56, 2.40, 2.39, 2.52, 2.53, 2.53, 2.44, 2.34, 2.25, 2.22, 2.20},
{2.29, 2.56, 2.88, 3.27, 3.79, 4.32, 4.84, 4.95, 5.04, 5.13, 5.22, 5.31},
{2.29, 2.56, 3.18, 3.97, 4.56, 4.95, 5.33, 5.79, 6.24, 6.62, 6.91, 7.20},
{2.29, 2.56, 2.86, 3.16, 3.26, 3.36, 3.26, 2.96, 2.66, 2.46, 2.06, 1.86},
{2.29, 2.56, 2.42, 2.43, 2.51, 2.54, 2.56, 2.62, 2.69, 2.76, 2.83, 2.89}
},
{//ALM
{1.18, 1.29, 1.28, 1.29, 1.32, 1.37, 1.42, 1.42, 1.42, 1.42, 1.42, 1.43},
{1.18, 1.29, 0.71, 0.68, 0.68, 0.70, 0.71, 0.67, 0.61, 0.57, 0.54, 0.53},
{1.18, 1.29, 1.65, 2.10, 2.73, 3.38, 4.06, 4.37, 4.61, 4.77, 5.03, 5.28},
{1.18, 1.29, 1.56, 1.91, 2.23, 2.50, 2.78, 3.13, 3.47, 3.80, 4.11, 4.42},
{1.18, 1.29, 1.49, 1.79, 1.89, 1.99, 2.19, 2.09, 2.09, 1.99, 1.89, 1.59},
{1.18, 1.29, 0.69, 0.60, 0.55, 0.57, 0.58, 0.63, 0.67, 0.71, 0.74, 0.77}
},
};
double[][][] sox={
{//world
{70.92, 69.05, 87.09, 100.17, 90.97, 68.91, 64.12, 46.86, 35.65, 30.73, 29.09, 27.61},
{70.92, 69.05, 64.72, 59.90, 59.63, 46.58, 40.22, 34.39, 30.08, 25.22, 23.34, 20.25},
{70.92, 69.05, 80.83, 86.92, 96.13, 93.99, 80.49, 56.27, 42.58, 39.41, 39.76, 40.11},
{70.92, 69.05, 74.75, 99.47, 112.51, 108.95, 105.39, 89.56, 73.72, 64.71, 62.51, 60.30},
{70.92, 69.05, 73.92, 74.60, 78.17, 78.55, 68.92, 55.80, 44.27, 36.15, 29.82, 24.90},
{70.92, 69.05, 65.90, 61.29, 60.29, 59.00, 55.68, 53.83, 50.92, 49.97, 48.97, 47.91}
},
{//OECD
{22.70, 17.00, 9.88, 6.87, 6.38, 6.32, 6.26, 5.96, 5.67, 5.33, 4.96, 4.61},
{22.70, 17.00, 8.25, 2.06, 0.64, 0.64, 0.01, 0.42, 0.75, 1.34, 1.89, 2.32},
{22.70, 17.00, 13.92, 4.65, 4.04, 4.18, 5.09, 5.20, 5.68, 6.53, 7.29, 8.05},
{22.70, 17.00, 7.92, 8.65, 9.30, 9.54, 9.78, 9.27, 8.75, 9.15, 10.45, 11.76},
{22.70, 17.00, 11.77, 7.94, 5.41, 3.58, 2.45, 2.02, 1.99, 2.06, 2.33, 2.60},
{22.70, 17.00, 11.30, 6.69, 5.74, 4.91, 4.05, 3.71, 3.40, 3.27, 3.31, 3.50}
},
{//REF
{17.00, 11.00, 12.15, 10.75, 7.51, 4.25, 2.37, 1.99, 1.69, 1.56, 1.55, 1.55},
{17.00, 11.00, 7.46, 4.87, 5.22, 4.48, 4.05, 1.85, 1.24, 0.71, 3.01, 3.06},
{17.00, 11.00, 10.28, 10.51, 13.30, 13.35, 10.66, 5.80, 3.06, 2.44, 2.52, 2.60},
{17.00, 11.00, 11.15, 11.95, 11.98, 11.11, 10.25, 8.24, 6.23, 4.83, 4.03, 3.24},
{17.00, 11.00, 8.97, 7.74, 6.91, 6.98, 6.45, 5.62, 4.59, 3.86, 3.03, 2.50},
{17.00, 11.00, 7.06, 3.47, 1.61, 1.26, 2.86, 2.81, 2.91, 3.15, 3.41, 3.61}
},
{//ASIA
{17.69, 25.27, 42.08, 54.23, 45.65, 19.82, 8.37, 7.92, 7.51, 7.12, 6.73, 6.40},
{17.69, 25.27, 32.32, 35.39, 35.77, 22.78, 16.34, 13.40, 11.61, 8.85, 6.61, 5.08},
{17.69, 25.27, 38.76, 52.67, 57.15, 51.92, 37.00, 24.35, 17.03, 15.07, 14.59, 14.11},
{17.69, 25.27, 36.21, 51.46, 56.55, 52.71, 48.88, 40.10, 31.32, 25.64, 23.08, 20.51},
{17.69, 25.27, 28.97, 29.08, 29.18, 27.58, 21.39, 15.29, 10.69, 7.69, 5.80, 4.20},
{17.69, 25.27, 30.14, 32.88, 33.27, 32.03, 26.41, 24.27, 22.05, 21.48, 21.28, 20.60}
},
{//ALM
{10.54, 12.78, 19.98, 25.32, 28.44, 35.52, 44.13, 28.00, 17.78, 13.72, 12.84, 12.05},
{10.54, 12.78, 13.68, 14.58, 15.00, 15.68, 16.82, 15.72, 13.48, 11.32, 8.83, 6.78},
{10.54, 12.78, 14.87, 16.08, 18.64, 21.53, 24.73, 17.92, 13.80, 12.38, 12.37, 12.35},
{10.54, 12.78, 16.46, 24.40, 31.68, 32.58, 33.49, 28.96, 24.43, 22.09, 21.94, 21.79},
{10.54, 12.78, 21.21, 26.84, 33.67, 37.41, 35.64, 29.87, 24.00, 19.54, 15.67, 12.60},
{10.54, 12.78, 14.40, 15.24, 16.68, 17.80, 19.36, 20.05, 19.56, 19.08, 17.96, 17.20},
}
};

} //end