/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.groupchat.GroupchatWindow;
import nu.fw.jeti.plugins.groupchat.elements.IQMUCGetList;
import nu.fw.jeti.plugins.groupchat.elements.IQMUCSetList;
import nu.fw.jeti.plugins.groupchat.elements.IQMUCSetListListener;
import nu.fw.jeti.plugins.groupchat.elements.XMUCUser;
import nu.fw.jeti.plugins.groupchat.events.UserListener;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.TableSorter;

public class ManageMembers
extends JFrame
implements UserListener,
ListSelectionListener,
IQMUCSetListListener {
    public static final int AFFILIATION = 0;
    public static final int ROLE = 1;
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private JPanel jPanel4 = new JPanel();
    private JPanel jPanel5 = new JPanel();
    private JTable tabMembers;
    private JLabel jLabel1 = new JLabel();
    private JComboBox cmbRole = new JComboBox();
    private JComboBox cmbAffiliation = new JComboBox();
    private JLabel jLabel2 = new JLabel();
    private JButton btnAdd = new JButton();
    private JButton btnClose = new JButton();
    private Backend backend;
    private JID roomJID;
    private MyTableModel tableModel;
    private TableSorter sorter;
    private ListSelectionModel lsModel;
    private XMUCUser selectedUser;
    private static String[] columnNames = new String[]{I18N.gettext((String)"groupchat.JID"), I18N.gettext((String)"groupchat.Affiliation"), I18N.gettext((String)"groupchat.Role")};
    private int[] affiliations = new int[]{4, 3, 2, 1, 0};
    private int[] roles = new int[]{7, 6, 5, 0};

    public ManageMembers(Backend backend, JID jID, AbstractListModel abstractListModel) {
        this.backend = backend;
        this.roomJID = jID;
        this.tableModel = new MyTableModel(abstractListModel);
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.tableModel.intervalAdded(new ListDataEvent(abstractListModel, 1, 0, abstractListModel.getSize() - 1));
        new IQMUCGetList(backend, jID, true, 4, this);
        new IQMUCGetList(backend, jID, true, 3, this);
        new IQMUCGetList(backend, jID, false, 7, this);
        new IQMUCGetList(backend, jID, true, 2, this);
        new IQMUCGetList(backend, jID, true, 1, this);
        new IQMUCGetList(backend, jID, false, 6, this);
    }

    private void init() throws Exception {
        Serializable serializable;
        int n;
        this.setTitle(I18N.gettext((String)"groupchat.Manage_Members"));
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.tabMembers = new JTable((TableModel)this.sorter);
        this.sorter.setTableHeader(this.tabMembers.getTableHeader());
        this.sorter.setSortingStatus(0, 1);
        JScrollPane jScrollPane = new JScrollPane(this.tabMembers);
        this.tabMembers.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.lsModel = this.tabMembers.getSelectionModel();
        this.lsModel.addListSelectionListener(this);
        TableColumnModel tableColumnModel = this.tabMembers.getColumnModel();
        for (n = 0; n < this.tabMembers.getColumnCount(); ++n) {
            serializable = new DefaultTableCellRenderer();
            serializable.setHorizontalAlignment(0);
            tableColumnModel.getColumn(n).setCellRenderer((TableCellRenderer)((Object)serializable));
            int n2 = 80;
            if (n == 0) {
                n2 = 150;
            }
            tableColumnModel.getColumn(n).setPreferredWidth(n2);
        }
        I18N.setTextAndMnemonic((String)"groupchat.Role", (JLabel)this.jLabel1);
        this.jLabel1.setLabelFor(this.cmbRole);
        this.cmbRole.setPreferredSize(new Dimension(200, 21));
        this.cmbRole.setEnabled(false);
        for (n = 0; n < this.roles.length; ++n) {
            this.cmbRole.addItem(XMUCUser.getStringRole(this.roles[n]));
        }
        this.cmbRole.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ManageMembers.this.updateMembersRole(ManageMembers.this.roles[ManageMembers.this.cmbRole.getSelectedIndex()]);
                }
            }
        });
        I18N.setTextAndMnemonic((String)"groupchat.Affiliation", (JLabel)this.jLabel2);
        this.jLabel2.setLabelFor(this.cmbAffiliation);
        this.cmbAffiliation.setPreferredSize(new Dimension(200, 21));
        this.cmbAffiliation.setEnabled(false);
        for (n = 0; n < this.affiliations.length; ++n) {
            this.cmbAffiliation.addItem(XMUCUser.getStringAffiliation(this.affiliations[n]));
        }
        this.cmbAffiliation.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ManageMembers.this.updateMembersAff(ManageMembers.this.affiliations[ManageMembers.this.cmbAffiliation.getSelectedIndex()]);
                }
            }
        });
        this.btnAdd.setPreferredSize(new Dimension(200, 21));
        this.btnAdd.setText(I18N.gettext((String)"groupchat.Add_JID") + "...");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageMembers.this.btnAdd_actionPerformed(actionEvent);
            }
        });
        AbstractAction abstractAction = new AbstractAction(I18N.gettext((String)"Close")){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageMembers.this.btnClose_actionPerformed(actionEvent);
            }
        };
        this.btnClose.setAction(abstractAction);
        serializable = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane jLayeredPane = this.getLayeredPane();
        jLayeredPane.getActionMap().put("close", abstractAction);
        jLayeredPane.getInputMap(2).put((KeyStroke)serializable, "close");
        this.getRootPane().setDefaultButton(this.btnClose);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.cmbRole, null);
        this.jPanel2.setLayout(new FlowLayout(2));
        this.jPanel2.add((Component)this.jLabel2, null);
        this.jPanel2.add((Component)this.cmbAffiliation, null);
        this.jPanel3.setLayout(new FlowLayout(2));
        this.jPanel3.add((Component)this.btnAdd, null);
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 1));
        this.jPanel4.add(this.jPanel2);
        this.jPanel4.add(this.jPanel1);
        this.jPanel4.add(this.jPanel3);
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel5.add((Component)this.jPanel4, "First");
        this.jPanel5.add((Component)this.btnClose, "Last");
        this.getContentPane().add((Component)this.jPanel5, "After");
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    void btnAdd_actionPerformed(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog(this, I18N.gettext((String)"groupchat.Add_JID"), I18N.gettext((String)"main.main.popup.JID_of_user_to_add"), 3);
        if (string == null || string.equals("")) {
            return;
        }
        JID jID = null;
        try {
            jID = JID.checkedJIDFromString((String)string);
        }
        catch (InstantiationException instantiationException) {
            Popups.errorPopup((String)instantiationException.getMessage(), (String)I18N.gettext((String)"main.error.Wrong_Jabber_Identifier"));
            return;
        }
        if (jID == null || jID.getUser() == null) {
            JOptionPane.showMessageDialog(null, "There is no user named '" + string + "'", "Unknown user", 0);
            return;
        }
        this.tableModel.addUser(new XMUCUser(jID, 0, 0));
    }

    void btnClose_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void updateMembersAff(int n) {
        if (this.selectedUser != null && this.selectedUser.getAffiliation() == n) {
            return;
        }
        int[] nArray = this.tabMembers.getSelectedRows();
        Vector<JID> vector = new Vector<JID>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            XMUCUser xMUCUser = this.tableModel.getUserAt(this.sorter.modelIndex(nArray[i]));
            if (xMUCUser.getAffiliation() == n) continue;
            vector.add(xMUCUser.getJID());
        }
        new IQMUCSetList(this.backend, this.roomJID, true, n, vector, this);
    }

    void updateMembersRole(int n) {
        if (this.selectedUser != null && this.selectedUser.getRole() == n) {
            return;
        }
        int[] nArray = this.tabMembers.getSelectedRows();
        Vector<JID> vector = new Vector<JID>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            XMUCUser xMUCUser = this.tableModel.getUserAt(this.sorter.modelIndex(nArray[i]));
            if (xMUCUser.getRole() == n) continue;
            vector.add(xMUCUser.getJID());
        }
        new IQMUCSetList(this.backend, this.roomJID, false, n, vector, this);
    }

    public void listSetOk(Vector vector, boolean bl, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            JID jID = (JID)vector.get(i);
            XMUCUser xMUCUser = this.tableModel.getUser(jID);
            if (xMUCUser == null) continue;
            XMUCUser xMUCUser2 = bl ? new XMUCUser(jID, n, xMUCUser.getRole()) : new XMUCUser(jID, xMUCUser.getAffiliation(), n);
            this.tableModel.addUser(xMUCUser2);
        }
    }

    public void userResult(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.tableModel.addUser((XMUCUser)((Object)iterator.next()));
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl;
        int n = -1;
        int n2 = -1;
        this.selectedUser = null;
        if (this.lsModel.isSelectionEmpty()) {
            bl = false;
        } else {
            if (this.lsModel.getMinSelectionIndex() == this.lsModel.getMaxSelectionIndex()) {
                int n3;
                this.selectedUser = this.tableModel.getUserAt(this.sorter.modelIndex(this.lsModel.getMinSelectionIndex()));
                for (n3 = this.roles.length - 1; n3 >= 0 && this.roles[n3] != this.selectedUser.getRole(); --n3) {
                }
                n = n3;
                for (n3 = this.affiliations.length - 1; n3 >= 0 && this.affiliations[n3] != this.selectedUser.getAffiliation(); --n3) {
                }
                n2 = n3;
            }
            bl = true;
        }
        this.cmbRole.setSelectedIndex(n);
        this.cmbAffiliation.setSelectedIndex(n2);
        this.cmbRole.setEnabled(bl);
        this.cmbAffiliation.setEnabled(bl);
    }

    private class MyTableModel
    extends AbstractTableModel
    implements ListDataListener {
        Vector data = new Vector(30);
        AbstractListModel roosterList;

        public MyTableModel(AbstractListModel abstractListModel) {
            this.roosterList = abstractListModel;
            abstractListModel.addListDataListener(this);
        }

        public String getColumnName(int n) {
            return columnNames[n];
        }

        public int getRowCount() {
            return this.data.size();
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public Object getValueAt(int n, int n2) {
            XMUCUser xMUCUser = (XMUCUser)((Object)this.data.get(n));
            switch (n2) {
                case 0: {
                    return xMUCUser.getJID().toStringNoResource();
                }
                case 1: {
                    return xMUCUser.getStringAffiliation();
                }
                case 2: {
                    return xMUCUser.getStringRole();
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void addUser(XMUCUser xMUCUser) {
            for (int i = 0; i < this.data.size(); ++i) {
                XMUCUser xMUCUser2 = (XMUCUser)((Object)this.data.get(i));
                if (!xMUCUser.getJID().equals(xMUCUser2.getJID())) continue;
                this.data.setElementAt(xMUCUser, i);
                this.fireTableRowsUpdated(i, i);
                if (xMUCUser2 == ManageMembers.this.selectedUser) {
                    ManageMembers.this.selectedUser = xMUCUser;
                    ManageMembers.this.valueChanged(null);
                }
                return;
            }
            this.data.add(xMUCUser);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }

        public XMUCUser getUser(JID jID) {
            for (int i = 0; i < this.data.size(); ++i) {
                XMUCUser xMUCUser = (XMUCUser)((Object)this.data.get(i));
                if (!jID.equals(xMUCUser.getJID())) continue;
                return xMUCUser;
            }
            return null;
        }

        public XMUCUser getUserAt(int n) {
            return (XMUCUser)((Object)this.data.get(n));
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                GroupchatWindow.Actor actor = (GroupchatWindow.Actor)((Object)this.roosterList.getElementAt(i));
                ManageMembers.this.tableModel.addUser(new XMUCUser(actor.getFullJID(), actor.getAffiliation(), actor.getRole()));
            }
        }
    }
}

