/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.RosterMenuListener;
import nu.fw.jeti.plugins.groupchat.Bookmarks;
import nu.fw.jeti.plugins.groupchat.GroupChatWindows;
import nu.fw.jeti.plugins.groupchat.GroupchatInvite;
import nu.fw.jeti.plugins.groupchat.GroupchatSignin;
import nu.fw.jeti.plugins.groupchat.GroupchatWindow;
import nu.fw.jeti.plugins.groupchat.elements.XMUC;
import nu.fw.jeti.plugins.groupchat.handlers.XConferenceHandler;
import nu.fw.jeti.plugins.groupchat.handlers.XMUCAdminHandler;
import nu.fw.jeti.plugins.groupchat.handlers.XMUCOwnerHandler;
import nu.fw.jeti.plugins.groupchat.handlers.XMUCUserHandler;
import nu.fw.jeti.ui.StatusButton;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class Plugin
implements Plugins {
    public static final String VERSION = "0.2";
    public static final String DESCRIPTION = "groupchat.groupchat";
    public static final String MIN_JETI_VERSION = "0.5.1";
    public static final String NAME = "groupchat";
    public static final String ABOUT = "by M. Forssen and E.S. de Boer";
    private GroupChatWindows groupchatWindows;
    private JMenu menu = new JMenu();
    private Bookmarks bookmarks;
    private static Plugin plugin;

    public static void init(Backend backend) {
        plugin = new Plugin(backend);
    }

    public Plugin(final Backend backend) {
        I18N.setTextAndMnemonic((String)DESCRIPTION, (AbstractButton)this.menu);
        JMenuItem jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"groupchat.Join/Create", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new GroupchatSignin(backend).setVisible(true);
            }
        });
        this.menu.add(jMenuItem);
        backend.getMain().addToMenu((JMenuItem)this.menu);
        backend.getMain().addToRosterMenu(I18N.gettext((String)"groupchat.Invite_for_groupchat") + "...", new RosterMenuListener(){

            public void actionPerformed(JIDStatus jIDStatus, JIDStatusGroup jIDStatusGroup) {
                GroupchatInvite.inviteUser(backend, jIDStatus.getJID(), Plugin.this.groupchatWindows.getRooms());
            }
        });
        backend.addExtensionHandler("http://jabber.org/protocol/muc#user", (ExtensionHandler)new XMUCUserHandler());
        backend.addExtensionHandler("http://jabber.org/protocol/muc#owner", (ExtensionHandler)new XMUCOwnerHandler());
        backend.addExtensionHandler("http://jabber.org/protocol/muc#admin", (ExtensionHandler)new XMUCAdminHandler());
        backend.addExtensionHandler("jabber:x:conference", (ExtensionHandler)new XConferenceHandler());
        this.groupchatWindows = new GroupChatWindows(backend);
        this.bookmarks = new Bookmarks(backend, this.menu);
    }

    public static GroupchatWindow createGroupChatWindow(JID jID) {
        return Plugin.plugin.groupchatWindows.createGroupChatWindow(jID);
    }

    public static JID getGroupchatJID(JID jID) {
        return Plugin.plugin.groupchatWindows.isGroupchatStarted(jID);
    }

    public static GroupchatWindow getGroupchat(JID jID) {
        return Plugin.plugin.groupchatWindows.getGroupchatWindow(jID);
    }

    public static void startGroupchat(JID jID, Backend backend) {
        if (PluginsInfo.isPluginLoaded((String)"groupchatalerter")) {
            if (nu.fw.jeti.plugins.groupchatalerter.Plugin.disableAlerter((JID)jID)) {
                return;
            }
            Plugin.getGroupchat(jID);
        } else {
            Plugin.getGroupchat(jID);
        }
        if (Preferences.getBoolean((String)"jeti", (String)"statusLinked", (boolean)false)) {
            int n = StatusButton.getStatus();
            backend.send((Packet)new Presence(jID, n, StatusButton.getStatusMessage(), (XExtension)new XMUC()));
        } else {
            backend.send((Packet)new Presence(jID, 2, null, (XExtension)new XMUC()));
        }
    }

    public static void addBookmark(JID jID, String string) {
        Plugin.plugin.bookmarks.addBookmark(jID, string);
    }

    public void unload() {
    }

    public static void unload(Backend backend) {
        Plugin.plugin.groupchatWindows.exit();
        backend.removeExtensionHandler("http://jabber.org/protocol/muc#user");
        backend.removeExtensionHandler("http://jabber.org/protocol/muc#owner");
        backend.removeExtensionHandler("jabber:x:conference");
        backend.removeListener(StatusChangeListener.class, (JETIListener)Plugin.plugin.bookmarks);
        backend.getMain().removeFromMenu((JMenuItem)Plugin.plugin.menu);
        backend.getMain().removeFromRosterMenu(I18N.gettext((String)"groupchat.Invite_for_groupchat"));
        plugin = null;
    }
}

