/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.links;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JFileChooser;
import nu.fw.jeti.plugins.links.BrowserCommandLexer;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class Browser {
    public static String[] exec = null;

    public static void init() {
        exec = Browser.defaultCommands();
        String string = Preferences.getString((String)"links", (String)"browser", null);
        if (string != null) {
            exec = new String[]{string};
        }
    }

    private static void changeDefaultBrowser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(2);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogTitle(I18N.gettext((String)"links.Choose_a_Browser_to_display_links_in"));
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            if (System.getProperty("file.separator").equals("\\")) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(string.charAt(i));
                }
                string = stringBuffer.toString();
            }
            string = string + " {0}";
            Preferences.putString((String)"links", (String)"browser", (String)string);
            exec = new String[]{string};
            System.out.println(string);
        } else {
            Preferences.putString((String)"links", (String)"browser", null);
        }
    }

    public static String[] defaultCommands() {
        Object object = null;
        if (System.getProperty("os.name").startsWith("Windows")) {
            object = new String[]{"rundll32 url.dll,FileProtocolHandler {0}"};
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            Vector<String> vector = new Vector<String>();
            try {
                Process process = Runtime.getRuntime().exec("which open");
                if (process.waitFor() == 0) {
                    vector.add("open {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            object = vector.size() == 0 ? null : vector.toArray(new String[0]);
        } else {
            Process process;
            Vector<String> vector = new Vector<String>();
            try {
                process = Runtime.getRuntime().exec("which firefox");
                if (process.waitFor() == 0) {
                    vector.add("firefox -remote openURL({0})");
                    vector.add("firefox {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                process = Runtime.getRuntime().exec("which mozilla");
                if (process.waitFor() == 0) {
                    vector.add("mozilla -remote openURL({0})");
                    vector.add("mozilla {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                process = Runtime.getRuntime().exec("which opera");
                if (process.waitFor() == 0) {
                    vector.add("opera -remote openURL({0})");
                    vector.add("opera {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                process = Runtime.getRuntime().exec("which galeon");
                if (process.waitFor() == 0) {
                    vector.add("galeon {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                process = Runtime.getRuntime().exec("which konqueror");
                if (process.waitFor() == 0) {
                    vector.add("konqueror {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                process = Runtime.getRuntime().exec("which netscape");
                if (process.waitFor() == 0) {
                    vector.add("netscape -remote openURL({0})");
                    vector.add("netscape {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                process = Runtime.getRuntime().exec("which xterm");
                if (process.waitFor() == 0 && (process = Runtime.getRuntime().exec("which lynx")).waitFor() == 0) {
                    vector.add("xterm -e lynx {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            object = vector.size() == 0 ? null : vector.toArray(new String[0]);
        }
        return object;
    }

    public static void displayURL(String string) throws IOException {
        if (exec == null || exec.length == 0) {
            if (System.getProperty("os.name").startsWith("Mac")) {
                Class<?> clazz;
                Object object;
                boolean bl = false;
                try {
                    if (new File("/System/Library/Java/com/apple/cocoa/application/NSWorkspace.class").exists()) {
                        object = new URLClassLoader(new URL[]{new File("/System/Library/Java").toURL()});
                        clazz = Class.forName("com.apple.cocoa.application.NSWorkspace", true, (ClassLoader)object);
                    } else {
                        clazz = Class.forName("com.apple.cocoa.application.NSWorkspace");
                    }
                    object = clazz.getMethod("sharedWorkspace", new Class[0]);
                    Object object2 = ((Method)object).invoke(null, new Object[0]);
                    Method method = clazz.getMethod("openURL", Class.forName("java.net.URL"));
                    bl = (Boolean)method.invoke(object2, new URL(string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!bl) {
                    try {
                        clazz = Class.forName("com.apple.mrj.MRJFileUtils");
                        object = clazz.getMethod("openURL", Class.forName("java.lang.String"));
                        ((Method)object).invoke(null, string);
                    }
                    catch (Exception exception) {
                        System.err.println(exception.getMessage());
                        throw new IOException("failed");
                    }
                }
            } else {
                Browser.changeDefaultBrowser();
            }
        } else {
            new URL(string);
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == ':' || c == '&' || c == '@' || c == '/' || c == '?' || c == '%' || c == '+' || c == '=' || c == '#' || c == '-' || c == '\\') {
                    stringBuffer.append(c);
                    continue;
                }
                if ((c = (char)(c & 0xFF)) < '\u0010') {
                    stringBuffer.append("%0" + Integer.toHexString(c));
                    continue;
                }
                stringBuffer.append("%" + Integer.toHexString(c));
            }
            Object[] objectArray = new String[]{stringBuffer.toString()};
            String string2 = null;
            boolean bl = false;
            try {
                for (int i = 0; i < exec.length && !bl; ++i) {
                    try {
                        Object object;
                        String string3;
                        string2 = MessageFormat.format(exec[i], objectArray);
                        Vector<String> vector = new Vector<String>();
                        BrowserCommandLexer browserCommandLexer = new BrowserCommandLexer(new StringReader(string2));
                        while ((string3 = browserCommandLexer.getNextToken()) != null) {
                            vector.add(string3);
                        }
                        String[] stringArray = new String[vector.size()];
                        stringArray = vector.toArray(stringArray);
                        boolean bl2 = false;
                        if (stringArray[0].equals("rundll32") && stringArray[1].equals("url.dll,FileProtocolHandler")) {
                            if (stringArray[2].startsWith("file:/")) {
                                if (stringArray[2].charAt(6) != '/') {
                                    stringArray[2] = "file://" + stringArray[2].substring(6);
                                }
                                if (stringArray[2].charAt(7) != '/') {
                                    stringArray[2] = "file:///" + stringArray[2].substring(7);
                                }
                                bl2 = true;
                            } else if (stringArray[2].toLowerCase().endsWith("html") || stringArray[2].toLowerCase().endsWith("htm")) {
                                bl2 = true;
                            }
                        }
                        if (bl2) {
                            object = File.createTempFile("OpenInBrowser", ".url");
                            object = ((File)object).getCanonicalFile();
                            ((File)object).deleteOnExit();
                            PrintWriter printWriter = new PrintWriter(new FileWriter((File)object));
                            printWriter.println("[InternetShortcut]");
                            printWriter.println("URL=" + stringArray[2]);
                            printWriter.close();
                            stringArray[2] = ((File)object).getCanonicalPath();
                        }
                        object = Runtime.getRuntime().exec(stringArray);
                        if (System.getProperty("os.name").equals("OS/2")) {
                            bl = true;
                        }
                        for (int j = 0; j < 2; ++j) {
                            try {
                                Thread.sleep(1000L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (((Process)object).exitValue() != 0) continue;
                        bl = true;
                        continue;
                    }
                    catch (IOException iOException) {
                        System.err.println("warning " + iOException.getMessage());
                    }
                }
                if (!bl) {
                    Preferences.putString((String)"links", (String)"browser", null);
                    Browser.changeDefaultBrowser();
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }
}

