/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.links;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import nu.fw.jeti.applet.Jeti;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.Translator;
import nu.fw.jeti.plugins.Word;
import nu.fw.jeti.plugins.links.Browser;

public class Plugin
implements Plugins,
Translator {
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "links.Make_hyperlinks_clickable";
    public static final String MIN_JETI_VERSION = "0.5.3";
    public static final String NAME = "links";
    public static final String ABOUT = "by E.S. de Boer";
    private SimpleAttributeSet linkAttributeSet = new SimpleAttributeSet();

    public Plugin() {
        StyleConstants.setForeground(this.linkAttributeSet, Color.BLUE);
        StyleConstants.setUnderline(this.linkAttributeSet, true);
    }

    public static void init(Backend backend) {
        if (!Start.applet) {
            Browser.init();
        }
    }

    public void unload() {
    }

    public void init(final JTextComponent jTextComponent) {
        jTextComponent.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    int n = jTextComponent.viewToModel(mouseEvent.getPoint());
                    StyledDocument styledDocument = (StyledDocument)jTextComponent.getDocument();
                    AttributeSet attributeSet = styledDocument.getCharacterElement(n).getAttributes();
                    String string = (String)attributeSet.getAttribute("link");
                    if (string != null) {
                        if (Start.applet) {
                            Jeti.showURL((String)string);
                        } else {
                            Browser.init();
                            try {
                                Browser.displayURL(string);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
    }

    public void translate(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Word word = (Word)list.get(i);
            String string = word.word;
            if (string.startsWith("http")) {
                this.checkIfURL(word, "");
                continue;
            }
            if (!string.startsWith("www") || string.indexOf(".") <= 0 || string.endsWith(".")) continue;
            this.checkIfURL(word, "http://");
        }
    }

    private void checkIfURL(Word word, String string) {
        String string2 = word.word;
        try {
            String string3 = string + string2;
            new URL(string3);
            this.linkAttributeSet.addAttribute("link", string3);
            word.addAttributes((AttributeSet)this.linkAttributeSet);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

