/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.lookandfeel;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.backend.URLClassloader;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class Plugin
implements Plugins {
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "lookandfeel.Changes_Look_and_Feel";
    public static final String MIN_JETI_VERSION = "0.5";
    public static final String NAME = "lookandfeel";
    public static final String ABOUT = "Wrapper for skins see www.javootoo.com";
    public static final String PARENT = "Skins";

    public static void init(Backend backend) {
        String string = Preferences.getString((String)"lf", (String)"currentLF", null);
        if (string == null) {
            return;
        }
        String string2 = null;
        try {
            string2 = (String)Plugin.loadLookAndFeelData().get(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(I18N.gettext((String)"lookandfeel.lookandfeel_cfg_not_found"));
        }
        if (string2 == null) {
            return;
        }
        try {
            Plugin.loadLookAndFeel(backend, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(I18N.gettext((String)"lookandfeel.lookandfeel_could_not_be_loaded"));
        }
    }

    public static void loadLookAndFeel(Backend backend, String string, String string2) throws Exception {
        ClassLoader classLoader = (ClassLoader)UIManager.get("ClassLoader");
        URL uRL = null;
        uRL = new URL(Start.dataURL, "plugins/lf/" + string2);
        if (classLoader == null) {
            classLoader = Plugin.class.getClassLoader();
        } else {
            ((URLClassloader)classLoader).addURL(uRL);
        }
        Class<?> clazz = classLoader.loadClass(string);
        if (string.equals("com.oyoaha.swing.plaf.oyoaha.OyoahaLookAndFeel")) {
            Plugin.initOyoaha(clazz);
        } else if (string.equals("com.l2fprod.gui.plaf.skin.SkinLookAndFeel")) {
            Plugin.initSkinLF(clazz, classLoader);
        } else if (string.equals("org.compiere.plaf.CompiereLookAndFeel")) {
            Plugin.initCompiere(clazz, classLoader);
        } else {
            UIManager.setLookAndFeel((LookAndFeel)clazz.newInstance());
        }
        SwingUtilities.updateComponentTreeUI(backend.getMainWindow());
    }

    private static void initCompiere(Class clazz, ClassLoader classLoader) throws Exception {
        try {
            if (new File(Start.path + "Compiere.properties").exists()) {
                Class<?> clazz2 = classLoader.loadClass("org.compiere.util.Ini");
                Method method = clazz2.getMethod("loadProperties", String.class);
                method.invoke(null, Start.path + "Compiere.properties");
                Class<?> clazz3 = classLoader.loadClass("org.compiere.plaf.CompiereTheme");
                Method method2 = clazz3.getMethod("load", new Class[0]);
                method2.invoke(null, null);
                Class<?> clazz4 = classLoader.loadClass("org.compiere.plaf.CompierePanelUI");
                Method method3 = clazz4.getMethod("setSetDefault", Boolean.TYPE);
                method3.invoke(null, Boolean.TRUE);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UIManager.setLookAndFeel((LookAndFeel)clazz.newInstance());
    }

    private static void initOyoaha(Class clazz) throws Exception {
        Object object;
        Object object2;
        String string = Preferences.getString((String)"lf", (String)"metaltheme", null);
        if (string != null) {
            object2 = new URL(string);
            object = clazz.getMethod("setCurrentTheme", URL.class);
            ((Method)object).invoke(null, object2);
        }
        object2 = clazz.newInstance();
        object = Preferences.getString((String)"lf", (String)"oyoahatheme", null);
        if (object != null) {
            URL uRL = new URL((String)object);
            Method method = clazz.getMethod("setOyoahaTheme", URL.class);
            method.invoke(object2, uRL);
        }
        UIManager.setLookAndFeel((LookAndFeel)object2);
    }

    private static void initSkinLF(Class clazz, ClassLoader classLoader) throws Exception {
        Method method;
        Serializable serializable;
        Object object = null;
        String string = Preferences.getString((String)"lf", (String)"skinlftheme", null);
        if (string == null) {
            serializable = new URL(Start.dataURL, "plugins/lf/themepack.zip");
            object = Plugin.loadSkinLFTheme(serializable, clazz);
        } else if (string.endsWith(".zip")) {
            object = Plugin.loadSkinLFTheme(new URL(string), clazz);
        } else {
            serializable = new URL(string);
            method = clazz.getMethod("loadSkin", URL.class);
            object = method.invoke(null, serializable);
        }
        serializable = classLoader.loadClass("com.l2fprod.gui.plaf.skin.Skin");
        method = clazz.getMethod("setSkin", new Class[]{serializable});
        object = method.invoke(null, object);
        Object t = clazz.newInstance();
        UIManager.setLookAndFeel((LookAndFeel)t);
    }

    private static Object loadSkinLFTheme(URL uRL, Class clazz) throws Exception {
        Method method = clazz.getMethod("loadThemePack", URL.class);
        return method.invoke(null, uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map loadLookAndFeelData() throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        InputStream inputStream = null;
        try {
            inputStream = !Start.applet && new File(Start.path + "plugins" + File.separator + "lf").exists() ? new FileInputStream(Start.path + "plugins" + File.separator + "lf" + File.separator + "lookandfeel.cfg") : new URL(Start.dataURL + "plugins/lf/lookandfeel.cfg").openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            while (bufferedReader.ready()) {
                char c = (char)bufferedReader.read();
                if (c == ' ') {
                    hashMap.put(stringBuffer.toString(), bufferedReader.readLine());
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return hashMap;
    }

    public void unload() {
    }
}

