/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.lookandfeel;

import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.backend.URLClassloader;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.plugins.lookandfeel.Plugin;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Preferences;

public class PrefPanel
extends PreferencesPanel {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JButton jButton1 = new JButton();
    private JPanel pnlLookAndFeels;
    private Map lookAndFeels;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private Backend backend;
    private JPanel pnlCommand;
    private boolean themeChanged = false;
    static /* synthetic */ Class class$java$awt$Frame;

    public PrefPanel(Backend backend) {
        this.backend = backend;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.pnlLookAndFeels = new JPanel();
        this.pnlLookAndFeels.setLayout(new BoxLayout(this.pnlLookAndFeels, 1));
        this.setLayout(this.borderLayout1);
        I18N.setTextAndMnemonic((String)"lookandfeel.Show_Look_and_Feels", (AbstractButton)this.jButton1);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrefPanel.this.jButton1_actionPerformed(actionEvent);
            }
        });
        this.add(this.pnlLookAndFeels, "Center");
        this.add(this.jButton1, "North");
    }

    void jButton1_actionPerformed(ActionEvent actionEvent) {
        try {
            this.lookAndFeels = Plugin.loadLookAndFeelData();
        }
        catch (Exception exception) {
            Popups.errorPopup((String)I18N.gettext((String)"lookandfeel.lookandfeel_cfg_not_found"), (String)I18N.gettext((String)"lookandfeel.File_not_Found"));
            return;
        }
        this.getAvailableLookAndFeels();
    }

    private void getAvailableLookAndFeels() {
        this.pnlCommand = new JPanel();
        Iterator iterator = this.lookAndFeels.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.checkLookAndFeel((String)entry.getKey(), (String)entry.getValue());
        }
        this.add(this.pnlCommand, "South");
        this.invalidate();
        this.validate();
    }

    private void checkLookAndFeel(String string, String string2) {
        URL uRL = null;
        try {
            uRL = new URL(Start.dataURL + "plugins/lf/" + string2);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        try {
            if (uRL.openConnection().getContentLength() > 0) {
                JRadioButton jRadioButton = new JRadioButton(string.substring(string.lastIndexOf(46) + 1, string.length()));
                jRadioButton.setActionCommand(string);
                this.buttonGroup.add(jRadioButton);
                this.pnlLookAndFeels.add(jRadioButton);
                if (string.equals("com.oyoaha.swing.plaf.oyoaha.OyoahaLookAndFeel")) {
                    JPanel jPanel = new JPanel();
                    jPanel.add(this.addFileButton(I18N.gettext((String)"lookandfeel.Set_Oyoaha_Theme"), "oyoahatheme"));
                    jPanel.add(this.addFileButton(I18N.gettext((String)"lookandfeel.Set_Metal_Theme"), "metaltheme"));
                    jPanel.setBorder(new TitledBorder(I18N.gettext((String)"lookandfeel.Oyoaha_options")));
                    this.pnlCommand.add(jPanel);
                } else if (string.equals("com.l2fprod.gui.plaf.skin.SkinLookAndFeel")) {
                    JPanel jPanel = new JPanel();
                    jPanel.add(this.addFileButton(I18N.gettext((String)"lookandfeel.Set_Theme"), "skinlftheme"));
                    jPanel.setBorder(new TitledBorder(I18N.gettext((String)"lookandfeel.SkinLF_options")));
                    this.pnlCommand.add(jPanel);
                } else if (string.equals("org.compiere.plaf.CompiereLookAndFeel")) {
                    JPanel jPanel = new JPanel();
                    JButton jButton = new JButton();
                    I18N.setTextAndMnemonic((String)"lookandfeel.Configure", (AbstractButton)jButton);
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            URLClassloader uRLClassloader = (URLClassloader)UIManager.get("ClassLoader");
                            try {
                                Class clazz = uRLClassloader.loadClass("org.compiere.plaf.CompierePLAFEditor");
                                Constructor constructor = clazz.getConstructor(class$java$awt$Frame == null ? (class$java$awt$Frame = PrefPanel.class$("java.awt.Frame")) : class$java$awt$Frame, Boolean.TYPE);
                                constructor.newInstance(PrefPanel.this.backend.getMainFrame(), Boolean.TRUE);
                                Class clazz2 = uRLClassloader.loadClass("org.compiere.util.Ini");
                                Method method = clazz2.getMethod("saveProperties", Boolean.TYPE);
                                method.invoke(null, Boolean.FALSE);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    });
                    jPanel.add(jButton);
                    jPanel.setBorder(new TitledBorder("Compiere"));
                    this.pnlCommand.add(jPanel);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private JButton addFileButton(String string, final String string2) {
        JButton jButton = new JButton(string);
        final Window window = (Window)this.getTopLevelAncestor();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showOpenDialog(window);
                if (n == 0) {
                    try {
                        Preferences.putString((String)"lf", (String)string2, (String)jFileChooser.getSelectedFile().toURL().toString());
                        PrefPanel.this.themeChanged = true;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        });
        return jButton;
    }

    public void savePreferences() {
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        if (buttonModel == null) {
            return;
        }
        String string = buttonModel.getActionCommand();
        if (!string.equals(Preferences.getString((String)"lf", (String)"currentLF", null)) || this.themeChanged) {
            String string2 = (String)this.lookAndFeels.get(string);
            try {
                Plugin.loadLookAndFeel(this.backend, string, string2);
                Preferences.putString((String)"lf", (String)"currentLF", (String)string);
            }
            catch (Exception exception) {
                Popups.errorPopup((String)MessageFormat.format(I18N.gettext((String)"lookandfeel.{0}_Could_not_be_loaded"), new String(string)), (String)I18N.gettext((String)"lookandfeel.Look_and_feel_error"));
            }
            this.themeChanged = false;
        }
    }
}

