/*
 * Decompiled with CFR 0.152.
 */
package geonoteOutils;

import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class FiltreExtensible
extends FileFilter {
    private String description;
    private ArrayList extensions;

    public FiltreExtensible(String description) {
        if (description == null) {
            throw new NullPointerException("La description ne peut \u00eatre null.");
        }
        this.description = description;
        this.extensions = new ArrayList();
    }

    public boolean accept(File file) {
        if (file.isDirectory() || this.extensions.size() == 0) {
            return true;
        }
        String nomFichier = file.getName().toLowerCase();
        int i = 0;
        while (i < this.extensions.size()) {
            if (nomFichier.endsWith((String)this.extensions.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer(this.description);
        buffer.append(" (");
        int i = 0;
        while (i < this.extensions.size()) {
            buffer.append(this.extensions.get(i)).append(" ");
            ++i;
        }
        return buffer.append(")").toString();
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new NullPointerException("La description ne peut \u00eatre null.");
        }
        this.description = description;
    }

    public void addExtension(String extension) {
        if (extension == null) {
            throw new NullPointerException("Une extension ne peut \u00eatre null.");
        }
        this.extensions.add(extension);
    }

    public void removeExtension(String extension) {
        this.extensions.remove(extension);
    }

    public void clearExtensions() {
        this.extensions.clear();
    }

    public ArrayList getExtensions() {
        return this.extensions;
    }
}

