/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.emoticons;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JViewport;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class EmoticonsEditorKit
extends StyledEditorKit {
    private static final ViewFactory defaultFactory = new StyledViewFactory();

    public ViewFactory getViewFactory() {
        return defaultFactory;
    }

    static class StyledViewFactory
    implements ViewFactory {
        StyledViewFactory() {
        }

        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new LabelView(element);
                }
                if (string.equals("paragraph")) {
                    return new ParagraphView(element);
                }
                if (string.equals("section")) {
                    return new BoxView(element, 1);
                }
                if (string.equals("component")) {
                    return new ComponentView(element);
                }
                if (string.equals("icon")) {
                    return new AnimatedIconView(element);
                }
            }
            return new LabelView(element);
        }

        class AnimatedIconView
        extends IconView
        implements ImageObserver {
            private Container container;
            private JViewport viewport;
            private Rectangle bounds;

            public AnimatedIconView(Element element) {
                super(element);
                this.container = null;
                this.bounds = null;
                Icon icon = StyleConstants.getIcon(this.getAttributes());
                if (icon instanceof ImageIcon) {
                    ((ImageIcon)icon).setImageObserver(this);
                }
            }

            public void setParent(View view) {
                super.setParent(view);
                this.container = this.getContainer();
                if (this.container != null) {
                    this.viewport = (JViewport)this.container.getParent();
                }
            }

            public void paint(Graphics graphics, Shape shape) {
                super.paint(graphics, shape);
                this.bounds = shape.getBounds();
            }

            public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                if ((n & 0x10) > 0 && this.container != null && this.bounds != null) {
                    if (!this.container.isDisplayable()) {
                        this.container = null;
                    } else if (this.viewport.getViewRect().contains(this.bounds)) {
                        this.container.repaint((int)this.bounds.getX(), (int)this.bounds.getY(), (int)this.bounds.getWidth(), (int)this.bounds.getHeight());
                    }
                }
                return true;
            }
        }
    }
}

