/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.plugins.filetransfer.Plugin;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class PrefPanel
extends PreferencesPanel {
    private JComboBox cmbIP;
    private JTextField txtPort = new JTextField();
    private JCheckBox chkUseLocal;
    private JCheckBox chkCloseOnComplete;

    public PrefPanel(Backend backend) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        String string = Preferences.getString((String)"filetransfer", (String)"ip", null);
        String string2 = Plugin.getIP();
        String[] stringArray = string != null && !string.equals("automatic") ? (string2 != null ? new String[]{string, string2, I18N.gettext((String)"filetransfer.automatic") + " (" + string2 + ")"} : new String[]{string}) : (string2 != null ? new String[]{I18N.gettext((String)"filetransfer.automatic") + " (" + string2 + ")", string2} : new String[]{});
        this.cmbIP = new JComboBox<String>(stringArray);
        this.cmbIP.setEditable(true);
        this.txtPort.setText(Preferences.getString((String)"filetransfer", (String)"port", (String)"7777"));
        this.chkUseLocal = new JCheckBox(I18N.gettext((String)"filetransfer.behind_firewall_or_NAT"));
        this.chkUseLocal.setSelected(!Preferences.getBoolean((String)"filetransfer", (String)"useLocalIP", (boolean)true));
        this.add(this.chkUseLocal, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 21;
        this.add(new JLabel(I18N.gettext((String)"filetransfer.ip")), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add(this.cmbIP, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.add(new JLabel(I18N.gettext((String)"filetransfer.port")), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add(this.txtPort, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.chkCloseOnComplete = new JCheckBox(I18N.gettext((String)"filetransfer.close_download_windows_when_download_ready"));
        this.chkCloseOnComplete.setSelected(Preferences.getBoolean((String)"filetransfer", (String)"closeOnComplete", (boolean)false));
        this.add(this.chkCloseOnComplete, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    public void savePreferences() {
        String string;
        Preferences.putBoolean((String)"filetransfer", (String)"useLocalIP", (!this.chkUseLocal.isSelected() ? 1 : 0) != 0);
        Preferences.putBoolean((String)"filetransfer", (String)"closeOnComplete", (boolean)this.chkCloseOnComplete.isSelected());
        if (this.cmbIP.getSelectedIndex() != -1 && !this.cmbIP.getSelectedItem().equals("") && (string = this.cmbIP.getSelectedItem().toString()) != null) {
            if (string.startsWith(I18N.gettext((String)"filetransfer.automatic"))) {
                string = "automatic";
            }
            Preferences.putString((String)"filetransfer", (String)"ip", (String)string);
        }
        if (!this.txtPort.getText().equals("")) {
            try {
                int n = Integer.parseInt(this.txtPort.getText());
                Preferences.putInteger((String)"titlescroller", (String)"scrolltime", (int)n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

