/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer.ibb;

import java.util.HashMap;
import java.util.Map;
import nu.fw.jeti.backend.XExecutableExtension;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.XMPPError;
import nu.fw.jeti.jabber.elements.XMPPErrorTag;
import nu.fw.jeti.plugins.filetransfer.GetFileWindow;
import nu.fw.jeti.plugins.filetransfer.Plugin;
import nu.fw.jeti.plugins.filetransfer.ibb.IBBReceive;
import nu.fw.jeti.util.Log;

public class IBBExtension
extends Extension
implements IQExtension,
XExecutableExtension {
    private boolean close;
    private boolean open;
    private String sid;
    private int sequence;
    private int blockSize = 4096;
    private String base64data;
    private static Map fileWindows = new HashMap(10);

    public IBBExtension(String string, int n) {
        this.open = true;
        this.blockSize = n;
        this.sid = string;
    }

    public IBBExtension(String string) {
        this.close = true;
        this.sid = string;
    }

    public IBBExtension(String string, int n, String string2) {
        this.sid = string;
        this.sequence = n;
        this.base64data = string2;
    }

    public IBBExtension(boolean bl, boolean bl2, String string, int n, int n2, String string2) {
        this.open = bl;
        this.close = bl2;
        this.sid = string;
        this.blockSize = n;
        this.sequence = n2;
        this.base64data = string2;
    }

    public String getData() {
        return this.base64data;
    }

    public String getSid() {
        return this.sid;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClose() {
        return this.close;
    }

    public void execute(Packet packet, Backend backend) {
        GetFileWindow getFileWindow = (GetFileWindow)fileWindows.get(this.sid);
        if (getFileWindow == null) {
            Log.xmlReceivedError((String)"ibb stream from unknown");
        } else {
            IBBReceive iBBReceive = (IBBReceive)getFileWindow.getStreamReceive();
            iBBReceive.addData(this.getData());
        }
    }

    public void execute(InfoQuery infoQuery, Backend backend) {
        if (infoQuery.getType().equals("set")) {
            GetFileWindow getFileWindow;
            if (this.isOpen()) {
                getFileWindow = Plugin.getGetFile(infoQuery.getFrom());
                if (getFileWindow != null) {
                    getFileWindow.startDownloading(new IBBReceive(infoQuery.getFrom(), this.getSid(), backend, getFileWindow));
                    fileWindows.put(this.getSid(), getFileWindow);
                    backend.send((Packet)new InfoQuery(infoQuery.getFrom(), "result", infoQuery.getID(), null));
                    Log.xmlReceivedError((String)"ibb stream init from unknown");
                } else {
                    XMPPError xMPPError = new XMPPError("cancel", 501);
                    xMPPError.addError(new XMPPErrorTag("feature-not-implemented"));
                    backend.send((Packet)new InfoQuery(infoQuery.getFrom(), infoQuery.getID(), xMPPError));
                }
            }
            if (this.isClose()) {
                getFileWindow = (GetFileWindow)fileWindows.remove(this.sid);
                if (getFileWindow != null) {
                    ((IBBReceive)getFileWindow.getStreamReceive()).stopDownloading();
                }
                backend.send((Packet)new InfoQuery(infoQuery.getFrom(), "result", infoQuery.getID(), null));
            }
        }
    }

    public void appendToXML(StringBuffer stringBuffer) {
        if (this.open) {
            stringBuffer.append("<open xmlns= 'http://jabber.org/protocol/ibb'");
            IBBExtension.appendAttribute((StringBuffer)stringBuffer, (String)"sid", (String)this.sid);
            IBBExtension.appendAttribute((StringBuffer)stringBuffer, (String)"block-size", (String)String.valueOf(this.blockSize));
            stringBuffer.append("/>");
        } else if (this.close) {
            stringBuffer.append("<close xmlns= 'http://jabber.org/protocol/ibb'");
            IBBExtension.appendAttribute((StringBuffer)stringBuffer, (String)"sid", (String)this.sid);
            stringBuffer.append("/>");
        } else {
            stringBuffer.append("<data xmlns= 'http://jabber.org/protocol/ibb'");
            IBBExtension.appendAttribute((StringBuffer)stringBuffer, (String)"sid", (String)this.sid);
            IBBExtension.appendAttribute((StringBuffer)stringBuffer, (String)"seq", (String)String.valueOf(this.sequence));
            stringBuffer.append(">");
            stringBuffer.append(this.base64data);
            stringBuffer.append("</data>");
            stringBuffer.append("<amp xmlns='http://jabber.org/protocol/amp'>");
            stringBuffer.append("<rule condition='deliver-at' value='stored' action='error'/>");
            stringBuffer.append("<rule condition='match-resource' value='exact' action='error'/>");
            stringBuffer.append("</amp>");
        }
    }
}

