/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer.ibb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import nu.fw.jeti.events.IQResultListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.plugins.filetransfer.SendFileProgress;
import nu.fw.jeti.plugins.filetransfer.StreamSend;
import nu.fw.jeti.plugins.filetransfer.ibb.IBBExtension;
import nu.fw.jeti.util.Base64;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;

public class IBBSend
extends Thread
implements StreamSend {
    static final int BUF_SIZE = 4096;
    private File file;
    private SendFileProgress window;
    private long bytes;
    private int sequence;
    private Backend backend;
    private JID to;
    private String sid;
    byte[] buf = new byte[4096];

    public IBBSend(File file, Backend backend, SendFileProgress sendFileProgress, JID jID) {
        this.file = file;
        this.backend = backend;
        this.window = sendFileProgress;
        this.to = jID;
        this.sid = backend.getIdentifier();
        this.setPriority(5);
        backend.send(new InfoQuery(jID, "set", "ibb" + backend.getIdentifier(), (IQExtension)new IBBExtension(this.sid, 4096)), new IQResultListener(){

            public void iqResult(InfoQuery infoQuery) {
                if (infoQuery.getType().equals("result")) {
                    IBBSend.this.start();
                } else {
                    Popups.messagePopup((String)I18N.gettext((String)"filetransfer.Problem_during_file_transfer,_transfer_aborted"), (String)I18N.gettext((String)"filetransfer.File_Transfer"));
                    IBBSend.this.window.stop();
                }
            }
        }, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.file.getAbsolutePath());
            while (inputStream.read(this.buf) > 0) {
                String string = Base64.encodeBytes((byte[])this.buf);
                this.backend.send((Packet)new Message(null, this.to, (XExtension)new IBBExtension(this.sid, this.sequence, string)));
                ++this.sequence;
                this.bytes += 4096L;
                if (Thread.interrupted()) {
                    this.sendStreamClose();
                    inputStream.close();
                    this.window.stop();
                    return;
                }
                Thread.yield();
            }
            this.backend.send((Packet)new InfoQuery(this.to, "set", (IQExtension)new IBBExtension(this.sid)));
        }
        catch (IOException iOException) {
            this.sendStreamClose();
            Popups.messagePopup((String)I18N.gettext((String)"filetransfer.Problem_during_file_transfer,_transfer_aborted"), (String)I18N.gettext((String)"filetransfer.File_Transfer"));
            this.window.stop();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.window.done();
    }

    private void sendStreamClose() {
        this.backend.send((Packet)new InfoQuery(this.to, "set", "ibb" + this.backend.getIdentifier(), (IQExtension)new IBBExtension(this.sid)));
    }

    public long getBytes() {
        return this.bytes;
    }

    public void cancel() {
        this.interrupt();
    }
}

