/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer.socks5;

import java.util.Iterator;
import java.util.List;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.plugins.filetransfer.GetFileWindow;
import nu.fw.jeti.plugins.filetransfer.Plugin;
import nu.fw.jeti.plugins.filetransfer.socks5.ReceiveSocks5;
import nu.fw.jeti.plugins.filetransfer.socks5.StreamHost;
import nu.fw.jeti.util.Log;

public class Socks5Extension
extends Extension
implements IQExtension {
    private String sid;
    private JID streamHost;
    private List streamHosts;
    private JID activate;

    public Socks5Extension(String string, JID jID, List list, JID jID2) {
        this.sid = string;
        this.streamHost = jID;
        this.streamHosts = list;
        this.activate = jID2;
    }

    public Socks5Extension(String string, List list) {
        this.sid = string;
        this.streamHosts = list;
    }

    public Socks5Extension(String string, JID jID) {
        this.sid = string;
        this.activate = jID;
    }

    public Socks5Extension(JID jID, String string) {
        this.sid = string;
        this.streamHost = jID;
    }

    public String getSid() {
        return this.sid;
    }

    public JID getStreamHostUsed() {
        return this.streamHost;
    }

    public boolean hasStreamHosts() {
        return this.streamHosts != null;
    }

    public Iterator getStreamHosts() {
        return this.streamHosts.iterator();
    }

    public void execute(InfoQuery infoQuery, Backend backend) {
        if (infoQuery.getType().equals("set")) {
            GetFileWindow getFileWindow = Plugin.getGetFile(infoQuery.getFrom());
            if (getFileWindow == null) {
                Log.xmlReceivedError((String)"Socks stream from unknown");
            } else {
                getFileWindow.startDownloading(new ReceiveSocks5(backend, infoQuery, getFileWindow));
            }
        }
    }

    public void appendToXML(StringBuffer stringBuffer) {
        stringBuffer.append("<query xmlns= 'http://jabber.org/protocol/bytestreams'");
        Socks5Extension.appendAttribute((StringBuffer)stringBuffer, (String)"sid", (String)this.sid);
        stringBuffer.append(">");
        Socks5Extension.appendElement((StringBuffer)stringBuffer, (String)"activate", (Object)this.activate);
        if (this.streamHost != null) {
            stringBuffer.append("<streamhost-used");
            Socks5Extension.appendAttribute((StringBuffer)stringBuffer, (String)"jid", (Object)this.streamHost);
            stringBuffer.append("/>");
        }
        if (this.streamHosts != null) {
            Iterator iterator = this.streamHosts.iterator();
            while (iterator.hasNext()) {
                ((StreamHost)((Object)iterator.next())).appendToXML(stringBuffer);
            }
        }
        stringBuffer.append("</query>");
    }
}

