/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer.socks5.jsocks;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import nu.fw.jeti.plugins.filetransfer.socks5.Socks5Send;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.Proxy;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.ProxyMessage;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.ServerAuthenticator;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.Socks4Message;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.Socks5Message;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.SocksException;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.SocksServerSocket;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.UDPRelayServer;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;

public class ProxyServer
implements Runnable {
    ServerAuthenticator auth;
    ProxyMessage msg = null;
    Socket sock = null;
    Socket remote_sock = null;
    ServerSocket ss = null;
    UDPRelayServer relayServer = null;
    InputStream in;
    OutputStream out;
    File file;
    String sha1Digest;
    Thread pst;
    Socks5Send send;
    int mode;
    static final int START_MODE = 0;
    static final int ACCEPT_MODE = 1;
    static final int PIPE_MODE = 2;
    static final int ABORT_MODE = 3;
    static final int BUF_SIZE = 8192;
    long lastReadTime;
    static int iddleTimeout = 180000;
    static int acceptTimeout = 180000;
    static PrintStream log = null;
    static Proxy proxy;
    static final String[] command_names;

    public ProxyServer(ServerAuthenticator serverAuthenticator) {
        this.auth = serverAuthenticator;
    }

    public ProxyServer(ServerAuthenticator serverAuthenticator, Socket socket, File file, String string, Socks5Send socks5Send) {
        this.auth = serverAuthenticator;
        this.sock = socket;
        this.file = file;
        this.send = socks5Send;
        this.sha1Digest = string;
        this.mode = 0;
        ProxyServer.setLog(System.out);
        this.pst = new Thread(this);
        this.pst.start();
    }

    public static void setLog(OutputStream outputStream) {
        log = outputStream == null ? null : new PrintStream(outputStream, true);
        UDPRelayServer.log = log;
    }

    public static void setProxy(Proxy proxy) {
        UDPRelayServer.proxy = ProxyServer.proxy = proxy;
    }

    public static Proxy getProxy() {
        return proxy;
    }

    public static void setIddleTimeout(int n) {
        iddleTimeout = n;
    }

    public static void setAcceptTimeout(int n) {
        acceptTimeout = n;
    }

    public static void setUDPTimeout(int n) {
        UDPRelayServer.setTimeout(n);
    }

    public static void setDatagramSize(int n) {
        UDPRelayServer.setDatagramSize(n);
    }

    public void start(int n) {
        this.start(n, 5, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int n, int n2, InetAddress inetAddress) {
        try {
            this.ss = new ServerSocket(n, n2, inetAddress);
            ProxyServer.log("Starting SOCKS Proxy on:" + this.ss.getInetAddress().getHostAddress() + ":" + this.ss.getLocalPort());
            while (true) {
                Socket socket = this.ss.accept();
                ProxyServer.log("Accepted from:" + socket.getInetAddress().getHostName() + ":" + socket.getPort());
                ProxyServer proxyServer = new ProxyServer(this.auth, socket, null, null, null);
                new Thread(proxyServer).start();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void stop() {
        try {
            if (this.ss != null) {
                this.ss.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pst.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        switch (this.mode) {
            case 0: {
                try {
                    this.startSession();
                    break;
                }
                catch (IOException iOException) {
                    this.handleException(iOException);
                    break;
                }
                finally {
                    this.abort();
                    if (this.auth != null) {
                        this.auth.endSession();
                    }
                    ProxyServer.log("Main thread(client->remote)stopped.");
                }
            }
            case 1: {
                try {
                    this.doAccept();
                    this.mode = 2;
                    break;
                }
                catch (IOException iOException) {
                    this.handleException(iOException);
                    break;
                }
                finally {
                    this.abort();
                    ProxyServer.log("Accept thread(remote->client) stopped");
                }
            }
            case 2: {
                this.abort();
                ProxyServer.log("Support thread(remote->client) stopped");
                break;
            }
            case 3: {
                break;
            }
            default: {
                ProxyServer.log("Unexpected MODE " + this.mode);
            }
        }
    }

    private void startSession() throws IOException {
        this.sock.setSoTimeout(iddleTimeout);
        try {
            this.auth = this.auth.startSession(this.sock);
        }
        catch (IOException iOException) {
            ProxyServer.log("Auth throwed exception:" + iOException);
            this.auth = null;
            return;
        }
        if (this.auth == null) {
            ProxyServer.log("Authentication failed");
            return;
        }
        this.in = this.auth.getInputStream();
        this.out = this.auth.getOutputStream();
        this.msg = this.readMsg(this.in);
        this.handleRequest(this.msg);
    }

    private void handleRequest(ProxyMessage proxyMessage) throws IOException {
        if (!this.auth.checkRequest(proxyMessage)) {
            throw new SocksException(1);
        }
        if (proxyMessage.ip == null && !(proxyMessage instanceof Socks5Message)) {
            throw new SocksException(1);
        }
        ProxyServer.log(proxyMessage);
        switch (proxyMessage.command) {
            case 1: {
                this.onConnect(proxyMessage);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new SocksException(7);
            }
        }
    }

    private void handleException(IOException iOException) {
        Popups.messagePopup((String)I18N.gettext((String)"filetransfer.Problem_during_file_transfer,_transfer_aborted"), (String)I18N.gettext((String)"filetransfer.File_Transfer"));
        this.send.finished();
        iOException.printStackTrace();
        if (this.msg == null) {
            return;
        }
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 2) {
            return;
        }
        int n = 1;
        if (iOException instanceof SocksException) {
            n = ((SocksException)iOException).errCode;
        } else if (iOException instanceof NoRouteToHostException) {
            n = 4;
        } else if (iOException instanceof ConnectException) {
            n = 5;
        } else if (iOException instanceof InterruptedIOException) {
            n = 6;
        }
        if (n > 8 || n < 0) {
            n = 1;
        }
        this.sendErrorMessage(n);
    }

    private void onConnect(ProxyMessage proxyMessage) throws IOException {
        ProxyMessage proxyMessage2 = null;
        if (proxyMessage.host.equals(this.sha1Digest) && proxyMessage.port == 0) {
            ProxyServer.log("Connected to " + proxyMessage.host + ":" + proxyMessage.port);
            if (proxyMessage instanceof Socks5Message) {
                proxyMessage2 = new Socks5Message(0, proxyMessage.host, proxyMessage.port);
            }
        } else {
            System.out.println("invalid entry");
            throw new ConnectException();
        }
        proxyMessage2.write(this.out);
        this.startPipe(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBind(ProxyMessage proxyMessage) throws IOException {
        ProxyMessage proxyMessage2 = null;
        this.ss = proxy == null ? new ServerSocket(0) : new SocksServerSocket(proxy, proxyMessage.ip, proxyMessage.port);
        this.ss.setSoTimeout(acceptTimeout);
        ProxyServer.log("Trying accept on " + this.ss.getInetAddress() + ":" + this.ss.getLocalPort());
        proxyMessage2 = proxyMessage.version == 5 ? new Socks5Message(0, this.ss.getInetAddress(), this.ss.getLocalPort()) : new Socks4Message(90, this.ss.getInetAddress(), this.ss.getLocalPort());
        proxyMessage2.write(this.out);
        this.mode = 1;
        this.sock.setSoTimeout(0);
        int n = 0;
        try {
            while ((n = this.in.read()) >= 0) {
                if (this.mode == 1) continue;
                if (this.mode == 2) break;
                return;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
        catch (InterruptedIOException interruptedIOException) {
            if (this.mode != 2) {
                return;
            }
        }
        if (n < 0) {
            return;
        }
    }

    private void onUDP(ProxyMessage proxyMessage) throws IOException {
        if (proxyMessage.ip.getHostAddress().equals("0.0.0.0")) {
            proxyMessage.ip = this.sock.getInetAddress();
        }
        ProxyServer.log("Creating UDP relay server for " + proxyMessage.ip + ":" + proxyMessage.port);
        this.relayServer = new UDPRelayServer(proxyMessage.ip, proxyMessage.port, Thread.currentThread(), this.sock, this.auth);
        Socks5Message socks5Message = new Socks5Message(0, this.relayServer.relayIP, this.relayServer.relayPort);
        ((ProxyMessage)socks5Message).write(this.out);
        this.relayServer.start();
        this.sock.setSoTimeout(0);
        try {
            while (this.in.read() >= 0) {
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private void doAccept() throws IOException {
        Socket socket;
        long l = System.currentTimeMillis();
        while (true) {
            if ((socket = this.ss.accept()).getInetAddress().equals(this.msg.ip)) break;
            if (this.ss instanceof SocksServerSocket) {
                socket.close();
                this.ss.close();
                throw new SocksException(1);
            }
            if (acceptTimeout != 0) {
                int n = acceptTimeout - (int)(System.currentTimeMillis() - l);
                if (n <= 0) {
                    throw new InterruptedIOException("In doAccept()");
                }
                this.ss.setSoTimeout(n);
            }
            socket.close();
        }
        this.ss.close();
        this.remote_sock = socket;
        this.remote_sock.setSoTimeout(iddleTimeout);
        ProxyServer.log("Accepted from " + socket.getInetAddress() + ":" + socket.getPort());
        ProxyMessage proxyMessage = this.msg.version == 5 ? new Socks5Message(0, socket.getInetAddress(), socket.getPort()) : new Socks4Message(90, socket.getInetAddress(), socket.getPort());
        proxyMessage.write(this.out);
    }

    private ProxyMessage readMsg(InputStream inputStream) throws IOException {
        ProxyMessage proxyMessage;
        PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        int n = pushbackInputStream.read();
        pushbackInputStream.unread(n);
        if (n == 5) {
            proxyMessage = new Socks5Message(pushbackInputStream, false);
        } else if (n == 4) {
            proxyMessage = new Socks4Message(pushbackInputStream, false);
        } else {
            throw new SocksException(1);
        }
        return proxyMessage;
    }

    private void startPipe(Socket socket) {
        this.mode = 2;
        this.remote_sock = socket;
        try {
            this.pipe(this.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendErrorMessage(int n) {
        ProxyMessage proxyMessage = this.msg instanceof Socks4Message ? new Socks4Message(91) : new Socks5Message(n);
        try {
            proxyMessage.write(this.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void abort() {
        if (this.mode == 3) {
            return;
        }
        this.mode = 3;
        try {
            ProxyServer.log("Aborting operation");
            if (this.remote_sock != null) {
                this.remote_sock.close();
            }
            if (this.sock != null) {
                this.sock.close();
            }
            if (this.relayServer != null) {
                this.relayServer.stop();
            }
            if (this.ss != null) {
                this.ss.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static final void log(String string) {
        if (log != null) {
            log.println(string);
            log.flush();
        }
    }

    static final void log(ProxyMessage proxyMessage) {
        ProxyServer.log("Request version:" + proxyMessage.version + "\tCommand: " + ProxyServer.command2String(proxyMessage.command));
        ProxyServer.log("IP:" + proxyMessage.ip + "\tPort:" + proxyMessage.port + (proxyMessage.version == 4 ? "\tUser:" + proxyMessage.user : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pipe(OutputStream outputStream) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.file.getAbsolutePath());
        byte[] byArray = new byte[8192];
        try {
            int n;
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
                outputStream.flush();
                this.send.addBytes(n);
                if (Thread.interrupted()) {
                    return;
                }
                Thread.yield();
            }
            this.send.finished();
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    static final String command2String(int n) {
        if (n > 0 && n < 4) {
            return command_names[n - 1];
        }
        return "Unknown Command " + n;
    }

    static {
        command_names = new String[]{"CONNECT", "BIND", "UDP_ASSOCIATE"};
    }
}

