/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer.socks5.jsocks;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.ProxyMessage;
import nu.fw.jeti.plugins.filetransfer.socks5.jsocks.SocksException;

class Socks4Message
extends ProxyMessage {
    private byte[] msgBytes;
    private int msgLength;
    static final String[] replyMessage = new String[]{"Request Granted", "Request Rejected or Failed", "Failed request, can't connect to Identd", "Failed request, bad user name"};
    static final int SOCKS_VERSION = 4;
    public static final int REQUEST_CONNECT = 1;
    public static final int REQUEST_BIND = 2;
    public static final int REPLY_OK = 90;
    public static final int REPLY_REJECTED = 91;
    public static final int REPLY_NO_CONNECT = 92;
    public static final int REPLY_BAD_IDENTD = 93;

    public Socks4Message(int n) {
        super(n, null, 0);
        this.user = null;
        this.msgLength = 2;
        this.msgBytes = new byte[2];
        this.msgBytes[0] = 0;
        this.msgBytes[1] = (byte)this.command;
    }

    public Socks4Message(int n, InetAddress inetAddress, int n2) {
        this(0, n, inetAddress, n2, null);
    }

    public Socks4Message(int n, InetAddress inetAddress, int n2, String string) {
        this(4, n, inetAddress, n2, string);
    }

    public Socks4Message(int n, int n2, InetAddress inetAddress, int n3, String string) {
        super(n2, inetAddress, n3);
        byte[] byArray;
        this.user = string;
        this.version = n;
        this.msgLength = string == null ? 8 : 9 + string.length();
        this.msgBytes = new byte[this.msgLength];
        this.msgBytes[0] = (byte)n;
        this.msgBytes[1] = (byte)this.command;
        this.msgBytes[2] = (byte)(n3 >> 8);
        this.msgBytes[3] = (byte)n3;
        if (inetAddress != null) {
            byArray = inetAddress.getAddress();
        } else {
            byArray = new byte[4];
            byArray[3] = 0;
            byArray[2] = 0;
            byArray[1] = 0;
            byArray[0] = 0;
        }
        System.arraycopy(byArray, 0, this.msgBytes, 4, 4);
        if (string != null) {
            byte[] byArray2 = string.getBytes();
            System.arraycopy(byArray2, 0, this.msgBytes, 8, byArray2.length);
            this.msgBytes[this.msgBytes.length - 1] = 0;
        }
    }

    public Socks4Message(InputStream inputStream, boolean bl) throws IOException {
        this.msgBytes = null;
        this.read(inputStream, bl);
    }

    public void read(InputStream inputStream) throws IOException {
        this.read(inputStream, true);
    }

    public void read(InputStream inputStream, boolean bl) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.version = dataInputStream.readUnsignedByte();
        this.command = dataInputStream.readUnsignedByte();
        if (bl && this.command != 90) {
            String string = this.command > 90 && this.command < 93 ? replyMessage[this.command - 90] : "Unknown Reply Code";
            throw new SocksException(this.command, string);
        }
        this.port = dataInputStream.readUnsignedShort();
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray);
        this.ip = Socks4Message.bytes2IP(byArray);
        this.host = this.ip.getHostName();
        if (!bl) {
            int n = inputStream.read();
            byte[] byArray2 = new byte[256];
            int n2 = 0;
            for (n2 = 0; n2 < byArray2.length && n > 0; ++n2) {
                byArray2[n2] = (byte)n;
                n = inputStream.read();
            }
            this.user = new String(byArray2, 0, n2);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.msgBytes == null) {
            Socks4Message socks4Message = new Socks4Message(this.version, this.command, this.ip, this.port, this.user);
            this.msgBytes = socks4Message.msgBytes;
            this.msgLength = socks4Message.msgLength;
        }
        outputStream.write(this.msgBytes);
    }

    static InetAddress bytes2IP(byte[] byArray) {
        String string = Socks4Message.bytes2IPV4(byArray, 0);
        try {
            return InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }
}

