/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.search;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import nu.fw.jeti.events.DiscoveryListener;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.DiscoveryInfo;
import nu.fw.jeti.jabber.elements.DiscoveryItem;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.plugins.search.IQSearch;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Utils;

public class JUDChooser
extends JFrame
implements DiscoveryListener {
    private Backend backend;
    private JID server;
    private int numberOfServices;
    private List services = new LinkedList();

    public JUDChooser(Backend backend) {
        this.backend = backend;
        this.server = new JID(backend.getMyJID().getDomain());
        backend.getItems(this.server, (DiscoveryListener)this);
    }

    private void showFrame() {
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        this.setTitle(I18N.gettext((String)"search.User_Search"));
        this.setDefaultCloseOperation(2);
        final JComboBox<Object> jComboBox = new JComboBox<Object>(this.services.toArray());
        jComboBox.setAlignmentX(0.0f);
        jComboBox.setEditable(true);
        JButton jButton = new JButton();
        AbstractAction abstractAction = new AbstractAction(I18N.gettext((String)"Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                JUDChooser.this.dispose();
            }
        };
        Utils.addCancelButton((RootPaneContainer)this, (JButton)jButton, (Action)abstractAction);
        JButton jButton2 = new JButton();
        jButton2.setText(I18N.gettext((String)"OK"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getSelectedItem();
                if (object == null) {
                    return;
                }
                JID jID = ((Item)object).server;
                JUDChooser.this.backend.send((Packet)new InfoQuery(jID, "get", (IQExtension)new IQSearch()));
                JUDChooser.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(jButton2);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)new JLabel(I18N.gettext((String)"search.Select_the_user_directory_to_search")), gridBagConstraints);
        this.getContentPane().add(jComboBox, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.add((Component)jButton2, null);
        jPanel.add((Component)jButton, null);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void discoveryItemResult(JID jID, DiscoveryItem discoveryItem) {
        if (!discoveryItem.hasItems()) {
            Popups.errorPopup((String)I18N.gettext((String)"main.error.No_services"), (String)I18N.gettext((String)"main.error.Register_Services"));
        } else {
            this.numberOfServices = discoveryItem.getSize();
            this.services.clear();
            Iterator iterator = discoveryItem.getItems();
            while (iterator.hasNext()) {
                DiscoveryItem discoveryItem2 = (DiscoveryItem)iterator.next();
                String string = discoveryItem2.getName();
                if (string == null) {
                    string = discoveryItem2.getJID().toStringNoResource();
                }
                this.backend.getInfo(discoveryItem2.getJID(), (DiscoveryListener)this);
            }
        }
    }

    public void discoveryInfoResult(JID jID, DiscoveryInfo discoveryInfo) {
        Iterator iterator;
        --this.numberOfServices;
        String string = discoveryInfo.getName();
        if (discoveryInfo.hasFeatures()) {
            iterator = discoveryInfo.getFeatures();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.equals("jabber:iq:search")) continue;
                if (string != null) {
                    this.services.add(new Item(discoveryInfo.getName(), jID));
                    continue;
                }
                this.services.add(new Item(jID.toStringNoResource(), jID));
            }
        }
        if (this.numberOfServices == 0) {
            if (this.services.size() == 1) {
                iterator = ((Item)this.services.get((int)0)).server;
                this.backend.send((Packet)new InfoQuery((JID)iterator, "get", (IQExtension)new IQSearch()));
            } else {
                this.showFrame();
            }
        }
    }

    private class Item {
        String name;
        JID server;

        public Item(String string, JID jID) {
            this.name = string;
            this.server = jID;
        }

        public String toString() {
            return this.name;
        }
    }
}

