/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.sound;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.MessageListener;
import nu.fw.jeti.events.PresenceListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Preferences;

public class Plugin
implements Plugins,
MessageListener,
PresenceListener,
StatusChangeListener {
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "sound.Plays_a_sound_on_new_message_or_person_available";
    public static final String MIN_JETI_VERSION = "0.5.1";
    public static final String NAME = "sound";
    public static final String ABOUT = "by E.S. de Boer";
    public static final String PARENT = "Notifiers";
    private static final int MESSAGE = 0;
    private static final int ONLINE = 1;
    private static final int OFFLINE = 2;
    private long[] lastTime = new long[]{0L, 0L, 0L};
    private static Plugin plugin;
    private Map sounds;
    private PlayList playList;
    private boolean singleLine = false;

    public Plugin(Backend backend) {
        this.initSounds();
        if (this.sounds.get("message") != null) {
            backend.addListener(MessageListener.class, (JETIListener)this);
        }
        if (this.sounds.get("online") != null || this.sounds.get("offline") != null) {
            backend.addListener(PresenceListener.class, (JETIListener)this);
        }
        if (this.sounds.get("own_online") != null || this.sounds.get("own_offline") != null) {
            backend.addListener(StatusChangeListener.class, (JETIListener)this);
        }
    }

    public static void init(Backend backend) {
        plugin = new Plugin(backend);
    }

    public void unload() {
        this.playList.stopPlaying();
        this.sounds.clear();
    }

    public static void unload(Backend backend) {
        plugin.unload();
        backend.removeListener(MessageListener.class, (JETIListener)plugin);
        backend.removeListener(PresenceListener.class, (JETIListener)plugin);
        plugin = null;
    }

    public static void reloadSounds() {
        plugin.initSounds();
    }

    private void initSounds() {
        this.sounds = new HashMap(10);
        if (System.getProperty("os.name").equals("OS/2")) {
            this.singleLine = true;
        }
        this.loadSound("message", Preferences.getString((String)NAME, (String)"message", (String)"STEELYEC.WAV"));
        this.loadSound("online", Preferences.getString((String)NAME, (String)"online", (String)"BEEPPURE.WAV"));
        this.loadSound("offline", Preferences.getString((String)NAME, (String)"offline", (String)"WHOOSH.WAV"));
        this.loadSound("own_online", Preferences.getString((String)NAME, (String)"own_online", (String)"BEEPBASS.WAV"));
        this.loadSound("own_offline", Preferences.getString((String)NAME, (String)"own_offline", (String)"BADUMM.WAV"));
        if (this.playList != null) {
            this.playList.stopPlaying();
        }
        this.playList = new PlayList(this.sounds, this.singleLine);
        this.playList.start();
    }

    private void loadSound(String string, String string2) {
        if (!Preferences.getBoolean((String)NAME, (String)(string + ".enabled"), (boolean)true)) {
            return;
        }
        if (this.singleLine) {
            this.loadSoundSingleLine(string, string2);
            return;
        }
        try {
            URL uRL = this.getClass().getResource(string2);
            AudioInputStream audioInputStream = uRL != null ? AudioSystem.getAudioInputStream(new BufferedInputStream(uRL.openStream())) : AudioSystem.getAudioInputStream(new File(string2));
            Line.Info info = new Line.Info(Clip.class);
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInputStream);
            this.sounds.put(string, clip);
        }
        catch (IOException iOException) {
            Popups.errorPopup((String)MessageFormat.format(I18N.gettext((String)"sound.{0}_not_found"), string), (String)I18N.gettext((String)"sound.Sound_not_found"));
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            Popups.errorPopup((String)MessageFormat.format(I18N.gettext((String)"sound.{0}_is_an_unsupported_format"), string), (String)I18N.gettext((String)"sound.Format_not_supported"));
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.err.println(I18N.gettext((String)"sound.Problem_playing_sound_check_your_sound_system"));
        }
    }

    private void loadSoundSingleLine(String string, String string2) {
        try {
            int n;
            URL uRL = this.getClass().getResource(string2);
            AudioInputStream audioInputStream = uRL != null ? AudioSystem.getAudioInputStream(new BufferedInputStream(uRL.openStream())) : AudioSystem.getAudioInputStream(new File(string2));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 1024 * audioInputStream.getFormat().getFrameSize();
            byte[] byArray = new byte[n2];
            while ((n = audioInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.sounds.put(string, new Object[]{audioInputStream.getFormat(), byteArrayOutputStream.toByteArray()});
        }
        catch (IOException iOException) {
            Popups.errorPopup((String)MessageFormat.format(I18N.gettext((String)"sound.{0}_not_found"), string), (String)I18N.gettext((String)"sound.Sound_not_found"));
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            Popups.errorPopup((String)MessageFormat.format(I18N.gettext((String)"sound.{0}_is_an_unsupported_format"), string), (String)I18N.gettext((String)"sound.Format_not_supported"));
        }
    }

    public static void test() {
        Plugin.plugin.playList.addSound("message");
    }

    public void message(Message message) {
        if (!this.timeBlocked(0)) {
            if (message.getType().equals("groupchat") && message.getFrom().getResource() == null) {
                return;
            }
            this.playList.addSound("message");
        }
    }

    public void presenceChanged(Presence presence) {
        if (presence.getShow() == 7) {
            if (!this.timeBlocked(2)) {
                this.playList.addSound("offline");
            }
        } else if (presence.getShow() == 2 && !this.timeBlocked(1)) {
            this.playList.addSound("online");
        }
    }

    public void exit() {
    }

    public void connectionChanged(boolean bl) {
        if (bl) {
            this.playList.addSound("own_online");
        } else {
            this.playList.addSound("own_offline");
        }
    }

    public void ownPresenceChanged(int n, String string) {
    }

    private boolean timeBlocked(int n) {
        long l = System.currentTimeMillis();
        if (l - (long)(Preferences.getInteger((String)NAME, (String)"block", (int)2) * 1000) < this.lastTime[n]) {
            return true;
        }
        this.lastTime[n] = l;
        return false;
    }

    class PlayList
    extends Thread {
        private LinkedList queue = new LinkedList();
        private volatile boolean isRunning = true;
        private Map sounds;
        private boolean singleLine = false;

        public PlayList(Map map, boolean bl) {
            this.sounds = map;
            this.singleLine = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSound(String string) {
            if (this.isRunning) {
                if (!Preferences.getBoolean((String)Plugin.NAME, (String)(string + ".enabled"), (boolean)true)) {
                    return;
                }
                Object v = this.sounds.get(string);
                if (!this.queue.contains(v)) {
                    LinkedList linkedList = this.queue;
                    synchronized (linkedList) {
                        this.queue.addLast(v);
                        this.queue.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopPlaying() {
            this.isRunning = false;
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            Object object;
            Clip clip = null;
            byte[] byArray = null;
            AudioFormat audioFormat = null;
            while (this.isRunning) {
                object = this.queue;
                synchronized (object) {
                    if (this.queue.isEmpty()) {
                        if (this.isRunning) {
                            try {
                                this.queue.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                                return;
                            }
                        }
                        continue;
                    }
                    if (this.singleLine) {
                        Object[] objectArray = (Object[])this.queue.removeFirst();
                        audioFormat = (AudioFormat)objectArray[0];
                        byArray = (byte[])objectArray[1];
                    } else {
                        clip = (Clip)this.queue.removeFirst();
                    }
                }
                if (this.singleLine) {
                    this.playSingleLine(byArray, audioFormat);
                    continue;
                }
                clip.setFramePosition(0);
                if (clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                    object = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                    float f = Preferences.getInteger((String)Plugin.NAME, (String)"volume", (int)0);
                    if (f > ((FloatControl)object).getMaximum()) {
                        f = ((FloatControl)object).getMaximum();
                    }
                    ((FloatControl)object).setValue(f);
                }
                clip.start();
            }
            if (!this.singleLine) {
                object = this.queue.iterator();
                while (object.hasNext()) {
                    ((Clip)object.next()).close();
                }
            }
        }

        private void playSingleLine(byte[] byArray, AudioFormat audioFormat) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, byArray.length / audioFormat.getFrameSize());
            Line.Info info = new Line.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = Plugin.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip);
            Clip clip = null;
            try {
                clip = (Clip)AudioSystem.getLine(info);
                clip.open(audioInputStream);
            }
            catch (LineUnavailableException lineUnavailableException) {
                System.err.println(I18N.gettext((String)"sound.Problem_playing_sound_check_your_sound_system"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                FloatControl floatControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                float f = Preferences.getInteger((String)Plugin.NAME, (String)"volume", (int)0);
                if (f > floatControl.getMaximum()) {
                    f = floatControl.getMaximum();
                }
                floatControl.setValue(f);
            }
            clip.start();
            try {
                PlayList.sleep(clip.getMicrosecondLength() / 1000L);
                clip.stop();
                clip.close();
                clip = null;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

