/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchatalerter;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import nu.fw.jeti.events.ChatEndedListener;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.MessageListener;
import nu.fw.jeti.events.PresenceListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.XDelay;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.plugins.groupchat.GroupchatWindow;
import nu.fw.jeti.plugins.groupchat.Plugin;
import nu.fw.jeti.plugins.groupchat.elements.XMUC;
import nu.fw.jeti.plugins.groupchatalerter.MessagesStore;
import nu.fw.jeti.util.Preferences;

public class Alerter
implements MessageListener,
PresenceListener,
ChatEndedListener {
    private Matcher matcher;
    private Backend backend;
    private JID jid;
    private boolean monitoring;
    private boolean iconofied;
    private MessagesStore messages;
    private HashMap presences;
    private Message subject;
    private GroupchatWindow groupchatWindow;
    private WindowStateListener windowStateListener;
    private boolean pause = false;

    public Alerter(Backend backend, JID jID, String string) {
        this.backend = backend;
        this.messages = new MessagesStore();
        this.presences = new HashMap();
        backend.addListener(ChatEndedListener.class, (JETIListener)this);
        if (jID.getResource() == null) {
            jID = new JID(jID.getUser(), jID.getDomain(), backend.getMyJID().getUser());
        }
        this.jid = jID;
        backend.addMessageListener(jID, (MessageListener)this);
        backend.addPresenceListener(jID, (PresenceListener)this);
        backend.send((Packet)new Presence(jID, 3, Preferences.getString((String)"groupchatalerter", (String)"alerterStatusMessage", (String)"alerter"), (XExtension)new XMUC()));
        if (Plugin.getGroupchatJID((JID)jID) != null) {
            this.groupchatWindow = Plugin.getGroupchat((JID)jID);
            this.monitoring = false;
            this.addWindowStateListener(this.groupchatWindow);
        } else {
            this.monitoring = true;
        }
        this.matcher = Pattern.compile(string, 2).matcher("");
    }

    public JID getJID() {
        return this.jid;
    }

    public synchronized void message(final Message message) {
        if (message.getSubject() != null) {
            this.subject = message;
            if (this.iconofied || !this.monitoring) {
                this.groupchatWindow.appendMessage(this.subject);
            }
        }
        if (message.getBody() == null) {
            return;
        }
        System.out.println("message " + message.getBody());
        if (!this.pause && !this.hasDelay(message) && this.matcher.reset(message.getBody()).find()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Object object;
                    if (Alerter.this.monitoring) {
                        object = Plugin.getGroupchat((JID)Alerter.this.jid);
                        Alerter.this.monitoring = false;
                        if (object == null) {
                            return;
                        }
                        Iterator iterator = Alerter.this.presences.values().iterator();
                        while (iterator.hasNext()) {
                            object.presenceChanged((Presence)iterator.next());
                        }
                        if (Alerter.this.subject != null) {
                            object.appendMessage(Alerter.this.subject);
                        }
                        Alerter.this.messages.releaseMessages((GroupchatWindow)object);
                        Alerter.this.groupchatWindow = (GroupchatWindow)object;
                        Alerter.this.deIconify();
                        Alerter.this.addWindowStateListener((GroupchatWindow)object);
                    } else if (Alerter.this.iconofied) {
                        Alerter.this.deIconify();
                    }
                    object = Alerter.this.backend.getListeners(class$nu$fw$jeti$events$MessageListener == null ? (class$nu$fw$jeti$events$MessageListener = Alerter.class$("nu.fw.jeti.events.MessageListener")) : class$nu$fw$jeti$events$MessageListener);
                    while (object.hasNext()) {
                        ((MessageListener)object.next()).message(message);
                    }
                }
            });
        } else {
            if (this.iconofied) {
                this.groupchatWindow.appendMessage(message);
            } else if (!this.monitoring) {
                Iterator iterator = this.backend.getListeners(MessageListener.class);
                while (iterator.hasNext()) {
                    ((MessageListener)iterator.next()).message(message);
                }
            }
            this.messages.addMessage(message);
        }
    }

    private void deIconify() {
        if (this.groupchatWindow.getTopLevelAncestor() instanceof JFrame) {
            JFrame jFrame = (JFrame)this.groupchatWindow.getTopLevelAncestor();
            if (jFrame.getExtendedState() == 1) {
                jFrame.setState(0);
            }
            jFrame.toFront();
        }
    }

    private boolean hasDelay(Message message) {
        if (message.hasExtensions()) {
            Iterator iterator = message.getExtensions();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof XDelay)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateRule(String string) {
        this.matcher = Pattern.compile(string, 2).matcher("");
    }

    public void disable() {
        this.groupchatWindow = Plugin.getGroupchat((JID)this.jid);
        this.monitoring = false;
        Iterator iterator = this.presences.values().iterator();
        while (iterator.hasNext()) {
            this.groupchatWindow.presenceChanged((Presence)iterator.next());
        }
        if (this.subject != null) {
            this.groupchatWindow.appendMessage(this.subject);
        }
        this.messages.releaseMessages(this.groupchatWindow);
        this.addWindowStateListener(this.groupchatWindow);
    }

    private void addWindowStateListener(GroupchatWindow groupchatWindow) {
        Container container;
        if (Preferences.getBoolean((String)"groupchatalerter", (String)"alerterOnMinimize", (boolean)false) && (container = groupchatWindow.getTopLevelAncestor()) instanceof Window) {
            if (this.windowStateListener == null) {
                this.windowStateListener = new WindowStateListener(){

                    public void windowStateChanged(WindowEvent windowEvent) {
                        if ((windowEvent.getNewState() & 1) != 0) {
                            Alerter.this.iconofied = true;
                            Alerter.this.backend.send((Packet)new Presence(Alerter.this.jid, 3, Preferences.getString((String)"groupchatalerter", (String)"alerterStatusMessage", (String)"alerter"), (XExtension)new XMUC()));
                        } else {
                            Alerter.this.iconofied = false;
                        }
                    }
                };
            }
            ((Window)container).addWindowStateListener(this.windowStateListener);
        }
    }

    public void pause(boolean bl) {
        this.pause = bl;
    }

    public void offline() {
        this.presences.clear();
    }

    public void presenceChanged(Presence presence) {
        if (!this.monitoring) {
            this.groupchatWindow.presenceChanged(presence);
        } else if (presence.getType().equals("error") && !this.monitoring) {
            GroupchatWindow groupchatWindow = Plugin.getGroupchat((JID)this.jid);
            this.monitoring = false;
            groupchatWindow.presenceChanged(presence);
            return;
        }
        if (presence.getShow() == 7) {
            if (presence.getFrom().equals(this.jid) && presence.getFrom().getResource().equals(presence)) {
                this.presences.clear();
            } else {
                this.presences.remove(presence.getFrom().toString());
            }
        } else {
            this.presences.put(presence.getFrom().toString(), presence);
        }
    }

    public void chatEnded(JID jID) {
        if (!this.monitoring && this.jid.equals(jID) && this.jid.getResource().equals(jID.getResource())) {
            this.backend.send((Packet)new Presence(jID, 3, Preferences.getString((String)"groupchatalerter", (String)"alerterStatusMessage", (String)"alerter"), (XExtension)new XMUC()));
            this.monitoring = true;
        }
        this.iconofied = false;
    }

    public void remove() {
        Window window;
        this.backend.removeMessageListener(this.jid);
        this.backend.removePresenceListener(this.jid);
        this.backend.removeListener(ChatEndedListener.class, (JETIListener)this);
        if (this.windowStateListener != null && this.groupchatWindow != null && (window = (Window)this.groupchatWindow.getTopLevelAncestor()) != null) {
            window.removeWindowStateListener(this.windowStateListener);
        }
        this.backend.send((Packet)new Presence(this.jid, "unavailable"));
    }
}

