/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.alertwindow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.MessageListener;
import nu.fw.jeti.events.PresenceListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.plugins.NativeUtils;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class Plugin
extends Window
implements PresenceListener,
MessageListener,
Plugins {
    public static final String VERSION = "2.0";
    public static final String DESCRIPTION = "alertwindow.Shows_an_alert_window_when_a_message_arrives";
    public static final String MIN_JETI_VERSION = "0.5.3";
    public static final String NAME = "alertwindow";
    public static final String ABOUT = "by E.S. de Boer";
    public static final String PARENT = "Notifiers";
    private Label lblName;
    private Label label;
    private Timer timer = new Timer(true);
    private TimerTask tt;
    private int time;
    private static Plugin plugin;
    private NativeUtils util;
    private Point pntLowerRight;
    private int alpha;
    private Window owner;
    public static boolean supportsAlpha;

    public Plugin(Window window) {
        super(window);
        this.owner = window;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.setBackground(Color.BLACK);
        this.lblName = new Label();
        this.lblName.setFont((Font)UIManager.get("TextArea.font"));
        this.add((Component)this.lblName, gridBagConstraints);
        this.label = new Label();
        this.label.setFont((Font)UIManager.get("TextArea.font"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.add((Component)this.label, gridBagConstraints);
        this.enableInputMethods(false);
        this.setSize(1, 1);
        this.setVisible(true);
        this.setFocusableWindowState(false);
        this.setFocusable(false);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        this.pntLowerRight = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public static void init(Backend backend) {
        plugin = new Plugin((Window)new Frame());
        backend.addListener(MessageListener.class, (JETIListener)plugin);
        backend.addListener(PresenceListener.class, (JETIListener)plugin);
        Color color = new Color(Preferences.getInteger((String)NAME, (String)"backgroundcolor", (int)SystemColor.info.getRGB()));
        Plugin.plugin.label.setBackground(color);
        Plugin.plugin.lblName.setBackground(color);
        Color color2 = new Color(Preferences.getInteger((String)NAME, (String)"foregroundcolor", (int)SystemColor.controlText.getRGB()));
        Plugin.plugin.label.setForeground(color2);
        Plugin.plugin.lblName.setForeground(color2);
        Plugin.plugin.time = Preferences.getInteger((String)NAME, (String)"popuptime", (int)5) * 1000;
    }

    private void loadWindowsUtils() {
        if (this.util == null) {
            if (PluginsInfo.isPluginLoaded((String)"windowsutils")) {
                this.util = (NativeUtils)PluginsInfo.newPluginInstance((String)"windowsutils");
                supportsAlpha = this.util.supportsAlpha();
                if (this.util != null) {
                    try {
                        if (System.getProperty("java.version").indexOf("1.5") == -1) {
                            this.util.windowAlwaysOnTop((Component)plugin, true);
                        }
                        if (supportsAlpha) {
                            this.alpha = Preferences.getInteger((String)NAME, (String)"alpha", (int)100);
                            if (this.alpha < 100) {
                                this.util.setWindowAlpha((Component)plugin, this.alpha);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        } else if (System.getProperty("os.name").equals("OS/2")) {
            this.util.windowAlwaysOnTop((Component)plugin, true);
        }
    }

    public void unload() {
        if (this.util != null) {
            try {
                if (this.util.supportsAlpha()) {
                    this.util.setWindowAlpha((Component)this, 0);
                }
                this.util.windowAlwaysOnTop((Component)this, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dispose();
        this.owner.dispose();
    }

    public static void unload(Backend backend) {
        backend.removeListener(MessageListener.class, (JETIListener)plugin);
        backend.removeListener(PresenceListener.class, (JETIListener)plugin);
        plugin.unload();
        plugin = null;
    }

    public void presenceChanged(final Presence presence) {
        this.loadWindowsUtils();
        Runnable runnable = new Runnable(){

            public void run() {
                Plugin.this.lblName.setText(Plugin.this.getNick(presence.getFrom()));
                String string = presence.getStatus();
                if (string == null) {
                    string = Presence.toLongShow((int)presence.getShow());
                }
                Plugin.this.label.setText(string);
                Plugin.this.place();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void message(final Message message) {
        this.loadWindowsUtils();
        Runnable runnable = new Runnable(){

            public void run() {
                JID jID = message.getFrom();
                String string = message.getType().equals("groupchat") ? jID.getResource() : Plugin.this.getNick(jID);
                Plugin.this.lblName.setText(string);
                Plugin.this.label.setText(message.getBody());
                Plugin.this.place();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private String getNick(JID jID) {
        String string = jID.getUser();
        JIDStatus jIDStatus = Backend.getJIDStatus((JID)jID);
        if (jIDStatus != null) {
            string = jIDStatus.getNick();
        }
        return string;
    }

    public void demo(Color color, Color color2, final int n, final int n2) {
        this.time = n2 * 1000;
        this.label.setBackground(color);
        this.lblName.setBackground(color);
        this.label.setForeground(color2);
        this.lblName.setForeground(color2);
        Plugin.plugin.time = this.time;
        Plugin.plugin.label.setBackground(color);
        Plugin.plugin.lblName.setBackground(color);
        Plugin.plugin.label.setForeground(color2);
        Plugin.plugin.lblName.setForeground(color2);
        Plugin.plugin.alpha = n;
        this.loadWindowsUtils();
        if (this.util != null && supportsAlpha) {
            try {
                this.util.setWindowAlpha((Component)this, n);
                this.util.setWindowAlpha((Component)plugin, n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Plugin.this.lblName.setText(I18N.gettext((String)"alertwindow.This_is_a_Demonstration_PopupWindow"));
                Plugin.this.label.setText(MessageFormat.format(I18N.gettext((String)"alertwindow.Alpha_is_{0},_Time_is_{1}"), String.valueOf(n), String.valueOf(n2)));
                Plugin.this.place();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void place() {
        if (this.tt != null) {
            this.tt.cancel();
        }
        this.tt = new TimerTask(){

            public void run() {
                Plugin.this.setSize(1, 1);
                Plugin.this.setLocation(Plugin.this.pntLowerRight);
                if (Plugin.this.util != null && supportsAlpha && Plugin.this.alpha < 100) {
                    try {
                        Plugin.this.util.setWindowAlpha((Component)Plugin.this, 100);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        };
        this.pack();
        this.setLocation(this.pntLowerRight.x - this.getWidth(), this.pntLowerRight.y - this.getHeight());
        this.timer.schedule(this.tt, this.time);
        if (this.util != null && supportsAlpha && this.alpha < 100) {
            try {
                this.util.setWindowAlpha((Component)this, this.alpha);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (System.getProperty("java.version").indexOf("1.5") != -1) {
            this.setAlwaysOnTop(true);
        }
    }
}

