/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.alertwindow;

import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.plugins.alertwindow.Plugin;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class PrefPanel
extends PreferencesPanel {
    private JTextField txtPopupTime;
    private JSlider slider;
    private JButton btnColor;
    private JButton btnForegroundColor;
    private JButton btnDemo;
    private Color color;
    private Color foregroundColor;

    public PrefPanel(Backend backend) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridwidth = 1;
        this.txtPopupTime = new JTextField(Preferences.getString((String)"alertwindow", (String)"popuptime", (String)"4"));
        this.add(new JLabel(I18N.gettext((String)"alertwindow.Time_to_show_alert")), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        this.add(this.txtPopupTime, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.add(new JLabel(I18N.gettext((String)"alertwindow.sec")), gridBagConstraints);
        this.slider = new JSlider(5, 100, Preferences.getInteger((String)"alertwindow", (String)"alpha", (int)100));
        gridBagConstraints.anchor = 24;
        if (Plugin.supportsAlpha) {
            this.slider.setMajorTickSpacing(10);
            this.slider.setMinorTickSpacing(1);
            this.slider.setPaintTicks(true);
            this.slider.setPaintLabels(true);
            this.slider.setLabelTable(this.slider.createStandardLabels(10, 10));
            gridBagConstraints.gridwidth = 1;
            this.add(new JLabel(I18N.gettext((String)"alertwindow.Transparancy,_100%_is_opaque")), gridBagConstraints);
            this.add(this.slider, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            this.add(new JLabel("%"), gridBagConstraints);
        }
        this.foregroundColor = new Color(Preferences.getInteger((String)"alertwindow", (String)"foregroundcolor", (int)SystemColor.controlText.getRGB()));
        this.btnForegroundColor = new JButton(I18N.gettext((String)"alertwindow.Foreground_color"));
        this.btnForegroundColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(PrefPanel.this.getTopLevelAncestor(), I18N.gettext((String)"alertwindow.Color"), PrefPanel.this.color);
                if (color != null) {
                    PrefPanel.this.foregroundColor = color;
                    PrefPanel.this.btnForegroundColor.setForeground(PrefPanel.this.foregroundColor);
                }
            }
        });
        this.btnForegroundColor.setForeground(this.foregroundColor);
        this.add(this.btnForegroundColor, gridBagConstraints);
        this.color = new Color(Preferences.getInteger((String)"alertwindow", (String)"backgroundcolor", (int)SystemColor.info.getRGB()));
        this.btnColor = new JButton(I18N.gettext((String)"alertwindow.Background_color"));
        this.btnColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(PrefPanel.this.getTopLevelAncestor(), I18N.gettext((String)"alertwindow.Color"), PrefPanel.this.color);
                if (color != null) {
                    PrefPanel.this.color = color;
                    PrefPanel.this.btnColor.setBackground(PrefPanel.this.color);
                }
            }
        });
        this.btnColor.setBackground(this.color);
        this.add(this.btnColor, gridBagConstraints);
        this.btnDemo = new JButton(I18N.gettext((String)"alertwindow.Demonstration"));
        this.btnDemo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!PrefPanel.this.txtPopupTime.getText().equals("")) {
                    try {
                        int n = Integer.parseInt(PrefPanel.this.txtPopupTime.getText());
                        if (n < 1) {
                            n = 1;
                        }
                        if (n > 3600) {
                            n = 3600;
                        }
                        Plugin plugin = new Plugin((Window)new Frame());
                        plugin.demo(PrefPanel.this.color, PrefPanel.this.foregroundColor, PrefPanel.this.slider.getValue(), n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        this.add(this.btnDemo, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    public void savePreferences() {
        if (!this.txtPopupTime.getText().equals("")) {
            try {
                int n = Integer.parseInt(this.txtPopupTime.getText());
                if (n < 1) {
                    n = 1;
                }
                if (n > 3600) {
                    n = 3600;
                }
                Preferences.putInteger((String)"alertwindow", (String)"popuptime", (int)n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Preferences.putInteger((String)"alertwindow", (String)"alpha", (int)this.slider.getValue());
        Preferences.putInteger((String)"alertwindow", (String)"backgroundcolor", (int)this.color.getRGB());
        Preferences.putInteger((String)"alertwindow", (String)"foregroundcolor", (int)this.foregroundColor.getRGB());
    }
}

