/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.vcard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.util.Base64;
import nu.fw.jeti.util.I18N;

public class VCardDisplay
extends JFrame {
    private Map personal;
    private Map business;
    private List homeTels;
    private List workTels;
    private String name;

    public VCardDisplay(Map map, Map map2, List list, List list2, String string) {
        this.personal = map;
        this.business = map2;
        this.homeTels = list;
        this.workTels = list2;
        this.name = string;
        this.init();
    }

    public void init() {
        String string = I18N.gettext((String)"vcard.Details_for_{0}");
        this.setTitle(MessageFormat.format(string, this.name));
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        if (this.business.size() > 0) {
            JTabbedPane jTabbedPane = new JTabbedPane();
            jTabbedPane.addTab(I18N.gettext((String)"vcard.Personal"), this.createPersonalPanel());
            jTabbedPane.addTab(I18N.gettext((String)"vcard.Business"), this.createBusinessPanel());
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(jTabbedPane);
        } else {
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(this.createPersonalPanel());
        }
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private JPanel createPersonalPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        String[] stringArray = (String[])this.personal.get("PHOTO");
        if (stringArray != null) {
            try {
                byte[] byArray = Base64.decode((String)stringArray[1]);
                gridBagConstraints.gridwidth = 0;
                jPanel.add((Component)new JLabel(new ImageIcon(byArray)), gridBagConstraints);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.addLine("FN", this.personal, jPanel, gridBagConstraints);
        this.addLine("GIVEN", this.personal, jPanel, gridBagConstraints);
        this.addLine("MIDDLE", this.personal, jPanel, gridBagConstraints);
        this.addLine("FAMILY", this.personal, jPanel, gridBagConstraints);
        this.addLine("NICKNAME", this.personal, jPanel, gridBagConstraints);
        this.addLine("BDAY", this.personal, jPanel, gridBagConstraints);
        this.addAdress(this.personal, jPanel, gridBagConstraints);
        if (this.homeTels != null) {
            this.addTel(this.homeTels, jPanel, gridBagConstraints);
        }
        this.addLine("JABBERID", this.personal, jPanel, gridBagConstraints);
        this.addLine("EMAIL", this.personal, jPanel, gridBagConstraints);
        this.addLine("URL", this.personal, jPanel, gridBagConstraints);
        this.addLine("DESC", this.personal, jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        return jPanel;
    }

    private JPanel createBusinessPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        String[] stringArray = (String[])this.business.get("LOGO");
        if (stringArray != null) {
            try {
                byte[] byArray = Base64.decode((String)stringArray[1]);
                gridBagConstraints.gridwidth = 0;
                jPanel.add((Component)new JLabel(new ImageIcon(byArray)), gridBagConstraints);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.workTels != null) {
            this.addTel(this.workTels, jPanel, gridBagConstraints);
        }
        this.addLine("TITLE", this.business, jPanel, gridBagConstraints);
        this.addLine("ROLE", this.business, jPanel, gridBagConstraints);
        this.addLine("ORGNAME", this.business, jPanel, gridBagConstraints);
        this.addLine("ORGUNIT", this.business, jPanel, gridBagConstraints);
        this.addLine("EMAIL", this.business, jPanel, gridBagConstraints);
        this.addAdress(this.business, jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        return jPanel;
    }

    private void addAdress(Map map, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addLine("POBOX", map, jPanel, gridBagConstraints);
        this.addLine("STREET", map, jPanel, gridBagConstraints);
        this.addLine("EXTADR", map, jPanel, gridBagConstraints);
        this.addLine("LOCALITY", map, jPanel, gridBagConstraints);
        this.addLine("REGION", map, jPanel, gridBagConstraints);
        this.addLine("PCODE", map, jPanel, gridBagConstraints);
        this.addLine("CTRY", map, jPanel, gridBagConstraints);
    }

    private void addTel(List list, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            if (stringArray[0] == null) continue;
            this.addLine(stringArray[1], stringArray[0], jPanel, gridBagConstraints);
        }
    }

    private void addLine(String string, Map map, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        String string2 = (String)map.get(string);
        if (string2 != null) {
            this.addLine(string, string2, jPanel, gridBagConstraints);
        }
    }

    private void addLine(String string, String string2, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridwidth = 1;
        string = I18N.gettext((String)("vcard." + string));
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        JTextField jTextField = new JTextField(string2);
        jTextField.setEditable(false);
        jPanel.add((Component)jTextField, gridBagConstraints);
    }
}

