/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import nu.fw.jeti.backend.ConnectionPacketReceiver;
import nu.fw.jeti.backend.Discovery;
import nu.fw.jeti.backend.Handlers;
import nu.fw.jeti.backend.IQTimerQueue;
import nu.fw.jeti.backend.Input;
import nu.fw.jeti.backend.Jabber;
import nu.fw.jeti.backend.JabberHandler;
import nu.fw.jeti.backend.LoginInfo;
import nu.fw.jeti.backend.Output;
import nu.fw.jeti.events.DiscoveryListener;
import nu.fw.jeti.events.LoginListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.DiscoveryInfo;
import nu.fw.jeti.jabber.elements.DiscoveryItem;
import nu.fw.jeti.jabber.elements.IQAuth;
import nu.fw.jeti.jabber.elements.IQAuthBuilder;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.IQPrivate;
import nu.fw.jeti.jabber.elements.IQXRoster;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.JetiPrivateExtension;
import nu.fw.jeti.jabber.elements.JetiPrivateRosterExtension;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.plugins.Avatars;
import nu.fw.jeti.plugins.OpenPGP;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.ui.LoginStatusWindow;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Log;
import nu.fw.jeti.util.Utils;

public class Connect
implements ConnectionPacketReceiver {
    private Output output;
    private String authenticationId = "yytr";
    private JabberHandler jabberHandler;
    private LoginInfo loginInfo;
    private Backend backend;
    private Handlers handlers;
    private static JID myJID = new JID("test", "test", "test");
    private boolean authenticated = false;
    private boolean reconnecting = false;
    private int show;
    private String status;
    private String connectionID;
    private Discovery browse;
    private Socket socket;
    private Thread connectThread;
    private volatile boolean abort = false;
    private OpenPGP openPGP;
    private IQTimerQueue iqTimerQueue;
    private LoginStatusWindow loginStatusWindow;
    private Avatars avatars;

    public Connect(Backend backend, IQTimerQueue iQTimerQueue) {
        this.backend = backend;
        this.iqTimerQueue = iQTimerQueue;
        this.handlers = new Handlers();
        this.browse = new Discovery(backend);
    }

    public Handlers getHandlers() {
        return this.handlers;
    }

    public void setJabberHandler(JabberHandler jabberHandler) {
        this.jabberHandler = jabberHandler;
    }

    public void getItems(JID jID, DiscoveryListener discoveryListener, boolean bl) {
        this.browse.getItems(jID, discoveryListener, bl);
    }

    public void getItems(JID jID, DiscoveryListener discoveryListener) {
        this.browse.getItems(jID, discoveryListener);
    }

    public void getInfo(JID jID, DiscoveryListener discoveryListener) {
        this.browse.getInfo(jID, discoveryListener);
    }

    public void getItems(JID jID, String string, DiscoveryListener discoveryListener) {
        this.browse.getItems(jID, string, discoveryListener);
    }

    public void getInfo(JID jID, String string, DiscoveryListener discoveryListener) {
        this.browse.getInfo(jID, string, discoveryListener);
    }

    public boolean isLoggedIn() {
        return this.authenticated;
    }

    public boolean isPasswordValid(String string) {
        return this.loginInfo.getPassword().equals(string);
    }

    private void reconnect() {
        if (this.loginStatusWindow != null) {
            this.loginStatusWindow.abort();
        }
        this.loginStatusWindow = new LoginStatusWindow(this.loginInfo, this.backend, 2);
    }

    public void login(LoginInfo loginInfo) {
        if (PluginsInfo.isPluginLoaded("openpgp")) {
            this.openPGP = this.openPGP = (OpenPGP)PluginsInfo.getPluginInstance("openpgp");
        }
        this.abort = false;
        this.loginInfo = loginInfo;
        this.connectThread = new Thread(){

            public void run() {
                Connect.this.connect();
            }
        };
        this.connectThread.start();
    }

    public void autoLogin(LoginInfo loginInfo, final int n) {
        this.abort = false;
        this.loginInfo = loginInfo;
        this.connectThread = new Thread(){
            int tel = 0;

            public void run() {
                boolean bl = false;
                while (this.tel < n && !(bl = Connect.this.connect())) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++this.tel;
                }
                if (!bl) {
                    Connect.this.sendLoginMessage("login failed, tried " + n + " times, stopping");
                }
            }
        };
        this.connectThread.start();
    }

    public void abort() {
        this.abort = true;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.connectThread.interrupt();
        this.disconnect();
    }

    private synchronized boolean connect() {
        if (this.loginInfo == null) {
            return true;
        }
        if (this.authenticated) {
            this.disconnect();
        }
        if (this.loginInfo.useProxy()) {
            System.getProperties().setProperty("socksProxyHost", this.loginInfo.getProxyServer());
            System.getProperties().setProperty("socksProxyPort", this.loginInfo.getProxyPort());
            System.getProperties().setProperty("socksProxyUserName", this.loginInfo.getProxyUsername());
            if (this.loginInfo.getProxyPassword() != null) {
                System.getProperties().setProperty("socksProxyPassword", this.loginInfo.getProxyPassword());
            }
        }
        this.sendLoginStatus(0);
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Opening_socket") + "...");
        try {
            String string = this.loginInfo.getHost();
            if (string == null || string.length() == 0) {
                string = this.loginInfo.getServer();
            }
            this.socket = this.loginInfo.isSSl() ? new DummySSLSocketFactory().createSocket(string, this.loginInfo.getPort()) : new Socket(string, this.loginInfo.getPort());
        }
        catch (UnknownHostException unknownHostException) {
            this.sendLoginError(MessageFormat.format(I18N.gettext("main.loginstatus.Server_{0}_could_not_be_found"), this.loginInfo.getHost()));
            return false;
        }
        catch (IOException iOException) {
            this.sendLoginError(iOException.getMessage());
            return false;
        }
        if (this.abort) {
            return false;
        }
        this.sendLoginStatus(1);
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Opening_Input") + "...");
        try {
            new Input(this.socket.getInputStream(), this);
        }
        catch (IOException iOException) {
            this.sendLoginError(I18N.gettext("main.loginstatus.Could_not_open_input_because") + " " + iOException.getMessage());
            return false;
        }
        if (this.abort) {
            return false;
        }
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Opening_Output") + "...");
        try {
            this.output = new Output(this.socket, this.loginInfo.getServer(), this);
        }
        catch (IOException iOException) {
            this.sendLoginError(I18N.gettext("main.loginstatus.Could_not_open_output_because") + " " + iOException.getMessage());
            return false;
        }
        this.sendLoginStatus(2);
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Connected") + "...");
        this.socket = null;
        return true;
    }

    private void sendLoginMessage(String string) {
        Iterator iterator = this.backend.getListeners(LoginListener.class);
        while (iterator.hasNext()) {
            ((LoginListener)iterator.next()).loginMessage(string);
        }
    }

    private void sendLoginStatus(int n) {
        Iterator iterator = this.backend.getListeners(LoginListener.class);
        while (iterator.hasNext()) {
            ((LoginListener)iterator.next()).loginStatus(n);
        }
    }

    private void sendLoginError(String string) {
        Iterator iterator = this.backend.getListeners(LoginListener.class);
        while (iterator.hasNext()) {
            ((LoginListener)iterator.next()).loginError(string);
        }
    }

    private void sendUnauthorized() {
        Iterator iterator = this.backend.getListeners(LoginListener.class);
        while (iterator.hasNext()) {
            ((LoginListener)iterator.next()).unauthorized();
        }
    }

    public synchronized void connected(String string) {
        if (!this.abort) {
            this.sendLoginStatus(3);
            this.connectionID = string;
            this.output.send(new InfoQuery(null, "get", new IQAuth(this.loginInfo.getUsername().toLowerCase(), null, null)));
            this.sendLoginMessage(I18N.gettext("main.loginstatus.Getting_available_login_methods") + "...");
        }
    }

    public void authenticate(IQAuth iQAuth) {
        if (!this.abort) {
            this.sendLoginStatus(4);
            this.sendLoginMessage(I18N.gettext("main.loginstatus.Authenticating") + "...");
            this.authenticationId = "Jeti_Auth_" + new Date().getTime();
            if (iQAuth.hasDigest()) {
                MessageDigest messageDigest = null;
                try {
                    messageDigest = MessageDigest.getInstance("SHA");
                }
                catch (Exception exception) {
                    Log.error(I18N.gettext("main.loginstatus.Could_not_login_with_SHA"));
                    this.output.send(new InfoQuery(null, "set", this.authenticationId, new IQAuth(this.loginInfo.getUsername().toLowerCase(), this.loginInfo.getPassword(), this.loginInfo.getResource())));
                    return;
                }
                messageDigest.update(this.connectionID.getBytes());
                String string = Utils.toString(messageDigest.digest(this.loginInfo.getPassword().getBytes()));
                IQAuthBuilder iQAuthBuilder = new IQAuthBuilder();
                iQAuthBuilder.digest = string;
                iQAuthBuilder.username = this.loginInfo.getUsername().toLowerCase();
                iQAuthBuilder.resource = this.loginInfo.getResource();
                this.output.send(new InfoQuery(null, "set", this.authenticationId, (IQExtension)((Object)iQAuthBuilder.build())));
            } else {
                this.output.send(new InfoQuery(null, "set", this.authenticationId, new IQAuth(this.loginInfo.getUsername().toLowerCase(), this.loginInfo.getPassword(), this.loginInfo.getResource())));
            }
        }
    }

    public void authenticated(InfoQuery infoQuery) {
        if (!this.abort) {
            this.sendLoginMessage(I18N.gettext("main.loginstatus.Authenticated") + "...");
            if (infoQuery.getType().equals("error")) {
                if (infoQuery.getErrorCode() == 401) {
                    this.sendUnauthorized();
                } else {
                    this.sendLoginError(I18N.gettext("main.loginstatus.Not_logged_in_because_") + " " + infoQuery.getErrorDescription());
                }
                return;
            }
            this.iqTimerQueue.clear();
            this.jabberHandler.changePacketReceiver(new Jabber(this.backend, this.browse, this.iqTimerQueue));
            myJID = new JID(this.loginInfo.getUsername().toLowerCase(), this.loginInfo.getServer(), this.loginInfo.getResource());
            this.authenticated = true;
            this.reconnecting = false;
            this.output.setAuthenticated();
            this.sendLoginMessage(I18N.gettext("main.loginstatus.Loading_roster") + "...");
            this.getItems(new JID(this.loginInfo.getServer()), new DiscoveryListener(){

                public void discoveryItemResult(JID jID, DiscoveryItem discoveryItem) {
                    if (discoveryItem.hasItems()) {
                        Iterator iterator = discoveryItem.getItems();
                        while (iterator.hasNext()) {
                            DiscoveryItem discoveryItem2 = (DiscoveryItem)iterator.next();
                            Connect.this.backend.getInfo(discoveryItem2.getJID(), null);
                        }
                    }
                }

                public void discoveryInfoResult(JID jID, DiscoveryInfo discoveryInfo) {
                }
            });
            this.output.send(new InfoQuery("get", new IQPrivate(new JetiPrivateExtension())));
            this.output.send(new InfoQuery("get", new IQXRoster()));
            if (this.show == 0) {
                this.show = 2;
                this.status = Presence.toLongShow(this.show);
            }
        }
    }

    public void connected() {
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Logged_in"));
        this.sendStatus();
        Avatars avatars = this.getAvatarInterface();
        if (avatars != null) {
            avatars.getVCard(this);
        }
        this.send(new InfoQuery("get", new IQPrivate(new JetiPrivateRosterExtension())));
        Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
        while (iterator.hasNext()) {
            ((StatusChangeListener)iterator.next()).connectionChanged(true);
        }
        this.sendLoginStatus(5);
    }

    public void receivePackets(Packet packet) {
        IQExtension iQExtension;
        if (this.authenticationId.equals(packet.getID())) {
            this.authenticated((InfoQuery)packet);
        } else if (packet instanceof InfoQuery && (iQExtension = packet.getIQExtension()) instanceof IQAuth) {
            this.authenticate((IQAuth)iQExtension);
        }
    }

    public void inputDeath() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.authenticated || this.reconnecting) {
            this.authenticated = false;
            if (this.reconnecting) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.reconnecting = true;
            this.output.disconnect();
            Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
            while (iterator.hasNext()) {
                ((StatusChangeListener)iterator.next()).connectionChanged(false);
            }
            this.reconnect();
        }
        this.sendLoginError(I18N.gettext("main.loginstatus.Lost_Input"));
    }

    public void streamError() {
        if (this.authenticated) {
            this.authenticated = false;
            this.output.disconnect();
            Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
            while (iterator.hasNext()) {
                ((StatusChangeListener)iterator.next()).connectionChanged(false);
            }
        }
        this.sendLoginError(I18N.gettext("main.loginstatus.XML_stream_error,_lost_input"));
    }

    public void outputDeath() {
        this.authenticated = false;
        Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
        while (iterator.hasNext()) {
            ((StatusChangeListener)iterator.next()).connectionChanged(false);
        }
        this.reconnect();
    }

    public static JID getMyJID() {
        return myJID;
    }

    public boolean getOnline() {
        return this.authenticated;
    }

    public void disconnect() {
        if (this.authenticated) {
            this.send(new Presence(myJID, "unavailable"));
            this.authenticated = false;
            this.output.disconnect();
        }
        this.output = null;
        Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
        while (iterator.hasNext()) {
            ((StatusChangeListener)iterator.next()).connectionChanged(false);
        }
    }

    public void exit() {
        if (this.authenticated) {
            this.send(new Presence(myJID, "unavailable"));
            this.authenticated = false;
            this.output.disconnect();
        }
        this.output = null;
        Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
        while (iterator.hasNext()) {
            ((StatusChangeListener)iterator.next()).exit();
        }
    }

    public void send(Packet packet) {
        if (this.authenticated) {
            this.output.send(packet);
        } else {
            Log.notSend(packet.toString());
        }
    }

    public String getAccountInfo() {
        return MessageFormat.format(I18N.gettext("main.popup.logged_in_as_{0}_on_server_{1}_with_resource_{2}"), this.loginInfo.getUsername(), this.loginInfo.getServer(), this.loginInfo.getResource());
    }

    public void sendStatus() {
        if (!this.authenticated) {
            if (this.loginInfo == null) {
                return;
            }
            new LoginStatusWindow(this.loginInfo, this.backend, 1);
        } else {
            Avatars avatars;
            Presence presence = null;
            if (this.show != 7 && this.openPGP != null) {
                presence = this.openPGP.signPresence(this.show, this.status, this.loginInfo.getPriority());
            }
            if ((avatars = this.getAvatarInterface()) != null) {
                presence = avatars.addHash(this.show, this.status, this.loginInfo.getPriority());
            }
            if (presence == null) {
                presence = new Presence(this.show, this.status, this.loginInfo.getPriority(), null);
            }
            this.send(presence);
            Iterator iterator = this.backend.getListeners(StatusChangeListener.class);
            while (iterator.hasNext()) {
                ((StatusChangeListener)iterator.next()).ownPresenceChanged(this.show, this.status);
            }
        }
        this.sendLoginMessage(I18N.gettext("main.loginstatus.Logged_in"));
        this.sendLoginStatus(5);
    }

    private Avatars getAvatarInterface() {
        if (this.avatars != null) {
            return this.avatars;
        }
        if (PluginsInfo.isPluginLoaded("ichatavatars")) {
            this.avatars = (Avatars)PluginsInfo.getPluginInstance("ichatavatars");
            return this.avatars;
        }
        return null;
    }

    public void changeStatus(int n, String string) {
        this.show = n;
        this.status = string;
        this.sendStatus();
    }

    private static class DummyTrustManager
    implements X509TrustManager {
        private DummyTrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            try {
                x509CertificateArray[0].checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                // empty catch block
            }
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class DummySSLSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory factory;

        public DummySSLSocketFactory() {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, new TrustManager[]{new DummyTrustManager()}, new SecureRandom());
                this.factory = sSLContext.getSocketFactory();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
            catch (KeyManagementException keyManagementException) {
                keyManagementException.printStackTrace();
            }
        }

        public static SocketFactory getDefault() {
            return new DummySSLSocketFactory();
        }

        public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
            return this.factory.createSocket(socket, string, n, bl);
        }

        public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
            return this.factory.createSocket(inetAddress, n, inetAddress2, n2);
        }

        public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
            return this.factory.createSocket(inetAddress, n);
        }

        public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
            return this.factory.createSocket(string, n, inetAddress, n2);
        }

        public Socket createSocket(String string, int n) throws IOException {
            return this.factory.createSocket(string, n);
        }

        public String[] getDefaultCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }

        public String[] getSupportedCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }
    }
}

