/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nu.fw.jeti.backend.ConnectionPacketReceiver;
import nu.fw.jeti.backend.JabberHandler;
import nu.fw.jeti.backend.PacketReceiver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Input
extends Thread {
    private InputSource in;
    private PacketReceiver backend;

    public Input(InputStream inputStream, PacketReceiver packetReceiver) {
        try {
            this.in = new InputSource(new InputStreamReader(inputStream, "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.backend = packetReceiver;
        this.start();
    }

    public void run() {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            JabberHandler jabberHandler = new JabberHandler(this.backend);
            ((ConnectionPacketReceiver)this.backend).setJabberHandler(jabberHandler);
            sAXParser.parse(this.in, (DefaultHandler)jabberHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXParseException sAXParseException) {
            Exception exception = sAXParseException.getException();
            if (exception != null) {
                exception.printStackTrace();
                return;
            }
            System.out.println(sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception != null) {
                exception.printStackTrace();
                return;
            }
            System.out.println(sAXException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        this.backend.inputDeath();
    }
}

