/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.util.LinkedList;
import nu.fw.jeti.backend.ConnectionPacketReceiver;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.util.Log;

public class Output
extends Thread {
    private Writer out;
    private LinkedList queue = new LinkedList();
    private volatile boolean isRunning = true;
    private Socket socket;
    public static final int KEEP_ALIVE = 60000;
    private KeepAlivePacket keepAlivePacket = new KeepAlivePacket();
    private ConnectionPacketReceiver backend;
    private volatile boolean authenticated = false;

    public Output(Socket socket, String string, ConnectionPacketReceiver connectionPacketReceiver) throws IOException {
        this.socket = socket;
        this.backend = connectionPacketReceiver;
        try {
            this.out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.out.write("<?xml version='1.0' encoding='UTF-8'?><stream:stream xmlns:stream='http://etherx.jabber.org/streams' ");
        this.out.write("xmlns='jabber:client' ");
        this.out.write("to='");
        this.out.write(string);
        this.out.write("'>");
        this.out.flush();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Packet packet) {
        if (this.isRunning) {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.addLast(packet);
                this.queue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.isRunning = false;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.notifyAll();
        }
    }

    public void setAuthenticated() {
        this.authenticated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        while (this.isRunning || !this.queue.isEmpty()) {
            Packet packet;
            Object object = this.queue;
            synchronized (object) {
                if (this.queue.isEmpty()) {
                    if (this.isRunning) {
                        try {
                            this.queue.wait(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            return;
                        }
                        if (this.authenticated && this.queue.isEmpty()) {
                            this.queue.add(this.keepAlivePacket);
                        }
                    }
                    continue;
                }
                packet = (Packet)this.queue.removeFirst();
            }
            object = packet.toString();
            try {
                Log.sendXML((String)object);
                this.out.write((String)object);
                this.out.flush();
            }
            catch (IOException iOException) {
                if (!this.socket.isClosed()) {
                    Log.notSend((String)object);
                    if (this.isRunning) {
                        this.backend.outputDeath();
                    }
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        if (!this.socket.isClosed()) {
            try {
                this.out.write("</stream:stream>");
                this.out.flush();
                this.socket.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class KeepAlivePacket
    extends Packet {
        KeepAlivePacket() {
        }

        public void appendToXML(StringBuffer stringBuffer) {
            stringBuffer.append(' ');
        }
    }
}

