/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend.roster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nu.fw.jeti.backend.roster.PrimaryJIDStatus;
import nu.fw.jeti.jabber.JIDStatus;

public class JIDStatusGroup
implements Comparable {
    private String name;
    private List members;
    private int onlines;

    public JIDStatusGroup(String string) {
        this.name = string;
        this.members = new ArrayList(16);
    }

    public synchronized int size() {
        return this.members.size();
    }

    public boolean isOffline() {
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            if (!((JIDStatus)iterator.next()).isOnline()) continue;
            return false;
        }
        return true;
    }

    public synchronized void addOnline() {
        ++this.onlines;
    }

    public synchronized void removeOnline() {
        --this.onlines;
    }

    public synchronized int getOnlines() {
        return this.onlines;
    }

    public Iterator iterator() {
        return new ArrayList(this.members).iterator();
    }

    public synchronized void addPrimaryJIDStatus(PrimaryJIDStatus primaryJIDStatus) {
        this.members.add(primaryJIDStatus);
        Collections.sort(this.members);
    }

    public synchronized Object getPrimaryJIDStatus(int n) {
        return this.members.get(n);
    }

    public synchronized PrimaryJIDStatus searchPrimaryJIDStatus(String string) {
        for (int i = 0; i < this.members.size(); ++i) {
            PrimaryJIDStatus primaryJIDStatus = (PrimaryJIDStatus)this.members.get(i);
            if (!primaryJIDStatus.getNick().equals(string)) continue;
            return primaryJIDStatus;
        }
        return null;
    }

    public synchronized void removePrimaryJIDStatus(PrimaryJIDStatus primaryJIDStatus) {
        this.members.remove(primaryJIDStatus);
    }

    public synchronized int indexOfPrimaryJIDStatus(Object object) {
        return this.members.indexOf(object);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JIDStatusGroup)) {
            return false;
        }
        return this.name.equals(((JIDStatusGroup)object).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int compareTo(Object object) {
        return this.name.compareTo(((JIDStatusGroup)object).name);
    }
}

