/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend.roster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import nu.fw.jeti.backend.Connect;
import nu.fw.jeti.backend.roster.ResourceJIDStatus;
import nu.fw.jeti.backend.roster.Roster;
import nu.fw.jeti.backend.roster.SecondaryJIDStatus;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.RosterItem;
import nu.fw.jeti.util.I18N;

public class NormalJIDStatus
extends SecondaryJIDStatus {
    private JID jid;
    private String nickname;
    private String subscription;
    private String waiting;
    private List groups;
    private ArrayList resources;
    private String resource;
    private String type;

    public NormalJIDStatus(RosterItem rosterItem) {
        this.completeJID = this.jid = rosterItem.getJID();
        this.show = 7;
        this.resource = this.completeJID.getResource();
        JIDStatus jIDStatus = Roster.getJIDStatus(new JID(this.jid.getDomain()));
        this.type = jIDStatus == null ? null : jIDStatus.getType();
        this.update(rosterItem);
    }

    public NormalJIDStatus(JID jID, String string) {
        this.jid = jID;
        this.completeJID = jID;
        this.nickname = string;
        if (string == null || string.equals("")) {
            string = jID.toString();
        }
        this.show = 7;
        this.resource = this.completeJID.getResource();
        JIDStatus jIDStatus = Roster.getJIDStatus(new JID(jID.getDomain()));
        this.type = jIDStatus == null ? null : jIDStatus.getType();
    }

    public void update(RosterItem rosterItem) {
        this.nickname = rosterItem.getName();
        if (this.nickname == null || this.nickname.equals("")) {
            this.nickname = this.jid.toString();
        }
        this.subscription = rosterItem.getSubscription();
        this.waiting = rosterItem.getAsk();
        if (rosterItem.getGroups() == null) {
            this.groups = new LinkedList();
            this.groups.add(I18N.gettext("main.main.roster.Unfiled"));
        } else {
            this.groups = rosterItem.getGroups();
        }
    }

    public void updatePresence(Presence presence) {
        super.updatePresence(presence);
        this.resource = this.completeJID.getResource();
    }

    public void sortSecondary() {
        if (this.resources == null) {
            return;
        }
        Collections.sort(this.resources);
        if (this.compareTo(this.resources.get(0)) > 0) {
            ResourceJIDStatus resourceJIDStatus = (ResourceJIDStatus)this.resources.get(0);
            ResourceJIDStatus resourceJIDStatus2 = (ResourceJIDStatus)resourceJIDStatus.clone();
            resourceJIDStatus.update(this.completeJID, this.show, this.status, this.online);
            this.completeJID = resourceJIDStatus2.getCompleteJID();
            this.resource = this.completeJID.getResource();
            this.show = resourceJIDStatus2.getShow();
            this.status = resourceJIDStatus2.getStatus();
            this.online = resourceJIDStatus2.isOnline();
            Collections.sort(this.resources);
        }
    }

    public String toString() {
        if ("msn".equals(this.type) && "msn".equals(this.type)) {
            if (this.getMSNNick() != null) {
                return this.getMSNNick();
            }
            if (this.status != null && this.jid.getUser() != null) {
                return this.status;
            }
            return this.nickname;
        }
        return this.nickname;
    }

    public JID getJID() {
        return this.jid;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getNick() {
        return this.nickname;
    }

    public void setNick(String string) {
        this.nickname = string;
    }

    public String getType() {
        if (this.type == null) {
            return "jabber";
        }
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public String getWaiting() {
        return this.waiting;
    }

    public JIDStatus normalJIDStatus() {
        return this;
    }

    public SecondaryJIDStatus getSecondaryJIDStatus(String string) {
        if (this.resource == null) {
            this.resource = string;
            return this;
        }
        if (string.equals(this.resource)) {
            return this;
        }
        if (this.resources != null) {
            Iterator iterator = this.resources.iterator();
            while (iterator.hasNext()) {
                SecondaryJIDStatus secondaryJIDStatus = (SecondaryJIDStatus)iterator.next();
                if (!string.equals(secondaryJIDStatus.getCompleteJID().getResource())) continue;
                return secondaryJIDStatus;
            }
        }
        return null;
    }

    public ResourceJIDStatus addSecondaryJIDStatus(JID jID) {
        ResourceJIDStatus resourceJIDStatus = new ResourceJIDStatus(jID, this);
        if (this.resources == null) {
            this.resources = new ArrayList(4);
        }
        this.resources.add(resourceJIDStatus);
        return resourceJIDStatus;
    }

    public Iterator getSecondaryJIDStatussen() {
        if (this.resources == null) {
            return new Iterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                }
            };
        }
        return new Iterator(){
            private int count;
            {
                this.count = NormalJIDStatus.this.resources.size();
            }

            public boolean hasNext() {
                return this.count > 0;
            }

            public Object next() {
                --this.count;
                if (this.count < 0) {
                    throw new NoSuchElementException();
                }
                return NormalJIDStatus.this.resources.get(this.count);
            }

            public void remove() {
            }
        };
    }

    public ResourceJIDStatus removeResource(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(this.resource)) {
            if (this.resources != null) {
                ResourceJIDStatus resourceJIDStatus = (ResourceJIDStatus)this.resources.remove(0);
                this.completeJID = resourceJIDStatus.getCompleteJID();
                this.resource = this.completeJID.getResource();
                this.show = resourceJIDStatus.getShow();
                this.status = resourceJIDStatus.getStatus();
                this.online = resourceJIDStatus.isOnline();
                if (this.resources.isEmpty()) {
                    this.resources = null;
                }
                return resourceJIDStatus;
            }
            this.resource = null;
            this.completeJID = this.jid;
            return null;
        }
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            ResourceJIDStatus resourceJIDStatus = (ResourceJIDStatus)iterator.next();
            if (!resourceJIDStatus.getCompleteJID().getResource().equals(string)) continue;
            this.resources.remove(resourceJIDStatus);
            if (this.resources.isEmpty()) {
                this.resources = null;
            }
            return resourceJIDStatus;
        }
        System.out.println("error");
        return null;
    }

    public int groupCount() {
        if (this.groups == null) {
            return 0;
        }
        return this.groups.size();
    }

    public List getGroupsCopy() {
        return new LinkedList(this.groups);
    }

    public Iterator getGroups() {
        return this.groups.iterator();
    }

    public boolean isGroupPresent(String string) {
        return this.groups.contains(string);
    }

    public int compareTo(Object object) {
        return this.compareTo(this, (JIDStatus)object);
    }

    public int compareTo(JIDStatus jIDStatus, JIDStatus jIDStatus2) {
        if (jIDStatus.equals(jIDStatus2)) {
            return 0;
        }
        if (jIDStatus.getShow() == jIDStatus2.getShow()) {
            if (jIDStatus.getJID().getDomain().equals(Connect.getMyJID().getDomain())) {
                if (jIDStatus2.getJID().getDomain().equals(Connect.getMyJID().getDomain())) {
                    return jIDStatus.getJID().toStringNoResource().compareTo(jIDStatus2.getJID().toString());
                }
                return -1;
            }
            if (jIDStatus2.getJID().getDomain().equals(Connect.getMyJID().getDomain())) {
                return 1;
            }
            if (jIDStatus.getType().equals(jIDStatus2.getType())) {
                return jIDStatus.getJID().toStringNoResource().compareTo(jIDStatus2.getJID().toString());
            }
            if (this.getTypeRank(jIDStatus.getType()) < this.getTypeRank(jIDStatus2.getType())) {
                return -1;
            }
            return 1;
        }
        if (jIDStatus.getShow() < jIDStatus2.getShow()) {
            return -1;
        }
        return 1;
    }

    private int getTypeRank(String string) {
        if (string.equals("jabber")) {
            return 0;
        }
        if (string.equals("msn")) {
            return 1;
        }
        if (string.equals("icq")) {
            return 2;
        }
        return 3;
    }
}

