/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.images;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.images.Icons;
import nu.fw.jeti.images.RosterIconsHandler;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.util.Preferences;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StatusIcons {
    private static Map statusIcons;
    private SAXParser parser;

    public StatusIcons(SAXParser sAXParser) {
        if (statusIcons == null) {
            try {
                new Icons(sAXParser, "rostericons");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            statusIcons = new HashMap();
            this.loadDefaultPics();
            List list = Preferences.getPlugable("rostericons");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                if (!((Boolean)objectArray[1]).booleanValue()) continue;
                this.loadRosterIcon((String)objectArray[4], (String)objectArray[3]);
            }
        }
    }

    public StatusIcons() {
    }

    private void loadParser() {
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    protected void reloadRosterIcon(String string, String string2) {
        if (!statusIcons.containsKey(string2)) {
            this.loadRosterIcon(string, string2);
        }
    }

    protected void loadRosterIcon(String string, String string2) {
        String string3 = string.substring(0, string.lastIndexOf("."));
        InputStream inputStream = null;
        URL uRL = null;
        try {
            uRL = this.getClass().getResource("/" + string3 + "/");
            if (uRL == null) {
                uRL = new URL("jar:" + Start.dataURL + "plugins/rostericons/" + string + "!/" + string3 + "/");
            }
            inputStream = new URL(uRL, "icondef.xml").openStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (inputStream == null) {
            System.out.println(string + " not found");
            return;
        }
        try {
            if (this.parser == null) {
                this.loadParser();
            }
            this.parser.parse(inputStream, (DefaultHandler)new RosterIconsHandler(uRL, statusIcons, string2));
        }
        catch (SAXException sAXException) {
            sAXException.getException().printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void unloadRosterIcon(String string) {
        statusIcons.remove(string);
    }

    public static ImageIcon getOfflineIcon() {
        return StatusIcons.getStatusIcon(7, "default");
    }

    public static ImageIcon getStatusIcon(int n) {
        return StatusIcons.getStatusIcon(n, "");
    }

    public static ImageIcon getImageIcon(String string) {
        return StatusIcons.getStatusIcon(string, "images");
    }

    public static ImageIcon getStatusIcon(int n, String string) {
        switch (n) {
            case 1: {
                return StatusIcons.getStatusIcon("status/chat", string);
            }
            case 3: {
                return StatusIcons.getStatusIcon("status/away", string);
            }
            case 5: {
                return StatusIcons.getStatusIcon("status/xa", string);
            }
            case 4: {
                return StatusIcons.getStatusIcon("status/dnd", string);
            }
            case 7: {
                return StatusIcons.getStatusIcon("status/offline", string);
            }
            case 6: {
                return StatusIcons.getStatusIcon("status/invisible", string);
            }
            case 0: {
                return StatusIcons.getStatusIcon("status/ask", string);
            }
        }
        return StatusIcons.getStatusIcon("status/online", string);
    }

    public static ImageIcon getStatusIcon(JIDStatus jIDStatus) {
        return StatusIcons.getStatusIcon(jIDStatus.getShow(), jIDStatus.getType());
    }

    private static ImageIcon getStatusIcon(String string, String string2) {
        ImageIcon imageIcon;
        if (!statusIcons.containsKey(string2)) {
            string2 = "default";
        }
        if ((imageIcon = (ImageIcon)((Map)statusIcons.get(string2)).get(string)) == null) {
            imageIcon = (ImageIcon)((Map)statusIcons.get("default")).get(string);
        }
        return imageIcon;
    }

    public void loadDefaultPics() {
        String string = this.getClass().getResource("StatusIcons.class").toString();
        try {
            string = string.substring(0, string.lastIndexOf("StatusIcons.class"));
            this.readImages(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("status.cfg"))), new URL(string));
            this.readImages(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("images.cfg"))), new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public void readImages(BufferedReader bufferedReader, URL uRL) {
        try {
            HashMap hashMap = new HashMap();
            statusIcons.put(bufferedReader.readLine(), hashMap);
            while (true) {
                this.readSmilie(bufferedReader, uRL, hashMap);
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void readSmilie(BufferedReader bufferedReader, URL uRL, Map map) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = bufferedReader.read()) == -1) {
                throw new EOFException();
            }
            char c = (char)n;
            if (c == ' ') {
                map.put(new String(stringBuffer), this.readImage(bufferedReader, uRL));
                return;
            }
            stringBuffer.append(c);
        }
    }

    private Icon readImage(BufferedReader bufferedReader, URL uRL) throws IOException {
        URL uRL2 = null;
        String string = bufferedReader.readLine();
        uRL2 = new URL(uRL + string);
        return new ImageIcon(uRL2);
    }
}

