/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import nu.fw.jeti.backend.Connect;
import nu.fw.jeti.backend.IQTimerQueue;
import nu.fw.jeti.backend.LoginInfo;
import nu.fw.jeti.backend.NewAccount;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.backend.roster.Roster;
import nu.fw.jeti.backend.roster.Server;
import nu.fw.jeti.events.DiscoveryListener;
import nu.fw.jeti.events.IQResultListener;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.MessageListener;
import nu.fw.jeti.events.OwnMessageListener;
import nu.fw.jeti.events.PresenceListener;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.ui.Jeti;

public class Backend {
    private Map eventListeners = new HashMap(10);
    private Map presenceListeners;
    private Map messageListeners;
    private int identifier;
    private Connect connect;
    private Roster roster;
    private Server server;
    private Jeti main;
    private JFrame mainFrame;
    private Container mainWindow;
    private Start start;
    private IQTimerQueue iqTimerQueue = new IQTimerQueue();

    public Backend(Start start) {
        this.connect = new Connect(this, this.iqTimerQueue);
        this.server = new Server(this);
        this.roster = new Roster(this, this.server);
        this.start = start;
    }

    public void setMain(Jeti jeti, Window window, JFrame jFrame) {
        this.main = jeti;
        this.mainWindow = window;
        this.mainFrame = jFrame;
    }

    public Container getMainWindow() {
        if (this.mainWindow == null) {
            this.mainWindow = this.main.getTopLevelAncestor();
        }
        return this.mainWindow;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public Jeti getMain() {
        return this.main;
    }

    public void login(LoginInfo loginInfo) {
        this.connect.login(loginInfo);
    }

    public void autoLogin(LoginInfo loginInfo, int n) {
        this.connect.autoLogin(loginInfo, n);
    }

    public void abortLogin() {
        this.connect.abort();
    }

    public JID getMyJID() {
        return Connect.getMyJID();
    }

    public boolean isPasswordValid(String string) {
        return this.connect.isPasswordValid(string);
    }

    public synchronized String getIdentifier() {
        return "JETI_" + this.identifier++;
    }

    public String createThread() {
        return Integer.toHexString("JETI".hashCode()) + Long.toHexString(System.currentTimeMillis());
    }

    public String getAccountInfo() {
        return this.connect.getAccountInfo();
    }

    public Map getAvailableTransports() {
        return this.server.getAvailableTransports();
    }

    public void changeStatus(int n, String string) {
        this.connect.changeStatus(n, string);
    }

    public void rosterLoaded() {
        this.connect.connected();
    }

    public void disconnect() {
        this.connect.disconnect();
    }

    public boolean isLoggedIn() {
        return this.connect.isLoggedIn();
    }

    public void streamError() {
        this.connect.streamError();
    }

    public void exit() {
        Object object;
        if (!Start.applet) {
            System.out.println("This window will close in one minute");
            object = new Timer(true);
            ((Timer)object).schedule(new TimerTask(){

                public void run() {
                    System.exit(0);
                }
            }, 10000L);
        }
        this.connect.exit();
        object = Frame.getFrames();
        for (int i = 0; i < ((Frame[])object).length; ++i) {
            String string = object[i].getClass().getName();
            System.out.println(string);
            if (string.startsWith("nu.fw.jeti")) {
                ((Window)object[i]).dispose();
            }
            if (!((Component)object[i]).isDisplayable()) continue;
            System.out.println(string);
        }
        this.start.exit();
        this.eventListeners.clear();
        if (this.presenceListeners != null) {
            this.presenceListeners.clear();
        }
        if (this.messageListeners != null) {
            this.messageListeners.clear();
        }
    }

    public void send(Packet packet) {
        this.connect.send(packet);
    }

    public void send(InfoQuery infoQuery, IQResultListener iQResultListener, int n) {
        this.iqTimerQueue.add(infoQuery, iQResultListener, n);
        this.send(infoQuery);
    }

    public void sendMessage(Message message) {
        Iterator iterator = this.getListeners(OwnMessageListener.class);
        while (iterator.hasNext()) {
            ((OwnMessageListener)iterator.next()).sendMessage(message);
        }
        this.connect.send(message);
    }

    public void getItems(JID jID, DiscoveryListener discoveryListener, boolean bl) {
        this.connect.getItems(jID, discoveryListener, bl);
    }

    public void getItems(JID jID, DiscoveryListener discoveryListener) {
        this.connect.getItems(jID, discoveryListener);
    }

    public void getInfo(JID jID, DiscoveryListener discoveryListener) {
        this.connect.getInfo(jID, discoveryListener);
    }

    public void getItems(JID jID, String string, DiscoveryListener discoveryListener) {
        this.connect.getItems(jID, string, discoveryListener);
    }

    public void getInfo(JID jID, String string, DiscoveryListener discoveryListener) {
        this.connect.getInfo(jID, string, discoveryListener);
    }

    public static JIDStatus getJIDStatus(JID jID) {
        return Roster.getJIDStatus(jID);
    }

    public String[] getAllGroups() {
        return this.roster.getAllGroups();
    }

    public void newAccount(String string, String string2, String string3) {
        this.disconnect();
        new NewAccount(string, this.connect, string2, string3);
    }

    public void addExtensionHandler(String string, ExtensionHandler extensionHandler) {
        this.connect.getHandlers().addExtensionHandler(string, extensionHandler);
    }

    public void removeExtensionHandler(String string) {
        this.connect.getHandlers().removeExtensionHandler(string);
    }

    public synchronized void addPresenceListener(JID jID, PresenceListener presenceListener) {
        if (this.presenceListeners == null) {
            this.presenceListeners = new HashMap();
        }
        this.presenceListeners.put(jID, presenceListener);
    }

    public synchronized void removePresenceListener(JID jID) {
        if (this.presenceListeners == null) {
            return;
        }
        this.presenceListeners.remove(jID);
        if (this.presenceListeners.isEmpty()) {
            this.presenceListeners = null;
        }
    }

    public synchronized PresenceListener getPresenceListener(JID jID) {
        if (this.presenceListeners == null) {
            return null;
        }
        return (PresenceListener)this.presenceListeners.get(jID);
    }

    public synchronized void addMessageListener(JID jID, MessageListener messageListener) {
        if (this.messageListeners == null) {
            this.messageListeners = new HashMap();
        }
        this.messageListeners.put(jID, messageListener);
    }

    public synchronized void removeMessageListener(JID jID) {
        if (this.messageListeners == null) {
            return;
        }
        this.messageListeners.remove(jID);
        if (this.messageListeners.isEmpty()) {
            this.messageListeners = null;
        }
    }

    public synchronized MessageListener getMessageListener(JID jID) {
        if (this.messageListeners == null) {
            return null;
        }
        return (MessageListener)this.messageListeners.get(jID);
    }

    public synchronized void addListener(Class clazz, JETIListener jETIListener) {
        LinkedList<JETIListener> linkedList = (LinkedList<JETIListener>)this.eventListeners.get(clazz.getName());
        if (linkedList == null) {
            linkedList = new LinkedList<JETIListener>();
            this.eventListeners.put(clazz.getName(), linkedList);
        }
        linkedList.add(jETIListener);
    }

    public synchronized void removeListener(Class clazz, JETIListener jETIListener) {
        LinkedList linkedList = (LinkedList)this.eventListeners.get(clazz.getName());
        if (linkedList == null) {
            return;
        }
        linkedList.remove(jETIListener);
        if (linkedList.isEmpty()) {
            this.eventListeners.remove(clazz.getName());
        }
    }

    public synchronized Iterator getListeners(Class clazz) {
        LinkedList linkedList = (LinkedList)this.eventListeners.get(clazz.getName());
        if (linkedList == null) {
            return new Iterator(){

                public Object next() {
                    throw new NoSuchElementException();
                }

                public boolean hasNext() {
                    return false;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new LinkedList(linkedList).iterator();
    }
}

