/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber.elements;

import java.util.Iterator;
import java.util.List;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.XDataFieldBuilder;

public class XDataField
extends Extension {
    private String desc;
    private List options;
    private boolean required = false;
    private String value;
    private String label;
    private String var;
    private String type;

    public XDataField(String string, String string2) {
        this.var = string;
        this.value = string2;
    }

    public XDataField(XDataFieldBuilder xDataFieldBuilder) {
        this.desc = xDataFieldBuilder.getDescription();
        this.required = xDataFieldBuilder.required;
        this.label = xDataFieldBuilder.label;
        this.var = xDataFieldBuilder.var;
        this.type = xDataFieldBuilder.type;
        this.options = xDataFieldBuilder.getOptions();
        this.value = xDataFieldBuilder.getValue();
    }

    public String getDescription() {
        return this.desc;
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public int getOptionsSize() {
        return this.options.size();
    }

    public Object[] getOptions() {
        return this.options.toArray();
    }

    public Iterator getOptionsIterator() {
        return this.options.iterator();
    }

    public boolean getRequired() {
        return this.required;
    }

    public String getValue() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public String getVar() {
        return this.var;
    }

    public String getType() {
        return this.type;
    }

    public void appendToXML(StringBuffer stringBuffer) {
        stringBuffer.append("<field");
        XDataField.appendAttribute(stringBuffer, "label", this.label);
        XDataField.appendAttribute(stringBuffer, "var", this.var);
        XDataField.appendAttribute(stringBuffer, "type", this.type);
        stringBuffer.append(">");
        if (this.desc != null) {
            stringBuffer.append("<desc>" + this.desc + "</desc>");
        }
        if (this.value != null) {
            stringBuffer.append("<value>" + this.value + "</value>");
        }
        if (this.required) {
            stringBuffer.append("<required/>");
        }
        if (this.options != null) {
            Iterator iterator = this.options.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("<option");
                String[] stringArray = (String[])iterator.next();
                if (stringArray[0] != null) {
                    XDataField.appendAttribute(stringBuffer, "label", stringArray[0]);
                }
                stringBuffer.append(">");
                if (stringArray[1] != null) {
                    stringBuffer.append("<value>" + stringArray[1] + "</value>");
                }
                stringBuffer.append("</option>");
            }
        }
        stringBuffer.append("</field>");
    }
}

