/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;
import javax.xml.parsers.SAXParser;
import nu.fw.jeti.applet.Jeti;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.backend.URLClassloader;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.PluginData;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.Translator;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class PluginsInfo {
    private static URLClassloader classLoader;
    private static Map loadedPlugins;
    public static Map loadedPreferencePanels;
    private static Backend backend;
    private static Map pluginInstances;
    private static Translator translator;

    public PluginsInfo(Backend backend, SAXParser sAXParser, Start start) {
        PluginsInfo.backend = backend;
        if (!Start.applet) {
            classLoader = new URLClassloader(new URL[]{Start.programURL}, this.getClass().getClassLoader());
            UIManager.put("ClassLoader", classLoader);
        }
        new PluginData(sAXParser);
        Iterator iterator = Preferences.getPlugins().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            if (objectArray[2] == null || !((Boolean)objectArray[1]).booleanValue()) continue;
            start.setSplashText((String)objectArray[0]);
            PluginsInfo.loadPlugin((String)objectArray[0]);
        }
    }

    public static void setTranslator(Translator translator) {
        PluginsInfo.translator = translator;
    }

    public static Translator getTranslator() {
        return translator;
    }

    public static boolean isPluginLoaded(String string) {
        return loadedPlugins.containsKey(string);
    }

    public static void loadPlugin(String string) {
        Object object;
        Class<?> clazz = null;
        if (!Start.applet) {
            object = null;
            try {
                object = new URL(Start.programURL, "plugins/" + string + ".jar");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            classLoader.addURL((URL)object);
            try {
                clazz = classLoader.loadClass("nu.fw.jeti.plugins." + string + ".Plugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(MessageFormat.format(I18N.gettext("main.error.{0}_plugin_not_found"), string));
                return;
            }
        }
        clazz = Jeti.getPlugin(string);
        try {
            object = clazz.getMethod("init", Backend.class);
            ((Method)object).invoke(null, backend);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        loadedPlugins.put(string, clazz);
        if (!Start.applet) {
            try {
                loadedPreferencePanels.put(string, classLoader.loadClass("nu.fw.jeti.plugins." + string + ".PrefPanel"));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            Jeti.getPrefPanel(string, loadedPreferencePanels);
        }
    }

    public static void unloadPlugin(String string) {
        Object object;
        Class clazz = (Class)loadedPlugins.remove(string);
        if (clazz == null) {
            return;
        }
        System.out.println("removing " + string);
        loadedPreferencePanels.remove(string);
        List list = (List)pluginInstances.remove(string);
        try {
            object = clazz.getMethod("unload", Backend.class);
            ((Method)object).invoke(null, backend);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println(string + " has no remove");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (list == null) {
            return;
        }
        object = list.iterator();
        while (object.hasNext()) {
            Plugins plugins = (Plugins)((WeakReference)object.next()).get();
            if (plugins == null) continue;
            plugins.unload();
        }
        System.out.println(string + " removed");
    }

    public static Object getPluginInstance(String string) {
        Object object = null;
        try {
            Class clazz = (Class)loadedPlugins.get(string);
            try {
                Method method = clazz.getMethod("getInstance", null);
                object = method.invoke(null, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println(string + " has no instance method");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return object;
    }

    public static Plugins newPluginInstance(String string) {
        Object var1_1 = null;
        try {
            var1_1 = ((Class)loadedPlugins.get(string)).newInstance();
            PluginsInfo.addInstance(string, var1_1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return var1_1;
    }

    private static void addInstance(String string, Object object) {
        LinkedList<WeakReference<Object>> linkedList = (LinkedList<WeakReference<Object>>)pluginInstances.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<WeakReference<Object>>();
            pluginInstances.put(string, linkedList);
        }
        linkedList.add(new WeakReference<Object>(object));
    }

    public static String getAbout() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = loadedPlugins.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = null;
            try {
                string = (String)((Class)entry.getValue()).getField("ABOUT").get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null) continue;
            stringBuffer.append("\n - " + (String)entry.getKey() + '\n' + string);
        }
        return stringBuffer.toString();
    }

    public void exit() {
        String[] stringArray = new String[loadedPlugins.size()];
        loadedPlugins.keySet().toArray(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            PluginsInfo.unloadPlugin(stringArray[i]);
        }
        System.out.println("plugins unloaded");
    }

    static {
        loadedPlugins = new HashMap();
        loadedPreferencePanels = new HashMap();
        pluginInstances = new HashMap();
    }
}

