/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import nu.fw.jeti.events.ChatEndedListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.MessageBuilder;
import nu.fw.jeti.jabber.elements.PacketBuilder;
import nu.fw.jeti.jabber.elements.XDelay;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.jabber.elements.XMessageEvent;
import nu.fw.jeti.plugins.Emoticons;
import nu.fw.jeti.plugins.FormattedMessage;
import nu.fw.jeti.plugins.NativeUtils;
import nu.fw.jeti.plugins.Notifiers;
import nu.fw.jeti.plugins.OpenPGP;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.Spell;
import nu.fw.jeti.plugins.Translator;
import nu.fw.jeti.plugins.Word;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class ChatSplitPane
extends JSplitPane {
    private JID contactJID;
    private String me;
    private Backend backend;
    private JScrollPane scrlInvoer = new JScrollPane();
    private JTextPane txtInvoer = new JTextPane();
    private JScrollPane scrlUitvoer = new JScrollPane();
    private JTextPane txtUitvoer = new ToolTipTextpane();
    private String contactName;
    private String thread;
    private boolean enterSends = false;
    private boolean showTimestamp = false;
    private Emoticons emoticons;
    private JPanel pnlBottom = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel pnlContol = new JPanel();
    private JPopupMenu popupMenu = new JPopupMenu();
    private String composingID;
    private boolean typing = false;
    private FormattedMessage xhtml;
    private boolean groupChat;
    private Spell spell;
    private OpenPGP openPGP;
    private Translator translator;
    private Translator links;
    private Notifiers titleTimer;
    private Notifiers titleFlash;
    private SimpleAttributeSet colorAttributeSet = new SimpleAttributeSet();
    private boolean toFrontOnNewMessage = false;
    private static DateFormat dateFormat = DateFormat.getTimeInstance();
    DateFormat shortDate = DateFormat.getDateInstance(3);
    DateFormat shortTime = DateFormat.getTimeInstance(3);
    private volatile boolean scrolls = true;
    private volatile boolean systemScroll = true;
    private Date date = new Date();
    private ImageIcon avatar;

    public ChatSplitPane(Backend backend, JID jID, String string, String string2, JMenu jMenu, JFrame jFrame) {
        this.groupChat = true;
        this.contactJID = jID;
        this.contactName = string;
        this.backend = backend;
        this.me = string2;
        this.init("groupchat", jMenu);
        this.setParentFrame(jFrame);
    }

    public ChatSplitPane(Backend backend, JIDStatus jIDStatus, String string, String string2, JMenu jMenu, JFrame jFrame) {
        this.groupChat = false;
        this.contactJID = jIDStatus.getCompleteJID();
        this.contactName = jIDStatus.getNick();
        this.avatar = jIDStatus.getAvatar();
        this.backend = backend;
        this.me = string;
        this.thread = string2;
        this.toFrontOnNewMessage = Preferences.getBoolean("jeti", "toFrontOnNewMessage", false);
        this.init(jIDStatus.getType(), jMenu);
        this.setParentFrame(jFrame);
    }

    public void init(String string, JMenu jMenu) {
        Object object;
        Object object2;
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(I18N.gettext("main.chat.menu.To_front_on_new_message"));
        jCheckBoxMenuItem.setSelected(Preferences.getBoolean("jeti", "toFrontOnNewMessage", false));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatSplitPane.this.toFrontOnNewMessage = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        if (PluginsInfo.isPluginLoaded("emoticons")) {
            this.initEmoticons(string, jMenu);
        }
        if (!this.groupChat && PluginsInfo.isPluginLoaded("openpgp")) {
            this.openPGP = (OpenPGP)PluginsInfo.getPluginInstance("openpgp");
            if (this.openPGP.canEncrypt(this.contactJID)) {
                object2 = this.txtUitvoer.getDocument();
                object = new SimpleAttributeSet();
                StyleConstants.setForeground((MutableAttributeSet)object, Color.blue);
                try {
                    object2.insertString(object2.getLength(), "Encrypted Converstation\n", (AttributeSet)object);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
        if (PluginsInfo.isPluginLoaded("spell")) {
            this.spell = (Spell)((Object)PluginsInfo.newPluginInstance("spell"));
            this.spell.addChangeDictoryMenuEntry(jMenu);
        }
        if (PluginsInfo.isPluginLoaded("links")) {
            this.links = (Translator)((Object)PluginsInfo.newPluginInstance("links"));
            this.links.init(this.txtUitvoer);
        }
        if (PluginsInfo.isPluginLoaded("titlescroller")) {
            this.titleTimer = (Notifiers)((Object)PluginsInfo.newPluginInstance("titlescroller"));
        }
        if (PluginsInfo.isPluginLoaded("titleflash")) {
            this.titleFlash = (Notifiers)((Object)PluginsInfo.newPluginInstance("titleflash"));
        }
        if (PluginsInfo.isPluginLoaded("windowsutils")) {
            object2 = (NativeUtils)((Object)PluginsInfo.newPluginInstance("windowsutils"));
            object = new JCheckBoxMenuItem(I18N.gettext("windowsutils.Set_Always_On_Top"));
            ((AbstractButton)object).addActionListener(new ActionListener((NativeUtils)object2){
                private final /* synthetic */ NativeUtils val$util;
                {
                    this.val$util = nativeUtils;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (((JCheckBoxMenuItem)actionEvent.getSource()).isSelected()) {
                        this.val$util.windowAlwaysOnTop(ChatSplitPane.this.getTopLevelAncestor(), true);
                    } else {
                        this.val$util.windowAlwaysOnTop(ChatSplitPane.this.getTopLevelAncestor(), false);
                    }
                }
            });
            jMenu.add((JMenuItem)object);
        }
        this.translator = PluginsInfo.getTranslator();
        if (this.emoticons != null || this.spell != null) {
            this.txtInvoer.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        if (ChatSplitPane.this.spell != null) {
                            if (!ChatSplitPane.this.spell.rightClick(ChatSplitPane.this.txtInvoer, mouseEvent) && ChatSplitPane.this.emoticons != null) {
                                ChatSplitPane.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                            }
                        } else {
                            ChatSplitPane.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                }
            });
        }
        ToolTipManager.sharedInstance().registerComponent(this.txtUitvoer);
        this.enterSends = Preferences.getBoolean("jeti", "enterSends", true);
        this.showTimestamp = Preferences.getBoolean("jeti", "showTimestamp", true);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (PluginsInfo.isPluginLoaded("xhtml")) {
            this.xhtml = (FormattedMessage)((Object)PluginsInfo.newPluginInstance("xhtml"));
            this.xhtml.initXHTML(this, this.txtInvoer, this.pnlContol);
        }
        object2 = "";
        if (this.thread == null) {
            object2 = "no id - ";
        }
        object = this.txtUitvoer.getDocument();
        try {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, Color.gray);
            object.insertString(object.getLength(), (String)object2 + I18N.gettext("main.chat.Chat_started_on") + " " + DateFormat.getDateTimeInstance().format(new Date()), simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.setBorder(null);
        this.setSize(300, 350);
    }

    public JTextPane getTextInput() {
        return this.txtInvoer;
    }

    public void setParentFrame(JFrame jFrame) {
        if (this.titleTimer != null) {
            this.titleTimer.init(jFrame, this.contactName);
        }
        if (this.titleFlash != null) {
            this.titleFlash.init(jFrame, this.contactName);
        }
    }

    private void initEmoticons(String string, JMenu jMenu) {
        this.emoticons = (Emoticons)((Object)PluginsInfo.newPluginInstance("emoticons"));
        try {
            this.emoticons.init(this.txtUitvoer, this.pnlContol, this.txtInvoer, this.popupMenu, string, jMenu);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            PluginsInfo.unloadPlugin("emoticons");
            this.emoticons = null;
            return;
        }
    }

    public void close() {
        if (this.groupChat) {
            this.contactJID = new JID(this.contactJID.getUser(), this.contactJID.getDomain(), this.me);
        }
        Iterator iterator = this.backend.getListeners(ChatEndedListener.class);
        while (iterator.hasNext()) {
            ((ChatEndedListener)iterator.next()).chatEnded(this.contactJID);
        }
    }

    public void appendMessage(Message message, String string) {
        if (string == null) {
            this.appendSystemMessage(message.getBody());
        } else if (string.equals(this.me)) {
            this.showMessage(message, new Color(156, 23, 23), Preferences.getString("jeti", "ownName", this.me));
        } else {
            if (this.titleTimer != null) {
                this.titleTimer.start(MessageFormat.format(I18N.gettext("main.chat.{0}_says_{1}"), new String(string), new String(message.getBody())));
            }
            if (this.titleFlash != null) {
                this.titleFlash.start("");
            }
            if (!this.groupChat) {
                this.contactJID = message.getFrom();
            }
            this.showMessage(message, new Color(17, 102, 6), string);
        }
    }

    public void appendSystemMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Document document = ChatSplitPane.this.txtUitvoer.getDocument();
                Point point = ChatSplitPane.this.scrlUitvoer.getViewport().getViewPosition();
                boolean bl = ChatSplitPane.this.scrolls;
                ChatSplitPane.this.systemScroll = true;
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(simpleAttributeSet, Color.gray);
                String string2 = ChatSplitPane.this.showTimestamp ? ChatSplitPane.this.formatTime(new Date()) + " " : "";
                try {
                    document.insertString(document.getLength(), "\n" + string2 + string, simpleAttributeSet);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                if (bl) {
                    ChatSplitPane.this.txtUitvoer.setCaretPosition(document.getLength());
                    ChatSplitPane.this.scrolls = true;
                } else {
                    ChatSplitPane.this.scrlUitvoer.getViewport().setViewPosition(point);
                }
            }
        });
    }

    private void showMessage(final Message message, final Color color, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                String string2 = message.getBody();
                Date date = null;
                List list = null;
                ChatSplitPane.this.date.setTime(System.currentTimeMillis());
                if (message.hasExtensions()) {
                    object4 = message.getExtensions();
                    while (object4.hasNext()) {
                        object3 = (Extension)object4.next();
                        if (object3 instanceof XDelay) {
                            date = ((XDelay)object3).getDate();
                            continue;
                        }
                        if (ChatSplitPane.this.xhtml != null) {
                            if (list != null) continue;
                            list = ChatSplitPane.this.xhtml.getWordList((Extension)object3);
                            continue;
                        }
                        if (ChatSplitPane.this.openPGP == null || list != null || (object2 = ChatSplitPane.this.openPGP.decrypt((Extension)object3)) == null) continue;
                        string2 = object2;
                    }
                }
                if (ChatSplitPane.this.xhtml != null && !string.equals(ChatSplitPane.this.me)) {
                    ChatSplitPane.this.xhtml.useXHTML(list != null, string);
                }
                if (list == null) {
                    list = ChatSplitPane.createWordList(string2);
                }
                if (ChatSplitPane.this.links != null) {
                    ChatSplitPane.this.links.translate(list);
                }
                if (ChatSplitPane.this.groupChat) {
                    object4 = list.iterator();
                    while (object4.hasNext()) {
                        object3 = (Word)object4.next();
                        if (!((Word)object3).word.equals("/me")) continue;
                        ((Word)object3).word = string;
                    }
                }
                if (message.getType().equals("error")) {
                    ChatSplitPane.this.insertError(list, message);
                }
                if (ChatSplitPane.this.emoticons != null) {
                    ChatSplitPane.this.emoticons.insertEmoticons(list);
                }
                if (ChatSplitPane.this.translator != null) {
                    ChatSplitPane.this.translator.translate(list);
                }
                object4 = date;
                object3 = list;
                object2 = ChatSplitPane.this.scrlUitvoer.getViewport().getViewPosition();
                boolean bl = ChatSplitPane.this.scrolls;
                ChatSplitPane.this.systemScroll = true;
                Document document = ChatSplitPane.this.txtUitvoer.getDocument();
                try {
                    document.insertString(document.getLength(), "\n", null);
                    if (object4 != null) {
                        object = new SimpleAttributeSet();
                        StyleConstants.setForeground((MutableAttributeSet)object, Color.darkGray);
                        document.insertString(document.getLength(), ChatSplitPane.this.formatTime((Date)object4) + " ", (AttributeSet)object);
                    } else if (ChatSplitPane.this.showTimestamp) {
                        object = new SimpleAttributeSet();
                        StyleConstants.setForeground((MutableAttributeSet)object, Color.gray);
                        document.insertString(document.getLength(), ChatSplitPane.this.formatTime(ChatSplitPane.this.date) + " ", (AttributeSet)object);
                    }
                    StyleConstants.setForeground(ChatSplitPane.this.colorAttributeSet, color);
                    if (!message.getType().equals("error")) {
                        ChatSplitPane.this.colorAttributeSet.addAttribute("time", dateFormat.format(ChatSplitPane.this.date));
                        document.insertString(document.getLength(), string + ": ", ChatSplitPane.this.colorAttributeSet);
                    }
                    object = object3.iterator();
                    while (object.hasNext()) {
                        Word word = (Word)object.next();
                        document.insertString(document.getLength(), word.toString(), word.getAttributes());
                    }
                    if (bl) {
                        ChatSplitPane.this.txtUitvoer.setCaretPosition(document.getLength());
                        bl = true;
                    } else {
                        ChatSplitPane.this.scrlUitvoer.getViewport().setViewPosition((Point)object2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                if (ChatSplitPane.this.toFrontOnNewMessage && !ChatSplitPane.this.getTopLevelAncestor().isFocusOwner()) {
                    if (ChatSplitPane.this.getTopLevelAncestor() instanceof JFrame) {
                        object = (JFrame)ChatSplitPane.this.getTopLevelAncestor();
                        if (((Frame)object).getExtendedState() == 1) {
                            ((Frame)object).setState(0);
                        }
                        ((Window)object).toFront();
                    } else {
                        ChatSplitPane.this.txtInvoer.requestFocus();
                    }
                }
            }
        });
    }

    private String formatTime(Date date) {
        String string = "";
        if (System.currentTimeMillis() - date.getTime() > 600000L) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(9, 0);
            if (date.before(calendar.getTime())) {
                string = string + this.shortDate.format(date) + " ";
            }
        }
        string = string + "[" + this.shortTime.format(date) + "]";
        return string;
    }

    private void insertError(List list, Message message) {
        String string;
        boolean bl = false;
        switch (message.getErrorCode()) {
            case 404: {
                string = MessageFormat.format(I18N.gettext("main.error.User_{0}_could_not_be_found"), message.getFrom());
                bl = true;
                break;
            }
            default: {
                string = I18N.gettext("main.error.Error_in_chat");
            }
        }
        List list2 = ChatSplitPane.createWordList(string);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.red);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((Word)iterator.next()).addAttributes(simpleAttributeSet);
        }
        if (!bl) {
            list2.addAll(list);
        }
        list.clear();
        list.addAll(list2);
    }

    public static List createWordList(String string) {
        ArrayList<Word> arrayList = new ArrayList<Word>();
        StringBuffer stringBuffer = new StringBuffer();
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    ChatSplitPane.addWordFromTemp(stringBuffer, arrayList);
                    arrayList.add(new Word(" "));
                    stringBuffer = new StringBuffer();
                    continue block5;
                }
                case '\n': {
                    ChatSplitPane.addWordFromTemp(stringBuffer, arrayList);
                    arrayList.add(new Word("\n"));
                    stringBuffer = new StringBuffer();
                    continue block5;
                }
                case '\t': {
                    ChatSplitPane.addWordFromTemp(stringBuffer, arrayList);
                    arrayList.add(new Word("\t"));
                    stringBuffer = new StringBuffer();
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        ChatSplitPane.addWordFromTemp(stringBuffer, arrayList);
        return arrayList;
    }

    private static void addWordFromTemp(StringBuffer stringBuffer, List list) {
        if (stringBuffer.length() > 0) {
            list.add(new Word(stringBuffer));
        }
    }

    private void jbInit() throws Exception {
        Color color = UIManager.getColor("TextPane.foreground");
        this.txtInvoer.setForeground(color);
        this.txtUitvoer.setForeground(color);
        this.setResizeWeight(0.9);
        this.setOrientation(0);
        this.setBottomComponent(this.pnlBottom);
        this.scrlInvoer.setPreferredSize(new Dimension(100, 40));
        this.txtInvoer.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ChatSplitPane.this.txtInvoer_keyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (ChatSplitPane.this.spell != null) {
                    ChatSplitPane.this.spell.keyReleased(keyEvent, ChatSplitPane.this.txtInvoer);
                }
            }
        });
        this.txtUitvoer.setEditable(false);
        this.txtUitvoer.getDocument().putProperty("__EndOfLine__", "\n");
        this.txtInvoer.getDocument().putProperty("__EndOfLine__", "\n");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ChatSplitPane.this.txtInvoer.requestFocusInWindow();
            }
        });
        this.pnlBottom.setLayout(this.borderLayout1);
        this.pnlBottom.add((Component)this.scrlInvoer, "Center");
        this.pnlBottom.add((Component)this.pnlContol, "North");
        if (this.avatar != null && Preferences.getBoolean("ichatavatars", "showAvatar", true)) {
            int n = Preferences.getInteger("ichatavatars", "size", 96);
            JLabel jLabel = new JLabel(new ImageIcon(this.avatar.getImage().getScaledInstance(n, n, 1)));
            jLabel.setMinimumSize(new Dimension(0, 0));
            this.pnlBottom.add((Component)jLabel, "East");
        }
        this.add((Component)this.pnlBottom, "bottom");
        this.add((Component)this.scrlUitvoer, "top");
        this.scrlUitvoer.getViewport().add((Component)this.txtUitvoer, null);
        this.scrlInvoer.getViewport().add((Component)this.txtInvoer, null);
        this.scrlUitvoer.getVerticalScrollBar().getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                if (!boundedRangeModel.getValueIsAdjusting()) {
                    if (!ChatSplitPane.this.systemScroll) {
                        if (boundedRangeModel.getMaximum() - boundedRangeModel.getExtent() - boundedRangeModel.getValue() > 10) {
                            ChatSplitPane.this.scrolls = false;
                        } else {
                            ChatSplitPane.this.scrolls = true;
                        }
                    }
                    ChatSplitPane.this.systemScroll = false;
                }
            }
        });
        this.setDividerLocation(190);
    }

    public void send() {
        Object object;
        Object object2;
        boolean bl = false;
        XExtension xExtension = null;
        XExtension xExtension2 = null;
        List list = null;
        if (this.xhtml != null) {
            list = this.xhtml.makeWordListFromDocument();
        }
        if (list == null) {
            list = ChatSplitPane.createWordList(this.txtInvoer.getText());
        }
        StringBuffer stringBuffer = new StringBuffer();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            stringBuffer.append(object3.next());
        }
        object3 = stringBuffer.toString();
        if (this.xhtml != null) {
            xExtension = this.xhtml.getXHTMLExtension(list);
            object2 = new ArrayList();
            try {
                object = list.iterator();
                while (object.hasNext()) {
                    ((ArrayList)object2).add(((Word)object.next()).clone());
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
            xExtension2 = this.xhtml.getXHTMLExtension((List)object2);
            bl = this.xhtml.sendXML();
        }
        object2 = null;
        if (this.groupChat) {
            object2 = xExtension != null ? new Message(this.contactJID, (String)object3, xExtension) : new Message(this.contactJID, (String)object3);
        } else {
            object = new MessageBuilder();
            ((MessageBuilder)object).type = "chat";
            ((PacketBuilder)object).setTo(this.contactJID);
            ((PacketBuilder)object).setId(this.backend.getIdentifier());
            ((MessageBuilder)object).thread = this.thread;
            ((MessageBuilder)object).addXExtension(new XMessageEvent("composing", null));
            if (this.openPGP != null && this.openPGP.canEncrypt(this.contactJID)) {
                ((MessageBuilder)object).body = "This message is encrypted with openPGP";
                ((MessageBuilder)object).addXExtension(this.openPGP.encrypt((String)object3));
            } else {
                ((MessageBuilder)object).body = object3;
                if (bl) {
                    ((MessageBuilder)object).addXExtension(xExtension);
                }
            }
            object2 = (Message)((MessageBuilder)object).build();
            this.showMessage(new Message((String)object3, this.contactJID, null, this.thread, xExtension2), new Color(156, 23, 23), Preferences.getString("jeti", "ownName", this.me));
        }
        this.backend.sendMessage((Message)object2);
        this.txtInvoer.getHighlighter().removeAllHighlights();
        this.txtInvoer.setText("");
        this.txtInvoer.requestFocus();
        this.typing = false;
    }

    public void composingID(String string) {
        this.composingID = string;
    }

    void txtInvoer_keyPressed(KeyEvent keyEvent) {
        if (!this.groupChat) {
            if (this.txtInvoer.getText().length() < 2 && this.typing) {
                this.typing = false;
                if (this.composingID != null) {
                    this.backend.send(new Message(null, this.contactJID, null, new XMessageEvent(null, this.composingID)));
                }
            } else if (this.txtInvoer.getText().length() > 0 && !this.typing) {
                this.typing = true;
                if (this.composingID != null) {
                    this.backend.send(new Message(null, this.contactJID, null, new XMessageEvent("composing", this.composingID)));
                }
            }
        }
        if (keyEvent.getKeyCode() == 10) {
            if (this.enterSends) {
                if (keyEvent.getModifiers() == 1 || keyEvent.getModifiers() == 2) {
                    Document document = this.txtInvoer.getDocument();
                    try {
                        document.insertString(this.txtInvoer.getCaretPosition(), "\n", null);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                } else {
                    this.send();
                    keyEvent.consume();
                }
            } else if (keyEvent.getModifiers() == 1 || keyEvent.getModifiers() == 2) {
                this.send();
            }
        }
    }

    class ToolTipTextpane
    extends JTextPane {
        ToolTipTextpane() {
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = ChatSplitPane.this.txtUitvoer.viewToModel(mouseEvent.getPoint());
            StyledDocument styledDocument = (StyledDocument)ChatSplitPane.this.txtUitvoer.getDocument();
            AttributeSet attributeSet = styledDocument.getCharacterElement(n).getAttributes();
            return (String)attributeSet.getAttribute("time");
        }
    }
}

