/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nu.fw.jeti.events.MessageEventListener;
import nu.fw.jeti.events.MessageListener;
import nu.fw.jeti.events.PresenceListener;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.UnknownJIDStatus;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.XMessageEvent;
import nu.fw.jeti.ui.ChatWindow;
import nu.fw.jeti.ui.SendMessage;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class ChatWindows
implements MessageListener,
MessageEventListener,
PresenceListener {
    private static final int MAX_TABNAME_LENGTH = 100;
    private List chatWindows = new ArrayList();
    private Backend backend;
    private JTabbedPane tabs;
    private JFrame window;
    private int dividerLocation;
    private ComponentListener dividerListener;

    public ChatWindows(Backend backend) {
        this.backend = backend;
        backend.addListener(MessageListener.class, this);
        backend.addListener(MessageEventListener.class, this);
        backend.addListener(PresenceListener.class, this);
    }

    public synchronized void exit() {
        Iterator iterator = this.chatWindows.iterator();
        while (iterator.hasNext()) {
            ((ChatWindow)iterator.next()).exit();
        }
        if (this.window != null) {
            this.window.dispose();
        }
    }

    public synchronized void chatResource(JIDStatus jIDStatus) {
        ChatWindow chatWindow = this.getChatwindow(jIDStatus.getJID(), true);
        if (chatWindow == null) {
            chatWindow = this.startChat(jIDStatus, this.backend.createThread());
        }
        this.chat(chatWindow);
    }

    public synchronized void chat(JIDStatus jIDStatus) {
        ChatWindow chatWindow = this.getChatwindow(jIDStatus.getJID(), Preferences.getBoolean("jeti", "chatwindowPerResource", false));
        if (chatWindow == null) {
            chatWindow = this.startChat(jIDStatus, this.backend.createThread());
        }
        this.chat(chatWindow);
    }

    private void chat(ChatWindow chatWindow) {
        if (this.tabs != null && this.tabs.indexOfComponent(chatWindow) != -1) {
            chatWindow.requestFocusInWindow();
            this.tabs.setSelectedComponent(chatWindow);
        }
        ((Window)chatWindow.getTopLevelAncestor()).toFront();
    }

    private ChatWindow startChat(JIDStatus jIDStatus, String string) {
        ChatWindow chatWindow;
        if (Preferences.getBoolean("jeti", "tabs", false)) {
            if (this.window == null) {
                this.makeNewTabWindow();
            }
            chatWindow = new ChatWindow(this.backend, this, this.window, jIDStatus, string);
            if (!this.window.isDisplayable()) {
                this.addMenu(chatWindow);
            }
            this.addTab(jIDStatus, chatWindow);
            chatWindow.setDividerLocation(this.dividerLocation);
            chatWindow.addSplitBarListener(this.dividerListener);
            this.tabs.setBackgroundAt(this.tabs.getTabCount() - 1, Color.BLUE);
            this.tabs.setForegroundAt(this.tabs.getTabCount() - 1, Color.RED);
            this.window.setVisible(true);
        } else {
            chatWindow = new ChatWindow(this.backend, this, null, jIDStatus, string);
            this.setChatWindowPosition(chatWindow);
        }
        this.chatWindows.add(chatWindow);
        return chatWindow;
    }

    private void addTab(JIDStatus jIDStatus, ChatWindow chatWindow) {
        String string = jIDStatus.getNick();
        FontMetrics fontMetrics = this.tabs.getFontMetrics(this.tabs.getFont());
        string = string + "                                                         ";
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if ((n += fontMetrics.charWidth(string.charAt(i))) < 100) continue;
            string = string.substring(0, i);
            break;
        }
        this.tabs.addTab(string, StatusIcons.getStatusIcon(jIDStatus), chatWindow);
    }

    private void removeTab(ChatWindow chatWindow) {
        if (this.tabs.getTabCount() == 1) {
            this.window.dispose();
            this.window = null;
        }
        this.tabs.remove(chatWindow);
    }

    private void makeNewTabWindow() {
        this.window = new JFrame();
        this.window.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
        JMenuBar jMenuBar = new JMenuBar();
        this.tabs = new JTabbedPane(2){

            public void remove(Component component) {
                super.remove(component);
                this.fireStateChanged();
            }
        };
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        ChatWindow chatWindow = (ChatWindow)ChatWindows.this.tabs.getSelectedComponent();
                        if (chatWindow != null) {
                            JIDStatus jIDStatus = chatWindow.getJIDStatus();
                            ChatWindows.this.window.setTitle(jIDStatus.getNick());
                            ChatWindows.this.window.setIconImage(StatusIcons.getStatusIcon(jIDStatus).getImage());
                            ChatWindows.this.tabs.setBackgroundAt(ChatWindows.this.tabs.getSelectedIndex(), UIManager.getColor("TabbedPane.background"));
                            ChatWindows.this.tabs.setForegroundAt(ChatWindows.this.tabs.getSelectedIndex(), UIManager.getColor("TabbedPane.foreground"));
                            ChatWindows.this.window.getJMenuBar().removeAll();
                            ChatWindows.this.addMenu(chatWindow);
                            chatWindow.setDividerLocation(ChatWindows.this.dividerLocation);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        this.tabs.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ChatWindow chatWindow;
                if (mouseEvent.getButton() == 3 && (chatWindow = (ChatWindow)((JTabbedPane)mouseEvent.getSource()).getSelectedComponent()) != null) {
                    JPopupMenu jPopupMenu = ChatWindows.this.tabMenu(chatWindow);
                    jPopupMenu.show(ChatWindows.this.tabs, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.window.setJMenuBar(jMenuBar);
        this.window.setSize(Preferences.getInteger("jeti", "chatTabWidth", 500), Preferences.getInteger("jeti", "chatTabHeight", 400));
        int n = Preferences.getInteger("jeti", "chatTabPosX", 100);
        int n2 = Preferences.getInteger("jeti", "chatTabPosY", 100);
        int n3 = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int n4 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        if (n > n3) {
            n = 100;
        }
        if (n2 > n4) {
            n2 = 100;
        }
        this.window.setLocation(n, n2);
        this.window.setDefaultCloseOperation(0);
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                int n;
                Preferences.putInteger("jeti", "chatTabPosX", ChatWindows.this.window.getX());
                Preferences.putInteger("jeti", "chatTabPosY", ChatWindows.this.window.getY());
                Preferences.putInteger("jeti", "chatTabHeight", ChatWindows.this.window.getHeight());
                Preferences.putInteger("jeti", "chatTabWidth", ChatWindows.this.window.getWidth());
                Preferences.putInteger("jeti", "chatTabDivider", ChatWindows.this.dividerLocation);
                int n2 = ChatWindows.this.tabs.getTabCount();
                if (n2 > 1 && (n = JOptionPane.showConfirmDialog(ChatWindows.this.window, MessageFormat.format(I18N.gettext("main.chat.You_are_about_to_close_{0}_tabs_Are_you_sure_you_want_to_close_them?"), new Integer(n2)), "", 0)) == 1) {
                    return;
                }
                for (n = 0; n < n2; ++n) {
                    ChatWindow chatWindow = (ChatWindow)ChatWindows.this.tabs.getComponent(n);
                    chatWindow.exit();
                    ChatWindows.this.removeChatWindow(chatWindow);
                }
                ChatWindows.this.window.dispose();
                ChatWindows.this.window = null;
            }
        });
        this.window.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                ChatWindow chatWindow = (ChatWindow)ChatWindows.this.tabs.getSelectedComponent();
                if (chatWindow != null) {
                    chatWindow.requestFocusInWindow();
                }
            }
        });
        this.window.getContentPane().add(this.tabs);
        this.dividerLocation = Preferences.getInteger("jeti", "chatTabDivider", 200);
        this.dividerListener = new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                ChatWindows.this.dividerLocation = ((JSplitPane)componentEvent.getComponent().getParent()).getDividerLocation();
            }
        };
    }

    private void addMenu(final ChatWindow chatWindow) {
        final JMenu jMenu = chatWindow.getMenu();
        if (jMenu.getItem(jMenu.getItemCount() - 1).getName() == null) {
            final JMenuItem jMenuItem = new JMenuItem();
            final JMenuItem jMenuItem2 = new JMenuItem();
            I18N.setTextAndMnemonic("main.chat.menu.Move_to_Window", jMenuItem, true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jMenu.remove(jMenuItem);
                    jMenu.remove(jMenuItem2);
                    ChatWindows.this.removeTab(chatWindow);
                    chatWindow.removeSplitBarListener(ChatWindows.this.dividerListener);
                    chatWindow.changeToWindow();
                    ChatWindows.this.setChatWindowPosition(chatWindow);
                }
            });
            jMenu.add(jMenuItem);
            I18N.setTextAndMnemonic("main.chat.menu.Close", jMenuItem2, true);
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    chatWindow.removeSplitBarListener(ChatWindows.this.dividerListener);
                    chatWindow.exit();
                    ChatWindows.this.chatWindows.remove(chatWindow);
                    ChatWindows.this.removeTab(chatWindow);
                }
            });
            jMenuItem2.setName("close");
            jMenu.add(jMenuItem2);
        }
        this.window.getJMenuBar().add(jMenu);
    }

    private JPopupMenu tabMenu(final ChatWindow chatWindow) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = null;
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.chat.menu.Close", jMenuItem, true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                chatWindow.removeSplitBarListener(ChatWindows.this.dividerListener);
                chatWindow.exit();
                ChatWindows.this.chatWindows.remove(chatWindow);
                ChatWindows.this.removeTab(chatWindow);
            }
        });
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public void convertToTab(ChatWindow chatWindow, JIDStatus jIDStatus) {
        if (this.window == null) {
            this.makeNewTabWindow();
        }
        if (!this.window.isDisplayable()) {
            this.addMenu(chatWindow);
        }
        this.addTab(jIDStatus, chatWindow);
        chatWindow.setDividerLocation(this.dividerLocation);
        chatWindow.addSplitBarListener(this.dividerListener);
        chatWindow.setParentFrame(this.window);
        this.window.setVisible(true);
    }

    public synchronized void presenceChanged(Presence presence) {
        ChatWindow chatWindow = this.getChatwindow(presence.getFrom(), Preferences.getBoolean("jeti", "chatwindowPerResource", false));
        if (chatWindow != null) {
            chatWindow.appendPresenceChange(presence);
        }
    }

    private void beep() {
        if (Preferences.getBoolean("jeti", "beep", true)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void setTitleAt(ChatWindow chatWindow, String string) {
        int n = this.tabs.indexOfComponent(chatWindow);
        this.tabs.setTitleAt(n, string);
        if (this.tabs.getSelectedIndex() == n) {
            this.window.setTitle(string);
        }
    }

    public void setIconAt(ChatWindow chatWindow, ImageIcon imageIcon) {
        int n = this.tabs.indexOfComponent(chatWindow);
        this.tabs.setIconAt(n, imageIcon);
        if (this.tabs.getSelectedIndex() == n) {
            this.window.setIconImage(imageIcon.getImage());
        }
    }

    public synchronized void message(Message message) {
        if (message.getType().equals("chat") || message.getType().equals("error") && message.getThread() != null) {
            int n;
            this.beep();
            String string = message.getFrom().getDomain();
            ChatWindow chatWindow = string.indexOf("conference") > -1 && string.indexOf("private") > -1 && string.indexOf("groupchat") > -1 ? this.getChatwindow(message.getFrom(), true) : this.getChatwindow(message.getFrom(), Preferences.getBoolean("jeti", "chatwindowPerResource", false));
            if (this.tabs != null && (n = this.tabs.indexOfComponent(chatWindow)) != -1) {
                if (this.tabs.getSelectedIndex() != n) {
                    this.tabs.setBackgroundAt(n, Color.BLUE);
                    this.tabs.setForegroundAt(n, Color.RED);
                }
                this.tabs.setToolTipTextAt(n, message.getBody());
            }
            if (chatWindow == null) {
                JIDStatus jIDStatus = Backend.getJIDStatus(message.getFrom());
                chatWindow = jIDStatus == null ? this.startChat(new UnknownJIDStatus(message.getFrom()), message.getThread()) : this.startChat(jIDStatus, message.getThread());
            }
            chatWindow.appendMessage(message);
        } else if (message.getType().equals("groupchat")) {
            if (message.getFrom().getResource() != null) {
                this.beep();
            }
        } else {
            this.beep();
            new SendMessage(this.backend, message);
        }
    }

    private ChatWindow getChatwindow(JID jID, boolean bl) {
        String string = jID.getResource();
        ChatWindow chatWindow = null;
        for (int i = 0; i < this.chatWindows.size(); ++i) {
            JID jID2 = ((ChatWindow)this.chatWindows.get(i)).getJIDStatus().getCompleteJID();
            if (!jID2.equals(jID)) continue;
            if (string != null && string.equals(jID2.getResource())) {
                return (ChatWindow)this.chatWindows.get(i);
            }
            if (bl) continue;
            chatWindow = (ChatWindow)this.chatWindows.get(i);
        }
        return chatWindow;
    }

    private void setChatWindowPosition(ChatWindow chatWindow) {
        if (this.chatWindows.isEmpty()) {
            int n = Preferences.getInteger("jeti", "chatPosX", 100);
            int n2 = Preferences.getInteger("jeti", "chatPosY", 100);
            int n3 = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            int n4 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            if (n > n3) {
                n = 100;
            }
            if (n2 > n4) {
                n2 = 100;
            }
            chatWindow.setLocationOnScreen(n, n2);
        } else {
            ChatWindow chatWindow2 = (ChatWindow)this.chatWindows.get(this.chatWindows.size() - 1);
            chatWindow.setLocationOnScreen(chatWindow2);
        }
    }

    public synchronized void removeChatWindow(ChatWindow chatWindow) {
        this.chatWindows.remove(chatWindow);
    }

    public synchronized void onComposing(JID jID, String string, XMessageEvent xMessageEvent) {
        ChatWindow chatWindow = null;
        chatWindow = this.getChatwindow(jID, Preferences.getBoolean("jeti", "chatwindowPerResource", false));
        if (chatWindow != null) {
            chatWindow.composing(xMessageEvent.getType());
        }
    }

    public synchronized void requestComposing(JID jID, String string, String string2) {
        ChatWindow chatWindow = null;
        chatWindow = this.getChatwindow(jID, Preferences.getBoolean("jeti", "chatwindowPerResource", false));
        if (chatWindow != null) {
            chatWindow.composingID(string);
        }
    }
}

