/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;

public class JIDInput
extends JPanel {
    private JLabel jLabel1 = new JLabel();
    private JTextField txtContact = new JTextField();
    private JLabel jLabel2 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private JComboBox cmbService;
    private Backend backend;
    private Transport service;

    public JIDInput(Backend backend) {
        this.setLayout(new BoxLayout(this, 1));
        this.backend = backend;
        Object[] objectArray = this.makeTransportList(backend.getAvailableTransports());
        this.cmbService = new JComboBox<Object>(objectArray);
        this.cmbService.setAlignmentX(0.0f);
        this.cmbService.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JIDInput.this.service = (Transport)itemEvent.getItem();
                JIDInput.this.jLabel1.setText(JIDInput.this.service.getLabelName());
            }
        });
        this.service = (Transport)objectArray[0];
        JLabel jLabel = new JLabel();
        I18N.setTextAndMnemonic("main.AddContact.Select_Service", jLabel);
        jLabel.setLabelFor(this.cmbService);
        jLabel.setHorizontalAlignment(2);
        this.add(jLabel);
        this.add(this.cmbService);
        this.jbInit();
    }

    public JIDInput(JID jID, Backend backend) {
        this.backend = backend;
        Object[] objectArray = this.makeTransportList(backend.getAvailableTransports());
        String string = jID.getDomain();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!string.equals(((Transport)objectArray[i]).getServer())) continue;
            this.service = (Transport)objectArray[i];
            if (this.service.equalsToType("msn")) {
                this.txtContact.setText(jID.getUser().replace('%', '@'));
                continue;
            }
            this.txtContact.setText(jID.getUser());
        }
        if (this.service == null) {
            this.service = (Transport)objectArray[0];
            this.txtContact.setText(jID.toStringNoResource());
        }
        this.jLabel1.setText(this.service.getLabelName());
        this.txtContact.setEditable(false);
        this.txtContact.setHorizontalAlignment(2);
        this.jbInit();
    }

    void jbInit() {
        String[] stringArray = this.backend.getAllGroups();
        if (stringArray.length == 0) {
            stringArray = new String[]{I18N.gettext("main.main.roster.Friends")};
        }
        this.jLabel1.setText(this.service.getLabelName());
        this.jLabel1.setHorizontalAlignment(2);
        this.txtContact.setHorizontalAlignment(10);
        this.add(Box.createHorizontalGlue());
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.txtContact, null);
        this.add((Component)this.jLabel2, null);
        this.add((Component)this.jLabel3, null);
    }

    public JID createJID() {
        JID jID = null;
        if (this.service.equalsToType("jabber") || this.service.equalsToType("other")) {
            try {
                jID = JID.checkedJIDFromString(this.txtContact.getText());
            }
            catch (InstantiationException instantiationException) {
                Popups.errorPopup(instantiationException.getMessage(), I18N.gettext("main.error.Wrong_Jabber_Identifier"));
            }
        } else {
            String string = this.txtContact.getText();
            if (this.service.equalsToType("aim")) {
                if (string.indexOf(32) > -1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (c == ' ') continue;
                        stringBuffer.append(c);
                    }
                    string = stringBuffer.toString();
                }
            } else if (this.service.equalsToType("msn")) {
                string = string.replace('@', '%');
            }
            if (JID.isValidUser(string)) {
                jID = new JID(string, this.service.getServer());
            } else {
                Popups.errorPopup(MessageFormat.format(I18N.gettext("main.error.{0}_is_not_valid"), string), I18N.gettext("main.error.Wrong_contact_name"));
            }
        }
        return jID;
    }

    private Object[] makeTransportList(Map map) {
        LinkedList<Transport> linkedList = new LinkedList<Transport>();
        linkedList.add(new Transport("jabber", "Jabber", "JID", null));
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (string.equals("msn")) {
                linkedList.add(new Transport(string, "MSN Messenger", I18N.gettext("main.AddContact.Address"), (JIDStatus)entry.getValue()));
                continue;
            }
            if (string.equals("icq")) {
                linkedList.add(new Transport(string, "ICQ", "AddContact.UIN", (JIDStatus)entry.getValue()));
                continue;
            }
            if (string.equals("aim")) {
                linkedList.add(new Transport(string, "AOL Instant Messenger", I18N.gettext("main.AddContact.Screen_Name"), (JIDStatus)entry.getValue()));
                continue;
            }
            if (!string.equals("yahoo")) continue;
            linkedList.add(new Transport(string, "Yahoo! Messenger", "ID", (JIDStatus)entry.getValue()));
        }
        linkedList.add(new Transport("other", I18N.gettext("main.AddContact.Other"), I18N.gettext("main.AddContact.Contactname@Transport"), null));
        return linkedList.toArray();
    }

    class Transport {
        private String type;
        private String name;
        private String server;
        private String labelName;

        public Transport(String string, String string2, String string3, JIDStatus jIDStatus) {
            this.type = string;
            this.name = string2;
            this.labelName = string3;
            if (jIDStatus != null) {
                this.server = jIDStatus.getJID().getDomain();
            }
        }

        public String getLabelName() {
            return this.labelName;
        }

        public String getServer() {
            return this.server;
        }

        public String toString() {
            return this.name;
        }

        public boolean equalsToType(String string) {
            return this.type.equals(string);
        }
    }
}

