/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import nu.fw.jeti.events.DiscoveryListener;
import nu.fw.jeti.events.RegisterListener;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.DiscoveryInfo;
import nu.fw.jeti.jabber.elements.DiscoveryItem;
import nu.fw.jeti.jabber.elements.IQRegister;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.ui.RegisterWindow;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Utils;

public class RegisterServices
extends JFrame
implements DiscoveryListener,
RegisterListener {
    private JList jList1;
    private JPanel jPanel1 = new JPanel();
    private JButton btnRegister = new JButton();
    private JButton btnCancel = new JButton();
    private Map services = new HashMap();
    private Backend backend;
    private JTextField txtServer = new JTextField();
    private JButton btnChangeServer = new JButton();
    private JID server;
    private JID registerJID;
    private int numberOfServices;

    public RegisterServices(Backend backend) {
        this.backend = backend;
        this.server = new JID(backend.getMyJID().getDomain());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        backend.addListener(RegisterListener.class, this);
        backend.getItems(this.server, this);
    }

    private void jbInit() throws Exception {
        this.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
        I18N.setTextAndMnemonic("main.manageservices.Register", this.btnRegister);
        this.btnRegister.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RegisterServices.this.btnRegister_actionPerformed(actionEvent);
            }
        });
        this.btnCancel.setAlignmentX(0.5f);
        AbstractAction abstractAction = new AbstractAction(I18N.gettext("Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                RegisterServices.this.btnCancel_actionPerformed(actionEvent);
            }
        };
        Utils.addCancelButton(this, this.btnCancel, abstractAction);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RegisterServices.this.backend.removeListener(class$nu$fw$jeti$events$RegisterListener == null ? (class$nu$fw$jeti$events$RegisterListener = RegisterServices.class$("nu.fw.jeti.events.RegisterListener")) : class$nu$fw$jeti$events$RegisterListener, RegisterServices.this);
                RegisterServices.this.dispose();
            }
        });
        this.setTitle(I18N.gettext("main.manageservices.Manage_Services"));
        this.jList1 = new JList(new DefaultListModel());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RegisterServices.this.jList1_valueChanged(listSelectionEvent);
            }
        });
        this.jList1.setSelectionMode(0);
        this.btnChangeServer.setAlignmentX(0.5f);
        I18N.setTextAndMnemonic("main.manageservices.Change_Server", this.btnChangeServer);
        this.btnChangeServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RegisterServices.this.btnChangeServer_actionPerformed(actionEvent);
            }
        });
        JLabel jLabel = new JLabel();
        jLabel.setAlignmentX(0.5f);
        I18N.setTextAndMnemonic("main.manageservices.Server", jLabel);
        jLabel.setLabelFor(this.txtServer);
        this.getContentPane().add((Component)this.jList1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jPanel1.add(jLabel);
        this.jPanel1.add(this.txtServer);
        this.jPanel1.add(this.btnChangeServer);
        this.jPanel1.add(this.btnCancel);
        this.pack();
    }

    void btnCancel_actionPerformed(ActionEvent actionEvent) {
        this.backend.removeListener(RegisterListener.class, this);
        this.dispose();
    }

    void btnRegister_actionPerformed(ActionEvent actionEvent) {
        this.backend.removeListener(RegisterListener.class, this);
        this.dispose();
    }

    void jList1_valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        if (!jList.isSelectionEmpty()) {
            this.registerJID = (JID)this.services.get(jList.getSelectedValue());
            if (this.registerJID != null) {
                this.backend.send(new InfoQuery(this.registerJID, "get", this.backend.getIdentifier(), new IQRegister()));
            }
        }
        jList.clearSelection();
    }

    void btnChangeServer_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        JID jID = null;
        try {
            jID = JID.checkedJIDFromString(this.txtServer.getText());
        }
        catch (InstantiationException instantiationException) {
            Popups.errorPopup(instantiationException.getMessage(), I18N.gettext("main.error.invalid_server"));
        }
        if (jID == null) {
            return;
        }
        this.server = jID;
        this.backend.getItems(this.server, this);
    }

    public void discoveryItemResult(JID jID, DiscoveryItem discoveryItem) {
        if (!discoveryItem.hasItems()) {
            Popups.errorPopup(I18N.gettext("main.error.No_services"), I18N.gettext("main.error.Register_Services"));
        } else {
            this.numberOfServices = discoveryItem.getSize();
            DefaultListModel defaultListModel = (DefaultListModel)this.jList1.getModel();
            this.services.clear();
            defaultListModel.clear();
            Iterator iterator = discoveryItem.getItems();
            while (iterator.hasNext()) {
                DiscoveryItem discoveryItem2 = (DiscoveryItem)iterator.next();
                String string = discoveryItem2.getName();
                if (string == null) {
                    string = discoveryItem2.getJID().toStringNoResource();
                }
                this.services.put(string, discoveryItem2.getJID());
                defaultListModel.addElement(string);
                this.backend.getInfo(discoveryItem2.getJID(), this);
            }
        }
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void discoveryInfoResult(JID jID, DiscoveryInfo discoveryInfo) {
        --this.numberOfServices;
        DefaultListModel defaultListModel = (DefaultListModel)this.jList1.getModel();
        String string = discoveryInfo.getName();
        if (string != null && defaultListModel.removeElement(jID.toStringNoResource())) {
            defaultListModel.addElement(string);
        }
        if (discoveryInfo.hasFeatures()) {
            Iterator iterator = discoveryInfo.getFeatures();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.equals("jabber:iq:register")) continue;
                if (string != null) {
                    this.services.put(discoveryInfo.getName(), jID);
                    continue;
                }
                this.services.put(jID.toStringNoResource(), jID);
            }
        }
    }

    public void register(IQRegister iQRegister, String string) {
        new RegisterWindow(this.backend, iQRegister, this.registerJID, string);
    }
}

