/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import nu.fw.jeti.backend.Connect;
import nu.fw.jeti.backend.NewAccount;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.XDataCallback;
import nu.fw.jeti.jabber.XDataPanel;
import nu.fw.jeti.jabber.elements.IQRegister;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Utils;

public class RegisterWindow
extends JFrame
implements XDataCallback {
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JButton btnOK = new JButton();
    private JButton btnCancel = new JButton();
    private JPasswordField txtPassword;
    private JPanel pnlPassword = new JPanel();
    private JLabel jLabel3 = new JLabel();
    private JPanel pnlUsername = new JPanel();
    private JLabel jLabel2 = new JLabel();
    private JTextField txtUsername;
    private JPanel pnlInstructions = new JPanel();
    private JTextArea txtInstructions = new JTextArea();
    private JLabel jLabel1 = new JLabel();
    private String key;
    private Map map;
    private Backend backend;
    private NewAccount backend2;
    private boolean newAccount;
    private JID from;
    private JCheckBox checkBox = new JCheckBox(I18N.gettext("Remove"));
    public static final int STRUT_SIZE = 5;

    public RegisterWindow(NewAccount newAccount, IQRegister iQRegister, String string, String string2) {
        this.newAccount = true;
        Map map = iQRegister.getFields();
        this.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
        this.setTitle(I18N.gettext("main.register.Register"));
        this.map = new LinkedHashMap(15);
        this.backend2 = newAccount;
        this.key = (String)map.remove("key");
        try {
            Object object;
            if (map.containsKey("instructions")) {
                object = (String)map.remove("instructions");
                this.txtInstructions.setText((String)object);
                this.txtInstructions.setEnabled(false);
                this.jLabel1.setText(I18N.gettext("main.register.Instructions"));
                this.jLabel1.setPreferredSize(new Dimension(80, 17));
                this.pnlInstructions.setLayout(new BorderLayout());
                this.pnlInstructions.add((Component)this.jLabel1, "West");
                this.pnlInstructions.add((Component)this.txtInstructions, "Center");
                this.jPanel2.add(Box.createVerticalStrut(5));
                this.jPanel2.add(this.pnlInstructions);
            }
            if (map.containsKey("password")) {
                map.remove("password");
                this.txtPassword = new JPasswordField(string2);
            }
            if (map.containsKey("username")) {
                map.remove("username");
                this.txtUsername = new JTextField(string);
            }
            this.jbInit();
            if (map.containsKey("registered")) {
                map.remove("registered");
                this.checkBox.setEnabled(true);
            }
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                JTextField jTextField = new JTextField();
                jTextField.setText((String)entry.getValue());
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                this.map.put(entry.getKey(), jTextField);
                JLabel jLabel = new JLabel((String)entry.getKey());
                jLabel.setPreferredSize(new Dimension(80, 17));
                jPanel.add((Component)jLabel, "West");
                jPanel.add((Component)jTextField, "Center");
                this.jPanel2.add(Box.createVerticalStrut(5));
                this.jPanel2.add(jPanel);
            }
            this.jPanel2.add(this.checkBox);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public RegisterWindow(Backend backend, IQRegister iQRegister, JID jID, String string) {
        this.from = jID;
        this.backend = backend;
        XData xData = iQRegister.getXData();
        if (xData != null) {
            this.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
            if (xData.getTitle() != null) {
                this.setTitle(xData.getTitle());
            } else {
                this.setTitle(I18N.gettext("main.register.Register"));
            }
            this.setContentPane(new XDataPanel(xData, this));
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    RegisterWindow.this.cancelForm();
                }
            });
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        } else if (iQRegister.getFields() != null) {
            this.oldRegister(iQRegister);
        }
    }

    private void oldRegister(IQRegister iQRegister) {
        this.newAccount = false;
        Map map = iQRegister.getFields();
        this.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
        this.setTitle(I18N.gettext("main.register.Register"));
        this.map = new LinkedHashMap(15);
        this.key = (String)map.remove("key");
        try {
            Object object;
            if (map.containsKey("instructions")) {
                object = (String)map.remove("instructions");
                this.txtInstructions.setText((String)object);
                this.txtInstructions.setEnabled(false);
                this.jLabel1.setText(I18N.gettext("main.register.Instructions"));
                this.jLabel1.setPreferredSize(new Dimension(80, 17));
                this.pnlInstructions.setLayout(new BorderLayout());
                this.pnlInstructions.add((Component)this.jLabel1, "West");
                this.pnlInstructions.add((Component)this.txtInstructions, "Center");
                this.jPanel2.add(Box.createVerticalStrut(5));
                this.jPanel2.add(this.pnlInstructions);
            }
            if (map.containsKey("password")) {
                this.txtPassword = new JPasswordField((String)map.remove("password"));
            }
            if (map.containsKey("username")) {
                this.txtUsername = new JTextField((String)map.remove("username"));
            }
            this.jbInit();
            if (map.containsKey("registered")) {
                map.remove("registered");
                this.checkBox.setEnabled(true);
            }
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                JTextField jTextField = new JTextField();
                jTextField.setText((String)entry.getValue());
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                this.map.put(entry.getKey(), jTextField);
                JLabel jLabel = new JLabel((String)entry.getKey());
                jLabel.setPreferredSize(new Dimension(80, 17));
                jPanel.add((Component)jLabel, "West");
                jPanel.add((Component)jTextField, "Center");
                this.jPanel2.add(Box.createVerticalStrut(5));
                this.jPanel2.add(jPanel);
            }
            this.jPanel2.add(this.checkBox);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.getRootPane().setDefaultButton(this.btnOK);
        I18N.setTextAndMnemonic("OK", this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RegisterWindow.this.btnOK_actionPerformed(actionEvent);
            }
        });
        AbstractAction abstractAction = new AbstractAction(I18N.gettext("Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                RegisterWindow.this.btnCancel_actionPerformed(actionEvent);
            }
        };
        this.btnCancel.setAction(abstractAction);
        Utils.addCancelButton(this, this.btnCancel, abstractAction);
        this.checkBox.setEnabled(false);
        if (this.txtUsername != null) {
            this.jLabel2.setPreferredSize(new Dimension(80, 17));
            this.jLabel2.setText(I18N.gettext("main.register.Username"));
            this.pnlUsername.setLayout(new BorderLayout());
            this.pnlUsername.add((Component)this.jLabel2, "West");
            this.pnlUsername.add((Component)this.txtUsername, "Center");
            this.jPanel2.add(Box.createVerticalStrut(5));
            this.jPanel2.add(this.pnlUsername);
        }
        if (this.txtPassword != null) {
            this.jLabel3.setPreferredSize(new Dimension(80, 17));
            this.jLabel3.setText(I18N.gettext("main.register.Password"));
            this.pnlPassword.setLayout(new BorderLayout());
            this.pnlPassword.add((Component)this.jLabel3, "West");
            this.pnlPassword.add((Component)this.txtPassword, "Center");
            this.jPanel2.add(Box.createVerticalStrut(5));
            this.jPanel2.add(this.pnlPassword);
        }
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel1.add((Component)this.btnOK, null);
        this.jPanel1.add((Component)this.btnCancel, null);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.setDefaultCloseOperation(2);
    }

    void btnCancel_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void btnOK_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.btnOK.setEnabled(false);
        this.btnCancel.setEnabled(false);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(16);
        if (this.txtUsername != null) {
            linkedHashMap.put("username", this.txtUsername.getText().trim());
        }
        if (this.txtPassword != null) {
            linkedHashMap.put("password", this.txtPassword.getText());
        }
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = ((JTextField)entry.getValue()).getText().trim();
            if (string.equals("")) continue;
            linkedHashMap.put((String)entry.getKey(), string);
        }
        linkedHashMap.put("key", this.key);
        if (this.newAccount) {
            this.backend2.sendRegister(new IQRegister(false, linkedHashMap), this);
        } else {
            if (this.checkBox.isSelected()) {
                this.backend.send(new InfoQuery(this.from, "set", new IQRegister(true, null)));
            } else {
                this.backend.send(new InfoQuery(this.from, "set", new IQRegister(false, linkedHashMap)));
            }
            this.dispose();
        }
    }

    public void sendForm(XData xData) {
        this.backend.send(new InfoQuery(this.from, "set", new IQRegister(xData)));
        this.dispose();
    }

    public void cancelForm() {
        this.backend.send(new InfoQuery(this.from, "set", new IQRegister(new XData("cancel"))));
        this.dispose();
    }

    public void login(Connect connect, String string) {
        Popups.messagePopup(I18N.gettext("main.register.registration_succeded"), I18N.gettext("main.register.Register"));
        this.dispose();
    }

    public void error(String string) {
        this.setVisible(true);
        this.setCursor(Cursor.getDefaultCursor());
        Popups.errorPopup(MessageFormat.format(I18N.gettext("main.error.registration_aborted,_code_{0}"), string), I18N.gettext("main.register.Register"));
        this.btnOK.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }
}

