/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.Document;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.Translator;
import nu.fw.jeti.plugins.Word;
import nu.fw.jeti.ui.ChatSplitPane;
import nu.fw.jeti.util.I18N;

public class SendMessage
extends JFrame {
    private static final int MIN_WIDTH = 300;
    private static final int MIN_HEIGHT = 200;
    private JButton jButton1 = new JButton();
    private Backend backend;
    private JID jid;
    private String user;
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTextPane jTextArea1 = new JTextPane();
    private JTextField txtSubject = new JTextField();

    public SendMessage(Backend backend, JID jID, String string) {
        this.backend = backend;
        this.jid = jID;
        this.setTitle(string);
        try {
            this.jbInit();
            this.jButton1.setText(I18N.gettext("Send"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.jTextArea1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                SendMessage.this.txtInvoer_keyPressed(keyEvent);
            }
        });
        this.fixSize();
    }

    public SendMessage(Backend backend, JID jID, String string, String string2) {
        this(backend, jID, string);
        this.txtSubject.setText("Re: " + string2);
    }

    public SendMessage(Backend backend, Message message) {
        Object object;
        this.backend = backend;
        if (message.getType().equals("error")) {
            this.handleError(message);
            return;
        }
        this.getRootPane().setDefaultButton(this.jButton1);
        JIDStatus jIDStatus = Backend.getJIDStatus(message.getFrom());
        this.jid = message.getFrom();
        this.user = jIDStatus == null || jIDStatus.getNick() == null ? (this.jid.getResource() != null ? this.jid.getUser() + "/" + this.jid.getResource() : this.jid.getUser()) : jIDStatus.getNick();
        String string = message.getSubject();
        if (string == null) {
            this.setTitle(this.user);
        } else {
            this.setTitle(this.user + " | " + string);
        }
        try {
            int n;
            this.jbInit();
            I18N.setTextAndMnemonic("main.popup.Reply", this.jButton1);
            object = message.getBody();
            if (PluginsInfo.isPluginLoaded("links")) {
                Translator translator = (Translator)((Object)PluginsInfo.newPluginInstance("links"));
                translator.init(this.jTextArea1);
                List list = ChatSplitPane.createWordList((String)object);
                translator.translate(list);
                Document document = this.jTextArea1.getDocument();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Word word = (Word)iterator.next();
                    document.insertString(document.getLength(), word.toString(), word.getAttributes());
                }
            } else {
                this.jTextArea1.setText((String)object);
            }
            this.jTextArea1.setEditable(false);
            this.txtSubject.setText(string);
            this.txtSubject.setEditable(false);
            if (((String)object).indexOf(System.getProperty("line.separator")) == -1 && (n = this.getFontMetrics((Font)UIManager.get("TextArea.font")).stringWidth((String)object)) > 400) {
                this.setSize(400, 300);
                this.setVisible(true);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pack();
        object = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)this.getHeight() > ((Dimension)object).getHeight() || (double)this.getWidth() > ((Dimension)object).getWidth()) {
            this.setSize((int)((Dimension)object).getWidth() - 50, (int)((Dimension)object).getHeight() - 50);
        }
        this.fixSize();
        this.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SendMessage.this.jButton1_actionPerformed(actionEvent);
            }
        });
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jTextArea1, null);
        this.getContentPane().add((Component)this.jButton1, "South");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(I18N.gettext("main.popup.Subject")), "North");
        jPanel.add((Component)this.txtSubject, "Center");
        jPanel.add((Component)new JLabel(I18N.gettext("main.popup.Message")), "South");
        this.getContentPane().add((Component)jPanel, "North");
        this.setLocationRelativeTo(null);
    }

    private void fixSize() {
        Dimension dimension = this.getSize();
        if (dimension.height < 200) {
            dimension.height = 200;
        }
        if (dimension.width < 300) {
            dimension.width = 300;
        }
        if (dimension != this.getSize()) {
            this.setSize(dimension);
        }
    }

    void jButton1_actionPerformed(ActionEvent actionEvent) {
        if (this.jButton1.getText().equals(I18N.gettext("Send"))) {
            String string = this.txtSubject.getText();
            if (string.equals("")) {
                string = null;
            }
            this.backend.sendMessage(new Message(this.jTextArea1.getText(), string, this.jid));
            this.dispose();
        } else {
            new SendMessage(this.backend, this.jid, this.user, this.txtSubject.getText()).show();
        }
    }

    void txtInvoer_keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && (keyEvent.getModifiers() == 1 || keyEvent.getModifiers() == 2)) {
            this.jButton1.doClick();
        }
    }

    private void handleError(Message message) {
        String string;
        switch (message.getErrorCode()) {
            case 404: {
                string = MessageFormat.format(I18N.gettext("main.error.User_{0}_could_not_be_found"), message.getFrom());
                break;
            }
            default: {
                string = I18N.gettext("main.error.Error_in_chat") + " " + message.getBody();
            }
        }
        JOptionPane.showMessageDialog(this.backend.getMainWindow(), string, I18N.gettext("main.error.Error"), 0);
    }
}

