/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.ui.models.LocaleModel;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;
import nu.fw.jeti.util.SwingWorker;

public class StdPreferencesPanel
extends PreferencesPanel {
    private Backend backend;
    private JCheckBox chkEnter;
    public static JCheckBox chkBeep;
    private JCheckBox chkNick;
    private JCheckBox chkBMW;
    private JCheckBox chkTaskbar;
    private JCheckBox chkTitle;
    private JCheckBox chkOFFline;
    private JCheckBox chkToFrontOnNewMessage;
    private JCheckBox chkJetiPos;
    private JCheckBox chkJetiTabs;
    private JCheckBox chkShowTimestamp;
    private JComboBox cmbLanguage;
    private JComboBox cmbCountry;
    private boolean oldOFFline;

    public StdPreferencesPanel(Backend backend) {
        this.backend = backend;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        this.chkEnter = new JCheckBox(I18N.gettext("main.options.standard.Enter_key_sends_messages"));
        this.chkEnter.setToolTipText(I18N.gettext("main.options.standard.tooltip.Send_message_with_enter_key_instead_of_ctrl_or_shift_and_enter"));
        this.chkEnter.setSelected(Preferences.getBoolean("jeti", "enterSends", true));
        this.add((Component)this.chkEnter, gridBagConstraints);
        this.chkToFrontOnNewMessage = new JCheckBox(I18N.gettext("main.options.standard.To_front_on_new_message"));
        this.chkToFrontOnNewMessage.setSelected(Preferences.getBoolean("jeti", "toFrontOnNewMessage", false));
        this.add((Component)this.chkToFrontOnNewMessage, gridBagConstraints);
        this.chkShowTimestamp = new JCheckBox(I18N.gettext("main.options.standard.Show_timestamps"));
        this.chkShowTimestamp.setToolTipText(I18N.gettext("main.options.standard.tooltip.Show_timestamps_on_all_messages"));
        this.chkShowTimestamp.setSelected(Preferences.getBoolean("jeti", "showTimestamp", true));
        this.add((Component)this.chkShowTimestamp, gridBagConstraints);
        chkBeep = new JCheckBox(I18N.gettext("main.options.standard.Beep_on_new_message"));
        chkBeep.setToolTipText(I18N.gettext("main.options.standard.tooltip.Beep_on_new_message_arrival"));
        chkBeep.setSelected(Preferences.getBoolean("jeti", "beep", true));
        this.add((Component)chkBeep, gridBagConstraints);
        this.chkNick = new JCheckBox(I18N.gettext("main.options.standard.Show_remote_msn_nicknames"));
        this.chkNick.setToolTipText(I18N.gettext("main.options.standard.tooltip.Show_remote_nicknames_instead_of_the_local_ones"));
        this.chkNick.setSelected(Preferences.getBoolean("jeti", "showRealNick", false));
        this.add((Component)this.chkNick, gridBagConstraints);
        this.chkOFFline = new JCheckBox(I18N.gettext("main.options.standard.Show_Offline_contacts"));
        this.chkOFFline.setToolTipText(I18N.gettext("main.options.standard.tooltip.Show_Offline_contacts"));
        this.oldOFFline = Preferences.getBoolean("jeti", "showoffline", true);
        this.chkOFFline.setSelected(this.oldOFFline);
        this.add((Component)this.chkOFFline, gridBagConstraints);
        this.chkTaskbar = new JCheckBox(I18N.gettext("main.options.standard.Don't_show_the_mainscreen_in_the_taskbar"));
        this.chkTaskbar.setToolTipText(I18N.gettext("main.options.standard.tooltip.Restart_required"));
        this.chkTaskbar.setSelected(Preferences.getBoolean("jeti", "showNotInTaskbar", false));
        this.add((Component)this.chkTaskbar, gridBagConstraints);
        this.chkBMW = new JCheckBox(I18N.gettext("main.options.standard.White_background_main_window"));
        this.chkBMW.setToolTipText(I18N.gettext("main.options.standard.tooltip.Makes_the_main_window_white_(restart_required)"));
        this.chkBMW.setSelected(Preferences.getBoolean("jeti", "bmw", true));
        this.add((Component)this.chkBMW, gridBagConstraints);
        this.chkTitle = new JCheckBox(I18N.gettext("main.options.standard.Java_window_decorations"));
        this.chkTitle.setToolTipText(I18N.gettext("main.options.standard.tooltip.Set_java_look_and_feel_decorations_for_windows_(restart_required)"));
        this.chkTitle.setSelected(Preferences.getBoolean("jeti", "javadecorations", false));
        this.add((Component)this.chkTitle, gridBagConstraints);
        this.chkJetiPos = new JCheckBox(I18N.gettext("main.options.standard.Jeti_as_Menu_instead_of_button"));
        this.chkJetiPos.setToolTipText(I18N.gettext("main.options.standard.tooltip.Change_the_Jeti_button_to_a_menu_(restart_required)"));
        this.chkJetiPos.setSelected(Preferences.getBoolean("jeti", "menutop", false));
        this.add((Component)this.chkJetiPos, gridBagConstraints);
        this.chkJetiTabs = new JCheckBox(I18N.gettext("main.options.standard.Jeti_with_tabs"));
        this.chkJetiTabs.setSelected(Preferences.getBoolean("jeti", "tabs", false));
        this.add((Component)this.chkJetiTabs, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.anchor = 21;
        gridBagConstraints2.insets = new Insets(3, 5, 0, 3);
        this.add((Component)new JLabel(I18N.gettext("main.options.standard.Language")), gridBagConstraints2);
        this.cmbLanguage = new JComboBox<Object>(new Object[]{I18N.gettext("main.options.standard.Loading_Languages,_please_wait")});
        this.cmbLanguage.setPreferredSize(new Dimension(200, 21));
        this.add((Component)this.cmbLanguage, gridBagConstraints);
        this.add((Component)new JLabel(I18N.gettext("main.options.standard.Country")), gridBagConstraints2);
        this.cmbCountry = new JComboBox();
        this.cmbCountry.setPreferredSize(new Dimension(200, 21));
        this.add((Component)this.cmbCountry, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add(Box.createVerticalGlue(), gridBagConstraints);
        SwingWorker swingWorker = new SwingWorker(){
            I18N i18n;

            public Object construct() {
                this.i18n = new I18N();
                return null;
            }

            public void finished() {
                int n;
                int n2;
                StdPreferencesPanel.this.cmbLanguage.setModel(new DefaultComboBoxModel<I18N.Language>(this.i18n.getLanguages()));
                LocaleModel localeModel = new LocaleModel(this.i18n);
                StdPreferencesPanel.this.cmbLanguage.addActionListener(localeModel);
                String string = Preferences.getString("jeti", "language", JComponent.getDefaultLocale().getLanguage());
                ComboBoxModel comboBoxModel = StdPreferencesPanel.this.cmbLanguage.getModel();
                boolean bl = false;
                for (n2 = 0; n2 < comboBoxModel.getSize(); ++n2) {
                    if (!((I18N.Language)comboBoxModel.getElementAt(n2)).getLanguageCode().equals(string)) continue;
                    StdPreferencesPanel.this.cmbLanguage.setSelectedIndex(n2);
                    bl = true;
                    break;
                }
                if (!bl) {
                    string = Locale.getDefault().getLanguage();
                    for (n2 = 0; n2 < comboBoxModel.getSize(); ++n2) {
                        if (!((I18N.Language)comboBoxModel.getElementAt(n2)).getLanguageCode().equals(string)) continue;
                        StdPreferencesPanel.this.cmbLanguage.setSelectedIndex(n2);
                        break;
                    }
                }
                String string2 = Preferences.getString("jeti", "country", JComponent.getDefaultLocale().getCountry());
                StdPreferencesPanel.this.cmbCountry.setModel(localeModel);
                comboBoxModel = StdPreferencesPanel.this.cmbCountry.getModel();
                bl = false;
                for (n = 0; n < comboBoxModel.getSize(); ++n) {
                    if (!((I18N.Country)comboBoxModel.getElementAt(n)).getCountryCode().equals(string2)) continue;
                    StdPreferencesPanel.this.cmbCountry.setSelectedIndex(n);
                    bl = true;
                    break;
                }
                if (!bl) {
                    string2 = "";
                    for (n = 0; n < comboBoxModel.getSize(); ++n) {
                        if (!((I18N.Country)comboBoxModel.getElementAt(n)).getCountryCode().equals(string2)) continue;
                        StdPreferencesPanel.this.cmbCountry.setSelectedIndex(n);
                        break;
                    }
                }
            }
        };
        swingWorker.start();
    }

    public void savePreferences() {
        Preferences.putBoolean("jeti", "enterSends", this.chkEnter.isSelected());
        Preferences.putBoolean("jeti", "toFrontOnNewMessage", this.chkToFrontOnNewMessage.isSelected());
        Preferences.putBoolean("jeti", "showTimestamp", this.chkShowTimestamp.isSelected());
        Preferences.putBoolean("jeti", "beep", chkBeep.isSelected());
        Preferences.putBoolean("jeti", "showRealNick", this.chkNick.isSelected());
        Preferences.putBoolean("jeti", "bmw", this.chkBMW.isSelected());
        Preferences.putBoolean("jeti", "showNotInTaskbar", this.chkTaskbar.isSelected());
        Preferences.putBoolean("jeti", "javadecorations", this.chkTitle.isSelected());
        Preferences.putBoolean("jeti", "menutop", this.chkJetiPos.isSelected());
        Preferences.putBoolean("jeti", "tabs", this.chkJetiTabs.isSelected());
        if (this.oldOFFline != this.chkOFFline.isSelected()) {
            Preferences.putBoolean("jeti", "showoffline", this.chkOFFline.isSelected());
            this.oldOFFline = this.chkOFFline.isSelected();
            this.backend.getMain().changeOFFlinePanel(this.oldOFFline);
        }
        if (this.cmbCountry.getSelectedIndex() != -1) {
            Preferences.putString("jeti", "country", ((I18N.Country)this.cmbCountry.getSelectedItem()).getCountryCode());
        }
        if (this.cmbLanguage.getSelectedIndex() != -1 && this.cmbLanguage.getSelectedItem() instanceof I18N.Language) {
            String string = ((I18N.Language)this.cmbLanguage.getSelectedItem()).getLanguageCode();
            if (!Preferences.getString("jeti", "language", StdPreferencesPanel.getDefaultLocale().getLanguage()).equals(string)) {
                Preferences.putString("jeti", "language", string);
                I18N.init();
                this.backend.getMain().translate();
            }
        }
    }
}

