/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.util;

import java.util.Hashtable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeExpander
implements TreeExpansionListener,
TreeModelListener {
    private JTree tree;
    private Hashtable known = new Hashtable();

    public TreeExpander(JTree jTree, TreeModel treeModel) {
        this.tree = jTree;
        jTree.addTreeExpansionListener(this);
        treeModel.addTreeModelListener(this);
    }

    public void expand(TreePath treePath) {
        this.known.put(treePath, new Boolean(true));
        this.tree.expandPath(treePath);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        Boolean bl = (Boolean)this.known.get(treeModelEvent.getTreePath());
        if (bl != null && bl.booleanValue()) {
            this.tree.expandPath(treeModelEvent.getTreePath());
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        Boolean bl = (Boolean)this.known.get(treeExpansionEvent.getPath());
        if (bl == null || !bl.booleanValue()) {
            this.known.put(treeExpansionEvent.getPath(), new Boolean(true));
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        Boolean bl = (Boolean)this.known.get(treeExpansionEvent.getPath());
        if (bl != null || bl.booleanValue()) {
            this.known.put(treeExpansionEvent.getPath(), new Boolean(false));
        }
    }
}

