/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import nu.fw.jeti.util.TreeModelSelector;

public class TreeModelFilter
implements TreeModel,
TreeModelListener {
    private TreeModelSelector selector;
    private TreeModel model;
    private LinkedList listeners = new LinkedList();
    private Hashtable nodes = new Hashtable(30);

    public TreeModelFilter(TreeModel treeModel, TreeModelSelector treeModelSelector) {
        this.model = treeModel;
        this.selector = treeModelSelector;
        treeModel.addTreeModelListener(this);
    }

    public Object getRoot() {
        return this.model.getRoot();
    }

    public Object getChild(Object object, int n) {
        int n2 = this.model.getChildCount(object);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Object object2 = this.model.getChild(object, i);
            boolean bl = this.selector.isVisible(object2);
            this.nodes.put(object2, new Boolean(bl));
            if (!bl || n != n3++) continue;
            return object2;
        }
        return null;
    }

    public int getChildCount(Object object) {
        int n = this.model.getChildCount(object);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object2 = this.model.getChild(object, i);
            boolean bl = this.selector.isVisible(object2);
            this.nodes.put(object2, new Boolean(bl));
            if (!bl) continue;
            ++n2;
        }
        return n2;
    }

    public boolean isLeaf(Object object) {
        return this.model.isLeaf(object);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        int n = this.model.getChildCount(object);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object3 = this.model.getChild(object, i);
            if (object3.equals(object2)) {
                return n2;
            }
            if (!this.selector.isVisible(object2)) continue;
            ++n2;
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        int[] nArray = treeModelEvent.getChildIndices();
        Object[] objectArray = treeModelEvent.getChildren();
        if (nArray == null || nArray.length == 0) {
            TreeModelEvent treeModelEvent2 = new TreeModelEvent((Object)this, treeModelEvent.getTreePath());
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TreeModelListener)this.listeners.get(i)).treeNodesChanged(treeModelEvent2);
            }
        } else {
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                this.nodeChanged(treeModelEvent.getTreePath(), nArray[i], objectArray[i]);
            }
        }
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Object object = treeModelEvent.getTreePath().getLastPathComponent();
        int[] nArray = treeModelEvent.getChildIndices();
        Object[] objectArray = treeModelEvent.getChildren();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            boolean bl = this.selector.isVisible(objectArray[i]);
            this.nodes.put(objectArray[i], new Boolean(bl));
            if (!bl) continue;
            arrayList.add(new Integer(this.upperIndex(object, nArray[i])));
            arrayList2.add(objectArray[i]);
        }
        if (arrayList.size() > 0) {
            TreeModelEvent treeModelEvent2 = this.createEvent(treeModelEvent.getTreePath(), arrayList, arrayList2);
            for (n = 0; n < this.listeners.size(); ++n) {
                ((TreeModelListener)this.listeners.get(n)).treeNodesInserted(treeModelEvent2);
            }
        }
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Object object = treeModelEvent.getTreePath().getLastPathComponent();
        int[] nArray = treeModelEvent.getChildIndices();
        Object[] objectArray = treeModelEvent.getChildren();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            Boolean bl = (Boolean)this.nodes.get(objectArray[i]);
            if (bl != null && bl.booleanValue()) {
                arrayList.add(new Integer(this.upperIndex(object, nArray[i])));
                arrayList2.add(objectArray[i]);
            }
            this.nodes.remove(objectArray[i]);
        }
        if (arrayList.size() > 0) {
            TreeModelEvent treeModelEvent2 = this.createEvent(treeModelEvent.getTreePath(), arrayList, arrayList2);
            for (n = 0; n < this.listeners.size(); ++n) {
                ((TreeModelListener)this.listeners.get(n)).treeNodesRemoved(treeModelEvent2);
            }
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        TreePath treePath = treeModelEvent.getTreePath();
        Object object = treePath.getLastPathComponent();
        this.nodes.put(object, new Boolean(this.selector.isVisible(object)));
        if (treePath.getPathCount() > 1) {
            treePath = treePath.getParentPath();
        }
        TreeModelEvent treeModelEvent2 = new TreeModelEvent((Object)this, treePath);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeStructureChanged(treeModelEvent2);
        }
    }

    private TreeModelEvent createEvent(TreePath treePath, ArrayList arrayList, ArrayList arrayList2) {
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return new TreeModelEvent((Object)this, treePath, nArray, arrayList2.toArray(new Object[arrayList2.size()]));
    }

    private int upperIndex(Object object, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.selector.isVisible(this.model.getChild(object, i))) continue;
            ++n2;
        }
        return n2;
    }

    private void nodeChanged(TreePath treePath, int n, Object object) {
        Object object2 = treePath.getLastPathComponent();
        boolean bl = this.selector.isVisible(object);
        Boolean bl2 = (Boolean)this.nodes.get(object);
        if (bl && (bl2 == null || !bl2.booleanValue())) {
            int[] nArray = new int[]{this.upperIndex(object2, n)};
            Object[] objectArray = new Object[]{object};
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TreeModelListener)this.listeners.get(i)).treeNodesInserted(treeModelEvent);
            }
        } else if (!bl && bl2 != null && bl2.booleanValue()) {
            int[] nArray = new int[]{this.upperIndex(object2, n)};
            Object[] objectArray = new Object[]{object};
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TreeModelListener)this.listeners.get(i)).treeNodesRemoved(treeModelEvent);
            }
        } else if (bl && bl2 != null && bl2.booleanValue()) {
            int n2 = this.upperIndex(treePath.getLastPathComponent(), n);
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, new int[]{n2}, new Object[]{object});
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TreeModelListener)this.listeners.get(i)).treeNodesChanged(treeModelEvent);
            }
        }
        this.nodes.put(object, new Boolean(bl));
    }
}

