/*
 * Decompiled with CFR 0.152.
 */
package BioDynPackage;

import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class UtilFileFilter
extends FileFilter {
    private String description;
    private ArrayList<String> acceptedExtensions = new ArrayList();

    public UtilFileFilter(String description, String ... extensions) {
        if (description == null || extensions.length == 0) {
            throw new NullPointerException();
        }
        this.description = description;
        for (String extension : extensions) {
            this.acceptedExtensions.add(extension);
        }
    }

    public void addExtension(String extension) {
        this.acceptedExtensions.add(extension);
    }

    public void removeExtension(String extension) {
        this.acceptedExtensions.remove(extension);
    }

    @Override
    public boolean accept(File file) {
        String nomFichier = file.getName().toLowerCase();
        if (file.isDirectory()) {
            return true;
        }
        for (int i = 0; i < this.acceptedExtensions.size(); ++i) {
            if (!nomFichier.endsWith(this.acceptedExtensions.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        String rep = this.description + " ( ." + this.acceptedExtensions.get(0);
        for (int i = 1; i < this.acceptedExtensions.size(); ++i) {
            rep = rep + ", ." + this.acceptedExtensions.get(i);
        }
        return rep + " )";
    }
}

