/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Color;
import idx3d.idx3d_Math;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.net.URL;

public class idx3d_Texture {
    public int width;
    public int height;
    public int bitWidth;
    public int bitHeight;
    public int[] pixel;
    public String path;

    public idx3d_Texture(Image image) {
        this.loadTexture(image);
    }

    public idx3d_Texture(URL uRL, String string) {
        int n = 0;
        String string2 = uRL.toString();
        while (string2.indexOf("/", n) > 0) {
            n = string2.indexOf("/", n) + 1;
        }
        string2 = string2.substring(0, n) + string;
        while (string2.indexOf("/", n) > 0) {
            n = string2.indexOf("/", n) + 1;
        }
        String string3 = string2.substring(n);
        String string4 = string2.substring(0, n);
        try {
            this.loadTexture(Toolkit.getDefaultToolkit().getImage(new URL(string4 + string3)));
            return;
        }
        catch (Exception exception) {
            System.err.println(exception + "");
            return;
        }
    }

    public idx3d_Texture(String string) {
        this.path = new File(string).getName();
        this.loadTexture(Toolkit.getDefaultToolkit().getImage(string));
    }

    public idx3d_Texture toAverage() {
        int n = this.width * this.height - 1;
        while (n >= 0) {
            this.pixel[n] = idx3d_Color.getAverage(this.pixel[n]);
            --n;
        }
        return this;
    }

    public idx3d_Texture valToGray() {
        int n = this.width * this.height - 1;
        while (n >= 0) {
            int n2 = idx3d_Math.crop(this.pixel[n], 0, 255);
            this.pixel[n] = idx3d_Color.getColor(n2, n2, n2);
            --n;
        }
        return this;
    }

    public idx3d_Texture put(idx3d_Texture idx3d_Texture2) {
        System.arraycopy(idx3d_Texture2.pixel, 0, this.pixel, 0, this.width * this.height);
        return this;
    }

    public idx3d_Texture add(idx3d_Texture idx3d_Texture2) {
        int n = this.width * this.height - 1;
        while (n >= 0) {
            this.pixel[n] = idx3d_Color.add(this.pixel[n], idx3d_Texture2.pixel[n]);
            --n;
        }
        return this;
    }

    public idx3d_Texture multiply(idx3d_Texture idx3d_Texture2) {
        int n = this.width * this.height - 1;
        while (n >= 0) {
            this.pixel[n] = idx3d_Color.multiply(this.pixel[n], idx3d_Texture2.pixel[n]);
            --n;
        }
        return this;
    }

    public idx3d_Texture mix(idx3d_Texture idx3d_Texture2) {
        int n = this.width * this.height - 1;
        while (n >= 0) {
            this.pixel[n] = idx3d_Color.mix(this.pixel[n], idx3d_Texture2.pixel[n]);
            --n;
        }
        return this;
    }

    public void resize() {
        double d = 1.0 / Math.log(2.0);
        this.bitWidth = (int)(Math.log(this.width) * d);
        int n = (int)Math.pow(2.0, this.bitWidth);
        this.bitHeight = (int)(Math.log(this.height) * d);
        int n2 = (int)Math.pow(2.0, this.bitHeight);
        this.resize(n, n2);
    }

    public void resize(int n, int n2) {
        this.setSize(n, n2);
    }

    public idx3d_Texture toGray() {
        int n = this.width * this.height - 1;
        while (n >= 0) {
            this.pixel[n] = idx3d_Color.getGray(this.pixel[n]);
            --n;
        }
        return this;
    }

    public idx3d_Texture sub(idx3d_Texture idx3d_Texture2) {
        int n = this.width * this.height - 1;
        while (n >= 0) {
            this.pixel[n] = idx3d_Color.sub(this.pixel[n], idx3d_Texture2.pixel[n]);
            --n;
        }
        return this;
    }

    private void loadTexture(Image image) {
        try {
            while ((this.width = image.getWidth(null)) < 0 || (this.height = image.getHeight(null)) < 0) {
            }
            this.pixel = new int[this.width * this.height];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixel, 0, this.width);
            pixelGrabber.grabPixels();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public idx3d_Texture colorize(int[] nArray) {
        int n = nArray.length - 1;
        int n2 = this.width * this.height - 1;
        while (n2 >= 0) {
            this.pixel[n2] = nArray[idx3d_Math.crop(this.pixel[n2], 0, n)];
            --n2;
        }
        return this;
    }

    public static idx3d_Texture blendTopDown(idx3d_Texture idx3d_Texture2, idx3d_Texture idx3d_Texture3) {
        idx3d_Texture3.resize(idx3d_Texture2.width, idx3d_Texture2.height);
        idx3d_Texture idx3d_Texture4 = new idx3d_Texture(idx3d_Texture2.width, idx3d_Texture2.height);
        int n = 0;
        int n2 = 0;
        while (n2 < idx3d_Texture2.height) {
            int n3 = 255 * n2 / (idx3d_Texture2.height - 1);
            int n4 = 0;
            while (n4 < idx3d_Texture2.width) {
                idx3d_Texture4.pixel[n] = idx3d_Color.transparency(idx3d_Texture3.pixel[n], idx3d_Texture2.pixel[n], n3);
                ++n;
                ++n4;
            }
            ++n2;
        }
        return idx3d_Texture4;
    }

    private void setSize(int n, int n2) {
        int n3 = n * n2;
        if (n * n2 != 0) {
            int[] nArray = new int[n * n2];
            int n4 = n2 - 1;
            while (n4 >= 0) {
                n3 -= n;
                int n5 = n4 * this.height / n2 * this.width;
                int n6 = n - 1;
                while (n6 >= 0) {
                    nArray[n6 + n3] = this.pixel[n6 * this.width / n + n5];
                    --n6;
                }
                --n4;
            }
            this.width = n;
            this.height = n2;
            this.pixel = nArray;
        }
    }

    private boolean inrange(int n, int n2, int n3) {
        return n >= n2 & n < n3;
    }

    public idx3d_Texture getClone() {
        idx3d_Texture idx3d_Texture2 = new idx3d_Texture(this.width, this.height);
        idx3d_Math.copyBuffer(this.pixel, idx3d_Texture2.pixel);
        return idx3d_Texture2;
    }

    public idx3d_Texture inv() {
        int n = this.width * this.height - 1;
        while (n >= 0) {
            this.pixel[n] = idx3d_Color.inv(this.pixel[n]);
            --n;
        }
        return this;
    }

    public void cls() {
        idx3d_Math.clearBuffer(this.pixel, 0);
    }

    public idx3d_Texture(int n, int n2) {
        this.height = n2;
        this.width = n;
        this.pixel = new int[n * n2];
        this.cls();
    }

    public idx3d_Texture(int n, int n2, int[] nArray) {
        this.height = n2;
        this.width = n;
        this.pixel = new int[this.width * this.height];
    }
}

