 /**************************************************************************
 *                                                                         *
 *                                 RasTop                                  *
 *                                                                         *
 *                 Molecular Graphics Visualisation Tool                   *
 *                                                                         *
 *                           by Philippe Valadon                           *
 *                 P.O. Box 8064, La Jolla, CA 92192-8064, USA,            *
 *                       www.geneinfinity.org/rastop                       *
 *                                                                         *
 *                                *******                                  *
 *                                                                         *
 *                   Based on RasMol 2.6 by Roger Sayle                    *
 * Biomolecular Structures Group, Glaxo Wellcome Research & Development,   *
 *                      Stevenage, Hertfordshire, UK                       *
 *         Version 2.6, August 1995, Version 2.6.4, December 1998          *
 *                   Copyright (C) Roger Sayle 1992-1999                   *
 *                                                                         *
 *                                 and                                     *
 *                                                                         *
 * Arne Mueller       RasMol 2.6x1   May 1998   (C) Arne Mueller 1998      *
 * Gary Grossman and  RasMol 2.5-ucb Nov 1995   (C) UC Regents/ModularCHEM *
 * Marco Molinaro     RasMol 2.6-ucb Nov 1996       Consortium 1995, 1996  *
 * Herbert J.         RasMol 2.7.0   Mar 1999   (C) Herbert J. Bernstein   * 
 * Bernstein          RasMol 2.7.1   Jun 1999       1998-2001              *
 *                    RasMol 2.7.1.1 Jan 2001                              *
 *                    RasMol 2.7.2   Aug 2000                              *
 *                    RasMol 2.7.2.1 Apr 2001                              *
 * Philippe Valadon   RasTop 2.0.3   Jan 2003   (C) Philippe Valadon       *
 *                                                  2000-2003              *
 *                                                                         *
 * Please read the file NOTICE for important notices which apply to this   *
 * package. If you are not going to make changes to Rasmol, you are not    *
 * only permitted to freely make copies and distribute them, you are       *
 * encouraged to do so, provided you do the following:                     *
 *   * 1. Either include the complete documentation, especially the file   *
 *     NOTICE, with what you distribute or provide a clear indication      *
 *     where people can get a copy of the documentation; and               *
 *   * 2. Please give credit where credit is due citing the version and    *
 *     original authors properly; and                                      *
 *   * 3. Please do not give anyone the impression that the original       *
 *     authors are providing a warranty of any kind.                       *
 *                                                                         *
 * If you would like to use major pieces of Rasmol in some other program,  *
 * make modifications to Rasmol, or in some other way make what a lawyer   *
 * would call a "derived work", you are not only permitted to do so, you   *
 * are encouraged to do so. In addition to the things we discussed above,  *
 * please do the following:                                                *
 *   * 4. Please explain in your documentation how what you did differs    *
 *     from this version of Rasmol; and                                    *
 *   * 5. Please make your modified source code available.                 *
 *                                                                         *
 * This version of Rasmol is not in the public domain, but it is given     *
 * freely to the community in the hopes of advancing science. If you make  *
 * changes, please make them in a responsible manner, and please offer us  *
 * the opportunity to include those changes in future versions of Rasmol.  *
 ***************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// RasTop.cpp
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "RasTop.h"
#include "rasdoc.h"
#include "rasview.h"
#include "mainfrm.h"
#include "graphics.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRasTopApp

BEGIN_MESSAGE_MAP(CRasTopApp, CWinApp)
	//{{AFX_MSG_MAP(CRasTopApp)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpenRasDoc)
	ON_COMMAND(IDD_ABOUTRASTOP, OnAboutrastop)
	ON_COMMAND(ID_FILE_NEW, OnFileNewRasDoc)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

CRasTopApp::CRasTopApp()	{}

CRasTopApp theApp;

static int  RasWinInit() 
{	
	Interactive = true;
    CalcBondsFlag = true;
    ReDrawFlag = RFInitial;
    CommandActive = true;
    AllowWrite = false;
    FileDepth = -1;
    SeqFormat = true;
    if( !OpenDisplay(NULL,0) )
		return(false);

    static char VersionStr[255];
    
	WriteString("RasMol Molecular Renderer\n");
    sprintf (VersionStr,"Roger Sayle, August 1995 - %s\n", MAIN_COPYRIGHT);
    WriteString(VersionStr);
    
	WriteString("Mods Version 2.5-ucb,  Nov. 1995 - \
	Mods Version 2.6-ucb, Nov. 1996\n");
	WriteString("Copyright (C) Gary Grossman & Marco Molinaro 1995-1996\n"); 
    
	WriteString("Mods Version 2.6x1,  May 1998 - \
	Copyright (C) Arne Mueller 1998\n");
    
	WriteString("RasMol Version 2.7.0,  March 1999, Version 2.7.1,  June 1999\n");
	WriteString("RasMol Version 2.7.2,  August 2000\n");
	WriteString("Copyright (C) Herbert J. Bernstein 1998-2000\n");

	sprintf (VersionStr,"%s %s, %s - %s\n", 
		VER_NAME, VERSION, VER_DATE, VER_COPYRIGHT);
    WriteString(VersionStr);

    InitialiseCmndLine();
    InitialiseCommand(); 
    InitialiseTransform();
    InitialiseDatabase();
	InitialiseRenderer();
    InitialisePixUtils();
    InitialiseAbstree();
    InitialiseOutFile();
    InitialiseRepres();
    /*InitHelpFile();*/
    InitialiseMultiple();
    InitialiseBRotate();
    InitialisePrefs();

    ResetCommandLine(true);
	ReadPrefs();

    return( true );
}

BOOL CRasTopApp::InitInstance()
{
	Enable3dControls();
	AfxInitRichEdit() ;

    /* Set Registry for version 2 */
	SetRegistryKey(_T("RasTop\\v2"));

    /* Load MRU List */
	LoadStdProfileSettings(4);

	/* Tric to stop display of yellow light status */
    FileDepth = -1;

	CMultiDocTemplate* pRasTemplate;
	pRasTemplate = new CMultiDocTemplate(
		IDR_RASTYPE,
		RUNTIME_CLASS(CRasDoc),
		RUNTIME_CLASS(CRasFrame), 
		RUNTIME_CLASS(CRasView));
	AddDocTemplate( pRasTemplate );

	CMainFrame* pMainFrame = new CMainFrame;
	if ( !pMainFrame->LoadFrame(IDR_MAINFRAME) )
		return false;
	m_pMainWnd = pMainFrame;

	pMainFrame->EnableToolTips( true );

	/* Enable drag/drop open */
	m_pMainWnd->DragAcceptFiles();

	/* Enable DDE Execute open */
	EnableShellOpen();
	RegisterShellFileTypes( true );

	/* Parse command line for standard shell commands, DDE, file open */
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	if( !ProcessShellCommand(cmdInfo) )
		return false;

	if( pMainFrame->m_WndRestoreInit == 0 )
	{	pMainFrame->ShowWindow(m_nCmdShow);
		pMainFrame->UpdateWindow();
	}

	CRasView* pView = pMainFrame->GetActiveRasView();
	if( pView )
		pView->RefreshView();

	/* RasMol Inititalization */
	if( !RasWinInit() )
	{	TRACE0("TRACE\tFailed to initialize Rasmol\n");
		return false; 
	}

	/* If preferences wrongly set */
	if( MouseMode != MMRasMol )
	{   SetMouseMode( MMRasMol );
        PrefsModified = true;
	}

	return true;
}

CDocument* CRasTopApp::OpenDocumentFile(LPCTSTR lpszFileName) 
{	CString temp = lpszFileName;
	CRasDoc* pDoc = CRasDoc::OpenRSMFile(temp);
	return(pDoc);
}

void CRasTopApp::OnFileOpenRasDoc() 
{	CWinApp::OnFileOpen();	}

void CRasTopApp::OnFileNewRasDoc() 
{	// Save the active document data before opening a new one
	GETFRAME
	CRasFrame *pChild = (CRasFrame *) pFrame->GetActiveFrame();
	if(pChild)
	{	CRasDoc *pDoc = (CRasDoc *)pChild->GetActiveDocument( );
		if( pDoc )
		{	ASSERT(pDoc->IsKindOf(RUNTIME_CLASS(CRasDoc)));
			pDoc->ManageDisplay(false);
		}
	}
	CWinApp::OnFileNew();	
}

void CRasTopApp::OnAboutrastop() 
{	CAboutRasTop aboutDlg;
	aboutDlg.DoModal();	
}

int CRasTopApp::ExitInstance() 
{
	WritePrefs();
#ifdef EIGHTBIT			
	if(Palette)		free(Palette);
#endif
	if(BitInfo)		free(BitInfo);
	if(CurMolecule) free(CurMolecule);
	if(CurChain)	free(CurChain);
	if(CurGroup)	free(CurGroup);
	if(CurAtom)		free(CurAtom);
	if(Array)		free(Array);
	if(LookUp)		free(LookUp);
	if(HashTable)	free(HashTable);
	if(ColConst)	free(ColConst);
	UpdatePixutils();
	UpdateRender(1);
	UpdateOutfile();
	PurgeDatabase();

	return CWinApp::ExitInstance();
}

void CRasTopApp::RasTopExit()
{	CWinApp::OnAppExit();
}


/////////////////////////////////////////////////////////////////////////////
// CAboutRasTop dialog

CAboutRasTop::CAboutRasTop(CWnd* pParent /*=NULL*/)
	: CDialog(CAboutRasTop::IDD, pParent)
{	//{{AFX_DATA_INIT(CAboutRasTop)
	//}}AFX_DATA_INIT
}

void CAboutRasTop::DoDataExchange(CDataExchange* pDX)
{	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutRasTop)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutRasTop, CDialog)
	//{{AFX_MSG_MAP(CAboutRasTop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CAboutRasTop::OnInitDialog() 
{
	CDialog::OnInitDialog();
	char Text[256];

#ifdef _WIN32
    auto OSVERSIONINFO osinfo;
    auto SYSTEM_INFO sysinfo;
    register char *winver;
    register char *cpu;
    register int count;

    osinfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
#ifdef XPROCARCH
    GetVersionEx(&osinfo);
    if( osinfo.dwPlatformId == VER_PLATFORM_WIN32_NT )
    {   winver = "Windows NT";
    } else if( osinfo.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS )
    {   winver = "Windows95";
    } else if( osinfo.dwPlatformId == VER_PLATFORM_WIN32s )
    {   winver = "Win32s";
    } else winver = "Win32";
#else
    winver = "Windows";
#endif

#ifdef XPROCARCH
    if( osinfo.dwPlatformId == VER_PLATFORM_WIN32_NT )
    {   GetSystemInfo(&sysinfo);
        switch( sysinfo.wProcessorArchitecture )
        {   case PROCESSOR_ARCHITECTURE_INTEL:
                switch( sysinfo.wProcessorLevel )
                {   case 3:  cpu = "Intel 386";     break;
                    case 4:  cpu = "Intel 486";     break;
                    case 5:  cpu = "Intel Pentium"; break;
                    default: cpu = "Unknown Intel"; break;
                }
                break;

            case PROCESSOR_ARCHITECTURE_MIPS:
                switch( sysinfo.wProcessorLevel )
                {   case  1: cpu = "MIPS R2000";    break;
                    case  2: cpu = "MIPS R3000";    break;
                    case  3: cpu = "MIPS R6000";    break;
                    case  4: cpu = "MIPS R4000";    break;
                    case  6: cpu = "MIPS R6000A";   break;
                    case  9: cpu = "MIPS R10000";   break;
                    case 10: cpu = "MIPS R4200";    break;
                    case 11: cpu = "MIPS R4300";    break;
                    case 16: cpu = "MIPS R8000";    break;
                    case 32: cpu = "MIPS R4600";    break;
                    case 33: cpu = "MIPS R4700";    break;
                    case 34: cpu = "MIPS R4650";    break;
                    case 35: cpu = "MIPS R5000";    break;
                    default: cpu = "Unknown MIPS";  break;
                }
                break;

            case PROCESSOR_ARCHITECTURE_ALPHA:
                switch( sysinfo.wProcessorLevel )
                {   case 21064:  cpu = "Alpha 21064";  break;
                    case 21066:  cpu = "Alpha 21066";  break;
                    case 21164:  cpu = "Alpha 21164";  break;
                    default: cpu = "Unknown Alpha";    break;
                }
                break;

            case PROCESSOR_ARCHITECTURE_PPC:
                switch( sysinfo.wProcessorLevel )
                {   case 1:  cpu = "PPC 601";     break;
                    case 3:  cpu = "PPC 603";     break;
                    case 4:  cpu = "PPC 604";     break;
                    case 6:  cpu = "PPC 603+";    break;
                    case 9:  cpu = "PPC 604+";    break;
                    case 20: cpu = "PPC 620";     break;
                    default: cpu = "Unknown PPC"; break;
                }
                break;

            default:
                cpu = "unrecognised";
                break;
        }
    } else /* Windows 95 or Windows98 */
    {  
#endif 
        GetSystemInfo(&sysinfo);
        switch( sysinfo.dwProcessorType )
        {   case (386):   cpu = "Intel 386";       break;
            case (486):   cpu = "Intel 486";       break;
            case (586):   cpu = "Intel Pentium";   break;
            case (860):   cpu = "Intel i860";      break;
            case (2000):  cpu = "MIPS R2000";      break;
            case (3000):  cpu = "MIPS R3000";      break;
            case (4000):  cpu = "MIPS R4000";      break;
            case (4400):  cpu = "MIPS R4400";      break;
            case (4600):  cpu = "MIPS R4600";      break;
            case (5000):  cpu = "MIPS R5000";      break;
            case (8000):  cpu = "MIPS R8000";      break;
            case (10000): cpu = "MIPS R10000";     break;
            case (21064): cpu = "DEC Alpha 21064"; break;
            case (21066): cpu = "DEC Alpha 21066"; break;
            case (21164): cpu = "DEC Alpha 21164"; break;
            default:     cpu = "unrecognised";
        }
#ifdef XPROCARCH
    }
#endif

    count = sysinfo.dwNumberOfProcessors;
    if( count > 1 )
    {   sprintf(Text,"%s on %d %s CPUs\n",winver,count,cpu);
    } else sprintf(Text,"%s on a single %s CPU",winver,cpu);
#else
    register DWORD flags;
    register char *cpu;

    flags = GetWinFlags();
    if( flags & WF_CPU286 )
    {      cpu = "286";
    } else if( flags & WF_CPU386 )
    {      cpu = "386";
    } else cpu = "486";
                              
    if( !(flags&WF_80x87) )
    {   sprintf(Text,"%s without maths coprocessor",cpu);
    } else sprintf(Text,"%s with maths coprocessor",cpu); 
#endif

	this->SetDlgItemText(IDD_HARDWARE,Text);         
	return ( true );
}


/////////////////////////////////////////////////////////////////////////////
// Globals

void RasMolExit()
{	CRasTopApp* ThisApl = (CRasTopApp*) AfxGetApp( );
	ThisApl->RasTopExit();
}

void RasMolFatalExit(char *msg)
{	::MessageBox(NULL, msg,"RasMol Fatal Error!",
	MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL );
	CloseDisplay();
    exit(1);    
}

void AdviseUpdate( int )	{}


