 /**************************************************************************
 *                                                                         *
 *                                 RasTop                                  *
 *                                                                         *
 *                 Molecular Graphics Visualisation Tool                   *
 *                                                                         *
 *                           by Philippe Valadon                           *
 *                 P.O. Box 8064, La Jolla, CA 92192-8064, USA,            *
 *                       www.geneinfinity.org/rastop                       *
 *                                                                         *
 *                                *******                                  *
 *                                                                         *
 *                   Based on RasMol 2.6 by Roger Sayle                    *
 * Biomolecular Structures Group, Glaxo Wellcome Research & Development,   *
 *                      Stevenage, Hertfordshire, UK                       *
 *         Version 2.6, August 1995, Version 2.6.4, December 1998          *
 *                   Copyright (C) Roger Sayle 1992-1999                   *
 *                                                                         *
 *                                 and                                     *
 *                                                                         *
 * Arne Mueller       RasMol 2.6x1   May 1998   (C) Arne Mueller 1998      *
 * Gary Grossman and  RasMol 2.5-ucb Nov 1995   (C) UC Regents/ModularCHEM *
 * Marco Molinaro     RasMol 2.6-ucb Nov 1996       Consortium 1995, 1996  *
 * Herbert J.         RasMol 2.7.0   Mar 1999   (C) Herbert J. Bernstein   * 
 * Bernstein          RasMol 2.7.1   Jun 1999       1998-2001              *
 *                    RasMol 2.7.1.1 Jan 2001                              *
 *                    RasMol 2.7.2   Aug 2000                              *
 *                    RasMol 2.7.2.1 Apr 2001                              *
 * Philippe Valadon   RasTop 2.0     Jan 2002   (C) Philippe Valadon       *
 *                                                  2000-2002              *
 *                                                                         *
 * Please read the file NOTICE for important notices which apply to this   *
 * package. If you are not going to make changes to Rasmol, you are not    *
 * only permitted to freely make copies and distribute them, you are       *
 * encouraged to do so, provided you do the following:                     *
 *   * 1. Either include the complete documentation, especially the file   *
 *     NOTICE, with what you distribute or provide a clear indication      *
 *     where people can get a copy of the documentation; and               *
 *   * 2. Please give credit where credit is due citing the version and    *
 *     original authors properly; and                                      *
 *   * 3. Please do not give anyone the impression that the original       *
 *     authors are providing a warranty of any kind.                       *
 *                                                                         *
 * If you would like to use major pieces of Rasmol in some other program,  *
 * make modifications to Rasmol, or in some other way make what a lawyer   *
 * would call a "derived work", you are not only permitted to do so, you   *
 * are encouraged to do so. In addition to the things we discussed above,  *
 * please do the following:                                                *
 *   * 4. Please explain in your documentation how what you did differs    *
 *     from this version of Rasmol; and                                    *
 *   * 5. Please make your modified source code available.                 *
 *                                                                         *
 * This version of Rasmol is not in the public domain, but it is given     *
 * freely to the community in the hopes of advancing science. If you make  *
 * changes, please make them in a responsible manner, and please offer us  *
 * the opportunity to include those changes in future versions of Rasmol.  *
 ***************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// datadisplay.h : header file
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_DATADISPLAY_H_INCLUDED_)
#define AFX_DATADISPLAY_H_INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

extern "C"
{
#include "rasmol.h"
#include "prefer.h"
#include "molecule.h"
#include "abstree.h"
#include "command.h"
#include "outfile.h"
#include "pixutils.h"
#include "script.h"
#include "render.h"
#include "transfor.h"
#include "cmndline.h"
#include "infile.h"
#include "repres.h"
#include "multiple.h"
#include "vector.h"
#include "brotate.h"
}

/////////////////////////////////////////////////////////////////////////////
// CData 

class CData : public CObject
{
public:
	CData();
	DECLARE_DYNCREATE(CData)

// Attributes
	/*Graphics*/
public:	
LPVOID Data_Database;
int Data_XRange;
int Data_YRange;
int Data_ZRange;
Real Data_DRange;
int Data_BackR, Data_BackG, Data_BackB;

	/*Multiple*/
LPVOID Data_MoleculeList;
LPVOID Data_CurMolSet;
LPVOID Data_CenterSet;
CString Data_RSMPathName;
CString Data_SpaceName;

protected:
double Data_DialValue[10];
int Data_FileModified;

	/*molecule*/
CString Data_Info_filename;
CString Data_Info_moleculename;
CString Data_Info_classification;
CString Data_Info_date;
CString Data_Info_technique;
CString Data_Info_identcode;

CString Data_Info_spacegroup;
Real Data_Info_cellalpha;
Real Data_Info_cellbeta;
Real Data_Info_cellgamma;
Real Data_Info_cella;
Real Data_Info_cellb;
Real Data_Info_cellc;

double Data_Info_vecf2o[3];
double Data_Info_veco2f[3];
double Data_Info_matf2o[3][3];
double Data_Info_mato2f[3][3];
double Data_Info_cell[6];

Long Data_Info_bondcount;
int Data_Info_chaincount;
int Data_Info_ssbondcount;
int Data_Info_hbondcount;
int Data_cisbondcount;

int Data_Info_structsource;
int Data_Info_laddercount;
int Data_Info_helixcount;
int Data_Info_turncount;

Molecule	*Data_CurMolecule;
Chain		*Data_CurChain;
Group		*Data_CurGroup;
RAtom		*Data_CurAtom;

short Data_UserMask_radius[MAXMASK];
CString  Data_UserMask_mask[MAXMASK];
Byte  Data_UserMask_flags[MAXMASK];
Byte  Data_UserMask_r[MAXMASK];
Byte  Data_UserMask_g[MAXMASK];
Byte  Data_UserMask_b[MAXMASK];

char Data_Residue[MAXRES - MINRES][4];
char Data_ElemDesc[MAXELEM - MINELEM][12];

int Data_MainGroupCount;
int	Data_HetaGroupCount;
Long Data_HetaAtomCount;
Long Data_MainAtomCount;  
int Data_CisBondCutOff;

Long Data_MinX;
Long Data_MinY;
Long Data_MinZ;
Long Data_MaxX;
Long Data_MaxY;
Long Data_MaxZ;

int Data_HMinMaxFlag;
int Data_MMinMaxFlag;
int Data_MinMainTemp;
int Data_MaxMainTemp;
int Data_MinHetaTemp;
int Data_MaxHetaTemp;
int Data_MinMainRes;
int	Data_MaxMainRes;
int Data_MinHetaRes;
int	Data_MaxHetaRes;
int Data_MinAltl;
int Data_MaxAltl;

short Data_MinModel;
short Data_MaxModel;

Long Data_MinBondDist;
Long Data_MaxBondDist;
int Data_ElemNo;
int Data_ResNo;
int Data_HasHydrogen;
int Data_MaskCount;
int Data_NMRModel;
int Data_NullBonds;
//int Data_MarkAtoms;

int Data_HBondChainsFlag;
int Data_CapClean;

	/*Abstree*/
SymEntry *Data_SymbolTable;

	/*pixutils*/
int Data_SplineCount;
int Data_FontPS;
int Data_FontSize;
int Data_FontStroke;

	/*Script*/
int Data_KinemageFlag;

	/*Command*/
//CString Data_DataFileName;
int	Data_CommandActive;
Long Data_SelectCount;
//int	Data_Interactive;

int Data_CalcBondsFlag;

	/*Paused scripts*/
int Data_FileDepth;
int Data_IsPaused;
char Data_NameStack[STACKSIZE][1024];
int Data_LineStack[STACKSIZE];
fpos_t Data_PosStack[STACKSIZE];
char Data_AcceptData[STACKSIZE];

	/*Transfor*/
ShadeDesc Data_Shade[LastShade];
Real Data_RotX[3];
Real Data_RotY[3];
Real Data_RotZ[3];
Real Data_MOffset[3];
Long Data_CenX;
Long Data_CenY;
Long Data_CenZ;
Real Data_RCenx;
Real Data_RCeny;
Real Data_RCenz;
Long Data_ShiftS;
Real Data_LastTX;
Real Data_LastTY;
Real Data_LastTZ;
Real Data_LastRX;
Real Data_LastRY;
Real Data_LastRZ;
Real Data_WLastTX, Data_WLastTY, Data_WLastTZ;
Real Data_WLastRX, Data_WLastRY, Data_WLastRZ;
Real Data_WTransValue[3];
Real Data_WRotValue[3];      
Real Data_WAxes[3][3];
Real Data_Zoom;
Real Data_Wo[3];

Real Data_MatX[3];
Real Data_MatY[3];
Real Data_MatZ[3];
Real Data_InvX[3];
Real Data_InvY[3];
Real Data_InvZ[3];
Long Data_OrigCX;
Long Data_OrigCY;
Long Data_OrigCZ;

int Data_ScaleCount;
int Data_AltlColours[AltlDepth];

int Data_FakeSpecular ;
int Data_SpecPower;
int Data_ShadePower;
int Data_DotR,Data_DotG,Data_DotB;
int Data_LabR, Data_LabG, Data_LabB;
int Data_AxeR, Data_AxeG, Data_AxeB;
int Data_BoxCol;
int Data_UseLabelCol;
int Data_UseBackFade;
Real Data_Ambient;
int Data_UseDotCol;
int Data_DotCol;
int Data_LightX;
int Data_LightY;
int Data_LightZ;

Real Data_Scale;
Real Data_MaxZoom;
Real Data_DScale;
Real Data_IScale;
Long Data_SideLen;
Long Data_Offset;
Card Data_WorldRadius;
Card Data_WorldSize;
Card Data_LocalRadius;
int Data_XOffset;
int Data_YOffset;
int Data_ZOffset;
int Data_UseScreenClip;
int Data_ZoomRange;

int Data_Hydrogens;
int Data_HetaGroups;
int Data_DrawAtoms;
int Data_MaxAtomRadius;
int Data_DrawBonds;
int Data_MaxBondRadius;
int Data_DrawRibbon;
int Data_DrawStars;
int Data_ZoneBoth;

	/*Render*/
int Data_UseDepthCue;
int Data_DepthCueMode;
int Data_UseStereo;
int Data_StereoView;
int Data_UseShadow;
int Data_DisplayMode;
int Data_UseClipping;
int Data_UseSlabPlane;
int Data_UseDepthPlane;
Real Data_WClip[2];
int Data_RefreshState;
int Data_SlabMode;
int Data_SlabValue;
int Data_SlabInten;
int Data_SliceValue;
int Data_ImageRadius;
int Data_ImageSize;
int Data_SSBondMode;
int Data_HBondMode;
double Data_StereoAngle;
int Data_RotMode;
int Data_DrawBoundBox;
int Data_DrawAxes;
int Data_DrawWorldAxes;
int Data_DrawDoubleBonds;
int Data_DrawUnitCell;
Real Data_IVoxRatio;
int Data_VoxelsClean;

	/*Repres*/
DotStruct *Data_DotPtr;
Monitor *Data_MonitList;
Label *Data_LabelList;
int Data_CartoonHeight;
int Data_SolventDots;
int Data_ProbeRadius;
int Data_DotDensity;
int Data_DotSize;
int Data_DrawMonitDistance;
int Data_DrawBetaArrows;

	/*Outfile*/
int Data_UseTransparent;
int Data_UseOutLine;

	/*brotate*/
BondRot *Data_BondSelected;
BondRot *Data_RotBondList;
BondOrder *Data_BondOrderList;
RAtom  *Data_BSrcAtom;
RAtom  *Data_BDstAtom;
Real Data_BAxis[3];
Real Data_BRotValue, Data_BLastRot;

// Operations
public:
	BOOL RegenerateData();
	BOOL SaveData();
	virtual ~CData();

protected:
	int Regenerate_Flag;
	void CopyString(char *des, CString src);
};

//{{AFX_INSERT_LOCATION}}

#endif // !defined(AFX_DATADISPLAY_H_INCLUDED_)
