 /**************************************************************************
 *                                                                         *
 *                                 RasTop                                  *
 *                                                                         *
 *                 Molecular Graphics Visualisation Tool                   *
 *                                                                         *
 *                           by Philippe Valadon                           *
 *                 P.O. Box 8064, La Jolla, CA 92192-8064, USA,            *
 *                       www.geneinfinity.org/rastop                       *
 *                                                                         *
 *                                *******                                  *
 *                                                                         *
 *                   Based on RasMol 2.6 by Roger Sayle                    *
 * Biomolecular Structures Group, Glaxo Wellcome Research & Development,   *
 *                      Stevenage, Hertfordshire, UK                       *
 *         Version 2.6, August 1995, Version 2.6.4, December 1998          *
 *                   Copyright (C) Roger Sayle 1992-1999                   *
 *                                                                         *
 *                                 and                                     *
 *                                                                         *
 * Arne Mueller       RasMol 2.6x1   May 1998   (C) Arne Mueller 1998      *
 * Gary Grossman and  RasMol 2.5-ucb Nov 1995   (C) UC Regents/ModularCHEM *
 * Marco Molinaro     RasMol 2.6-ucb Nov 1996       Consortium 1995, 1996  *
 * Herbert J.         RasMol 2.7.0   Mar 1999   (C) Herbert J. Bernstein   * 
 * Bernstein          RasMol 2.7.1   Jun 1999       1998-2001              *
 *                    RasMol 2.7.1.1 Jan 2001                              *
 *                    RasMol 2.7.2   Aug 2000                              *
 *                    RasMol 2.7.2.1 Apr 2001                              *
 * Philippe Valadon   RasTop 2.0     Jan 2002   (C) Philippe Valadon       *
 *                                                  2000-2002              *
 *                                                                         *
 * Please read the file NOTICE for important notices which apply to this   *
 * package. If you are not going to make changes to Rasmol, you are not    *
 * only permitted to freely make copies and distribute them, you are       *
 * encouraged to do so, provided you do the following:                     *
 *   * 1. Either include the complete documentation, especially the file   *
 *     NOTICE, with what you distribute or provide a clear indication      *
 *     where people can get a copy of the documentation; and               *
 *   * 2. Please give credit where credit is due citing the version and    *
 *     original authors properly; and                                      *
 *   * 3. Please do not give anyone the impression that the original       *
 *     authors are providing a warranty of any kind.                       *
 *                                                                         *
 * If you would like to use major pieces of Rasmol in some other program,  *
 * make modifications to Rasmol, or in some other way make what a lawyer   *
 * would call a "derived work", you are not only permitted to do so, you   *
 * are encouraged to do so. In addition to the things we discussed above,  *
 * please do the following:                                                *
 *   * 4. Please explain in your documentation how what you did differs    *
 *     from this version of Rasmol; and                                    *
 *   * 5. Please make your modified source code available.                 *
 *                                                                         *
 * This version of Rasmol is not in the public domain, but it is given     *
 * freely to the community in the hopes of advancing science. If you make  *
 * changes, please make them in a responsible manner, and please offer us  *
 * the opportunity to include those changes in future versions of Rasmol.  *
 ***************************************************************************/

/* PV 5/2/2 File modified: Corrected carbon selection */

/////////////////////////////////////////////////////////////////////////////
// selectbar.h 
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SELECTBAR_H_)
#define AFX_SELECTBAR_H_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


// Set and Commands
typedef struct {
    char	*set;
    char	*command;
} SetCommand;

static SetCommand ElementList[] = 
{	
	{ "elements"            ,""             },
	{ "--------------------",""             },
	{ "C"                   ,"*.c???"       }, /* elemno 12 */
	{ "H"                   ,"*.h???"       },
	{ "O"                   ,"*.o???"       },
	{ "N"                   ,"*.n???"       },
	{ "S"                   ,"*.s???"       },
	{ "P"                   ,"*.p???"       },
	{ "--------------------",""             },
	{ "HOH"                 ,"HOH"          },
	{ "DOD"                 ,"DOD"          },
	{ "PO4"                 ,"PO4"          },
	{ "SO4"                 ,"SO4"          },
	{ "--------------------",""             },
	{ "A"                   ,"A"            },
	{ "C"                   ,"C"            },
	{ "G"                   ,"G"            },
	{ "T"                   ,"T"            },
	{ "U"                   ,"U"            },
	{ "A+G - Pur"           ,"purine"       },
	{ "C+T - Pyr"           ,"pyrimidine"   },
	{ "A+T"                 ,"at"           },
	{ "C+G"                 ,"cg"           },
	{ "--------------------",""             },
	{ "A - ala"             ,"ALA"          },
	{ "N - asn"             ,"ASN"          },
	{ "D - asp"             ,"ASP"          },
	{ "R - arg"             ,"ARG"          },
	{ "C - cys"             ,"CYS"          },
	{ "Q - gln"             ,"GLN"          },
	{ "E - glu"             ,"GLU"          },
	{ "G - gly"             ,"GLY"          },
	{ "H - his"             ,"HIS"          },
	{ "I - ile"             ,"ILE"          },
	{ "L - leu"             ,"LEU"          },
	{ "K - lys"             ,"LYS"          },
	{ "M - met"             ,"MET"          },
	{ "F - phe"             ,"PHE"          },
	{ "P - pro"             ,"PRO"          },
	{ "S - ser"             ,"SER"          },
	{ "T - thr"             ,"THR"          },
	{ "W - trp"             ,"TRP"          },
	{ "Y - tyr"             ,"TYR"          },
	{ "V - val"             ,"VAL"          },
	{ ""                    ,""             }
};

static SetCommand PropertyList[] = 
{	
	{ "properties"          ,""             },
	{ "--------------------",""             },
	{ "all"                 ,"all"          },
	{ "protein"             ,"protein"      },
	{ "nucleic"             ,"nucleic"      },
	{ "dna"                 ,"dna"          },
	{ "rna"                 ,"rna"          },
	{ "ligand"              ,"ligand"       },
	{ "water"               ,"water"        },
	{ "solvent"             ,"solvent"      },
	{ "ion"                 ,"ion"          },
	{ "hydrogen"            ,"hydrogen"     },
	{ "hetero atom"         ,"hetero"       },
	{ "bonded"              ,"bonded"       },
	{ "--------------------",""             },
	{ "main chain"          ,"mainchain"    },
	{ "side chain"          ,"sidechain"    },
	{ "backbone"            ,"backbone"     },
	{ "helix"               ,"helix"        },
	{ "sheet"               ,"sheet"        },
	{ "turn"                ,"turn"         },
	{ "surface"             ,"surface"      },
	{ "buried"              ,"buried"       },
	{ "alpha"               ,"alpha"	    },
	{ "amino"               ,"amino"	    },
	{ "cis-bonded"          ,"cisbonded"    },
	{ "cystine"	            ,"cystine"      },
	{ "--------------------",""             },
	{ "charged"             ,"charged"      },
	{ "acidic"              ,"acidic"	    },
	{ "basic"               ,"basic"	    },
	{ "neutral"             ,"neutral"      },
	{ "polar"               ,"polar"	    },
	{ "hydrophobic"         ,"hydrophobic"  },
	{ "aliphatic"           ,"aliphatic"    },
	{ "aromatic"            ,"aromatic"	    },
	{ "small"               ,"small"	    },
	{ "medium"	            ,"medium"       },
	{ "large"	            ,"large"        },
	{ "acyclic"             ,"acyclic"      },
	{ "cyclic"	            ,"cyclic"       },
	{ ""                    ,""             }
};

static SetCommand UserList[] = 
{	
	{ "user sets"           ,"#set#"        },
	{ "--------------------",""             },
	{ ""                    ,""             }
};


/////////////////////////////////////////////////////////////////////////////
// CSelectBox combo

class CSelectBox : public CComboBox
{
	//{{AFX_VIRTUAL(CSelectBox)
	//}}AFX_VIRTUAL

public:
	CSelectBox();
	virtual ~CSelectBox();
	BOOL Init(CToolBar* pParentWnd, const RECT& rect, UINT nID, int Index, SetCommand *List);

protected:

	SetCommand* SetList;

	//{{AFX_MSG(CSelectBox)
	afx_msg void OnSelchange();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};




/////////////////////////////////////////////////////////////////////////////
// CSelected box

class CSelected : public CStatic 
{
	//{{AFX_VIRTUAL(CSelected)
	//}}AFX_VIRTUAL

public:
	CSelected();
	virtual ~CSelected();
	BOOL Init(CToolBar* pParentWnd, const RECT& rect, UINT nID, int Index);
    void ChangeSelection( CString &Selection );

protected:
	//{{AFX_MSG(CSelectBox)
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
// CSelectBar toolbar

class CSelectBar : public CToolBar
{
// Construction
public:
	CSelectBar();
	BOOL Init(CWnd* pParentWnd);
	CSelected m_Selected;

protected:
	CSelectBox m_ElementBox;
	CSelectBox m_PropertyBox;
	CSelectBox m_UserSetBox;

// Attributes
public:

// Operations
	void SetBarPalette(BOOL bDraw);
	void AddKeyword( CString& Key );
	void ResetBox(BOOL Status);

public:

// Overrides
	//{{AFX_VIRTUAL(CSelectBar)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSelectBar();

protected:

	//{{AFX_MSG(CSelectBar)
	afx_msg void OnWindowPosChanged(WINDOWPOS FAR* lpwndpos);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}

#endif // !defined(AFX_SELECTBAR_H_)
