package edu.sdsc.sirius.viewers.RamachandranViewerImpl;

import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.*;
import edu.sdsc.mbt.viewables.*;
import edu.sdsc.sirius.viewers.*;

public class RamachandranViewerDialog extends JDialog {
	
	private RamachandranViewer viewer;
	private JFrame parent;
	
	private int width = 595;
	private int height = 810;
	
	private JPanel basePanel;
	
	public RamachandranViewerDialog(JFrame p, RamachandranViewer v){
		
		super(p, "Ramachandran Plot Viewer", false);
		
		this.parent = p;
		this.viewer = v;
				
		basePanel = new JPanel();
		basePanel.setLayout(new BorderLayout());
		basePanel.add(viewer, BorderLayout.CENTER);
		getContentPane().add(basePanel);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				viewer.destructor();
				setVisible(false);
				dispose();
			}
			
			public void windowActivated( WindowEvent event ){
				//save the position of the frame
				if (StylesPreferences.dockRama){
					Dimension dim = getToolkit().getScreenSize();
					if ((parent.getX() + parent.getWidth() + width) > dim.getWidth()){
						setBounds(dim.width - width, parent.getY(), width, height);
					}
					else{
						setBounds(parent.getWidth()+parent.getX(), parent.getY(), width, height);
					}
				}
			}
		});
		
		v.setDialog(this);
		
		//position the window
		Dimension dim = getToolkit().getScreenSize();
		
		//position the panel next to the main window on the right
		//if it ends up being wider than screen, fit it to the width of the screen
		if ((parent.getWidth() + width) > dim.getWidth()){
			setBounds(dim.width - width, parent.getY(), width, height);
		}
		else{
			setBounds(parent.getWidth(), parent.getY(), width, height);
		}
		
		setSize(width,height);
		setResizable(false);
		setVisible(true);
		
	}
	
	public RamachandranViewer getViewer(){
		return viewer;
	}
	
	public void dockDialog(){
		Dimension dim = getToolkit().getScreenSize();
		if ((parent.getX() + parent.getWidth() + width) > dim.getWidth()){
			setBounds(dim.width - width, parent.getY(), width, height);
		}
		else{
			setBounds(parent.getWidth()+parent.getX(), parent.getY(), width, height);
		}
	}
	
}